#include "mbed.h"
#include "ESP8266.h"
#include "nRF24L01P.h"
 
Serial pc(USBTX,USBRX);
//nRF24L01P Intialisation
nRF24L01P my_nrf24l01p(PTD2, PTD3, PTD1, PTD0, PTD5, PTD4);    // mosi, miso, sck, csn, ce, irq
DigitalOut gled(LED2);
//PwmOut RedLed(LED1);


//wifi UART port and baud rate
ESP8266 wifi(PTE0, PTE1, 115200); 

//buffers for wifi library
char snd[255],resp[1000];
char http_cmd[300], comm[300];

int timeout = 3000; //timeout for wifi commands

//SSID and password for connection
#define SSID "Major"//Change this as well
#define PASS "chikku123"//Also the password

//Remote IP
#define IP "192.168.2.3"//IP of your computer on the network, so as to connect to phant thru the computer

//Define global variables
char count[2];
char RxDataCnt;
char temp;
float value,value1;

//Public and private keys for phant
char* Public_Key = "4J1LAGyxXOF6MN8r9G5x";
char* Private_Key = "4J1LAGyxXOF6MN8r9G5x";
 
//Wifi init function
void wifi_initialize(void){
    
    pc.printf("******** Resetting wifi module ********\r\n");
    wifi.Reset();
    
    //wait for 5 seconds for response, else display no response receiveed
    if (wifi.RcvReply(resp, 5000))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response");
    
    pc.printf("******** Setting Station mode of wifi with AP ********\r\n");
    wifi.SetMode(1);    // set transparent  mode
    if (wifi.RcvReply(resp, timeout))    //receive a response from ESP
        pc.printf("%s",resp);    //Print the response onscreen
    else
        pc.printf("No response while setting mode. \r\n");
    
    pc.printf("******** Joining network with SSID and PASS ********\r\n");
    wifi.Join(SSID, PASS);     
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);   
    else
        pc.printf("No response while connecting to network \r\n");
        
    pc.printf("******** Getting IP and MAC of module ********\r\n");
    wifi.GetIP(resp);     
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response while getting IP \r\n");
        
}

void wifi_send(void){
    
    pc.printf("******** Setting WIFI UART passthrough ********\r\n");
    wifi.setTransparent();          
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response while setting wifi passthrough. \r\n");
    wait(1);
    
    pc.printf("******** Setting single connection mode ********\r\n");
    wifi.SetSingle();             
    wifi.RcvReply(resp, timeout);
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response while setting single connection \r\n");
    wait(1);
    
    pc.printf("******** Starting TCP connection on IP and port ********\r\n");
    wifi.startTCPConn(IP, 8080);    //cipstart
    wifi.RcvReply(resp, timeout);
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response while starting TCP connection \r\n");
    wait(1);
    
    //create link 
    sprintf(http_cmd,"/input/%s?private_key=%s&pot=%.2f&ldr=%.2f",Public_Key,Private_Key,value,value1); 
    
    pc.printf("******** Sending URL to wifi ********\r\n");
    wifi.sendURL(http_cmd, comm);   //cipsend and get command
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response while sending URL \r\n");
    
    //wifi.SendCMD("AT+CIPCLOSE"); //Close the connection to server
    //wifi.RcvReply(resp, timeout);
    //pc.printf("%s", resp);
}

int main () 
{
    float tmp[2];
    //Intializing the values
    count[0] = 0x01;
    count[1] = 0x01;
    
    value = 0x01;
    value1 = 0x01;

    //Intialise WiFi Module
    wifi_initialize();
    
    //Intialise nRF module
    my_nrf24l01p.powerUp();
    my_nrf24l01p.setRfFrequency(2440);
 
    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );
 
    pc.printf( "Recieveing data from several sensors\r\n" );
    
    RxDataCnt = 2;
    my_nrf24l01p.setTransferSize( RxDataCnt );
    
    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();
    
    while (1) 
    {
        if(my_nrf24l01p.readable())
        {
            //Read data into the recieve buffer
            temp = my_nrf24l01p.read(NRF24L01P_PIPE_P0,count,RxDataCnt);
            pc.printf("cnt %d = %d %d \r \n",temp,count[0],count[1]);
            tmp[0] = count[0]/255;
            tmp[1] = count[1]/255;
            
            value = 3.3*tmp[0];
            value1 = 3.3*tmp[1];
            
            pc.printf("Pot = %dmV LDR = %dmV \r \n",value,value1);
            
//          Togle LED2 (to help debug nRF24L01+ ->  Host communication)
            gled = !gled;        
            wait_ms(10);
        }
        //Send the data over wifi
        wifi_send();
        wait(1);
    }
}