// LSM9DS90/lcd Demo
// ECE 4180 Lab Code Template

#include "mbed.h"
#include "LSM9DS0.h"
#include "uLCD_4DGL.h"

// uncomment this line to enable the lcd for Part 4 of the lab


// SDO_XM and SDO_G are pulled up, so our addresses are:
#define LSM9DS0_XM_ADDR  0x1D // Would be 0x1E if SDO_XM is LOW
#define LSM9DS0_G_ADDR   0x6B // Would be 0x6A if SDO_G is LOW

// refresh time. set to 500 for part 2 and 50 for part 4
#define REFRESH_TIME_MS 2000

// Verify that the pin assignments below match your breadboard
LSM9DS0 imu(p9, p10, LSM9DS0_G_ADDR, LSM9DS0_XM_ADDR);
Serial pc(USBTX, USBRX);



uLCD_4DGL lcd(p28, p27, p30);


//Init Serial port and LSM9DS0 chip
void setup()
{
#ifdef PART_4
	lcd.baudrate(3000000);
	lcd.background_color(0);
	lcd.cls();
	
	lcd.printf("Initializing...");
#endif

	// Use the begin() function to initialize the LSM9DS0 library.
    // You can either call it with no parameters (the easy way):
    uint16_t status = imu.begin();

    //Make sure communication is working
    lcd.printf("LSM9DS0 WHO_AM_I's returned: 0x%X\n", status);
    lcd.printf("Should be 0x49D4\n\n");
    wait(5.0);
}


float oldX = 0;
float oldY = 0;
float oldZ = 0;
float x= 0;
float y = 0;
float z  = 0;

float posx = 0;
float velx = 0;
float oldPosx = 0;
float oldVelx = 0;

float posy = 0;
float vely = 0;
float oldPosy = 0;
float oldVely = 0;

float posz = 0;
float velz = 0;
float oldPosz = 0;
float oldVelz = 0;

int main()
{
    setup();  //Setup sensor and Serial
    pc.printf("------ LSM0DS0 Demo -----------\n");

    while (true)
    {
    	  lcd.cls();
    	
          imu.calcPitchRoll();
          lcd.printf("Pitch: ");
    	  lcd.printf("%2f\n",imu.pitch);
    	  lcd.printf("Roll: ");
          lcd.printf("%2f\n",imu.roll);
          
         
          lcd.printf("X Accel: %2f\n",imu.ax);
          lcd.printf(", ");
          lcd.printf("Y Accel:%2f\n",imu.ay);
          lcd.printf(", ");
          lcd.printf("Z Accel: %2f\n",imu.az);           
		
	      velx = oldVelx + REFRESH_TIME_MS * oldX/1000; 	
	      posx = oldPosx + REFRESH_TIME_MS * oldVelx/1000;
	    
	      vely = oldVely + REFRESH_TIME_MS * oldY/1000; 	
	      posy = oldPosy + REFRESH_TIME_MS * oldVely/1000;
	    
	      velz = oldVelz + REFRESH_TIME_MS * oldZ/1000; 	
	      posz = oldPosx + REFRESH_TIME_MS * oldVelz/1000;
	       	
    	
    	  lcd.printf("X Vel: %2f\n",velx);
          lcd.printf(", ");
          lcd.printf("Y Vel:%2f\n",vely);
          lcd.printf(", ");
          lcd.printf("Z Vel: %2f\n",velz);  
    	
    	
    	
    	
    	  oldVelx = velx;
    	  oldPosx = posx;
    	  oldVely = vely;
    	  oldPosy = posy;
    	  oldPosz = posz;
    	  oldVelz = velz;
    	  oldX = imu.ax;
		  oldY = imu.ay;
		  oldZ = imu.az;

		
		wait_ms(REFRESH_TIME_MS);
	}
}
