#include "mbed.h"
#include "TMP36.h"
#include "Motor.h"
#include <math.h>

TMP36 tempSensor(p15);  // Uses TMP36.h to display temperature in Celcius
Serial xbee1(p28, p27); // TX, RX
Motor m(p21, p19, p20); // pwm, fwd, rev
DigitalOut rst(p11); // RST (RESET)
DigitalOut redLED(p5);




char *float2str(float float_num);

int main(){
    rst = 0;
    wait_ms(1);
    rst = 1;
    wait_ms(1);
    
    float temp = 0.0;
    float fanspeed;
    float fanratio;
    
    xbee1.baud(9600);
    
    while (1){
        temp = tempSensor;
        if (temp > 26.0){
            fanratio = temp/26;
            fanspeed = exp(fanratio) - 2.2;
            redLED = 1;
        }
        else{
            fanspeed = 0.0;
            redLED = 0;
        }
        m.speed(fanspeed);
        
        xbee1.printf("%.1f\n\r",temp);
        wait(1);
    }
    
}

    