#include "mbed.h"
#include "MQ7.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
MQ7 sensor(p21, p22); // ALR, HSW

int main() {
    
    while(1) {
        led1 = 0;
        led2 = 0;
        led3 = 0;
        
        // Purge the device for 60 sec
        sensor.setHeat(1.0f); // supply full 5V to module
        led1 = 1; // Turn on only LED1 during Purge phase
        for (int i = 0; i < 60; i++){
            wait(1); // wait 60 seconds
        }
        
        // Purge complete
        // Sense the device for 90 sec 
        sensor.setHeat(0.28f); // supply 1.4V to module
        led1 = 0; 
        led2 = 1; // Turn on only LED2 during Sense phase
        for (int i = 0; i < 90; i++){
            if (sensor.getAlarm() == 1)
                led3 = 1; // Turn on LED3 if CO gas levels reached
            wait(1); 
        }
        // Sense complete, start over
        wait(0.5);
    }
}
