/*
 * Le 12 novembre 2019
 * Microcontroleurs et reseaux
 * 
 * Bruno St-Georges & Benjamin Lapointe
 * LPC1768
 * 
 * TP3 - TCPServer
 * Ce programme sert a heberger un serveur TCP sur une carte mbed LPC1768 qui relie le TCPsocket client (script python) 
 * aux deux PICs(noeuds lumiere et temperature) connectes sur le bus CAN. Un connecteur Mag-Jack est connecte sur les ports TD+/- et RD+/-
 * du LPC1768 pour permettre la communication Ethernet.
 * 
 * Connexions externes:
 *  CANBus (p9,p10)
 *  Mag-Jack (Ethernet pins)
 *
 *  Couleurs offertes pour le module de lumiere:
 *  C: Cyan
 *  L: Lime
 *  M: Magenta
 *  G: Gold
 *  F: Forest
 *
 */

#include "mbed.h"
#include "EthernetInterface.h"
 
#define ECHO_SERVER_PORT   69

// Fonction d'appel periodique
Ticker ticker;
 
// Bus CAN
CAN canbus(p9, p10);

// Variables
CANMessage msg,msg2;
bool flag_temp = 0, flag_lum = 0;
char etat_temp[2] = {0,0}, etat_lum[2] = {0,0};
char lect_temp[2] = {0,0}, lect_lum[1] = {0};


// Port Serie
Serial pc(USBTX, USBRX);

// LED active a l'envoi de trames CAN
DigitalOut LED(LED1);  
DigitalOut DEL(LED2);

// Fonction d'envoi - appel aux 100ms
void send() {
    
    if(flag_temp){      // Message CAN de temperature
        LED = not LED;
        flag_temp = 0;
        msg2.id = 0x300;
        msg2.data[0] = etat_temp[0];
        msg2.data[1] = etat_temp[1];
        canbus.write(msg2);
    }
    else if(flag_lum){  // Message CAN de lumiere
        DEL = not DEL;
        flag_lum = 0;
        msg2.id = 0x400;
        msg2.data[0] = etat_lum[0];
        msg2.data[1] = etat_lum[1];
        canbus.write(msg2);
    }
}
 
int main (void) {
    EthernetInterface eth;
    eth.init(); // Use DHCP
    eth.connect();
    printf("\nServer IP Address is %s\n", eth.getIPAddress());
    
    TCPSocketServer server;
    server.bind(ECHO_SERVER_PORT);
    server.listen();
    
    canbus.frequency(125000);       // Bus CAN a 125kHz
    ticker.attach(&send, 0.1);      // Attache du ticker a la fonction periodique d'envoi
    
    while (true) {
        printf("\nWait for new connection...\n");
        TCPSocketConnection client;
        server.accept(client);
        client.set_blocking(false, 1500); // Timeout after (1.5)s
        
        printf("Connection from: %s\n", client.get_address());
        char buffer[256];
        while (true) {
            
            //--------------------------------------------
            // Traitement de la trame recue sur le bus CAN
            //--------------------------------------------
            if(canbus.read(msg)){       // Verifie si une trame a ete recue sur le bus CAN
                if(msg.id == 0x301){
                    lect_temp[0] = msg.data[0];     // Dizaines
                    lect_temp[1] = msg.data[1];     // Unites
                }
                if(msg.id == 0x401){
                    lect_lum[0] = msg.data[0];
                }
            }
            
            //--------------------------------------------
            // Traitement de la trame recue du TCPclient
            //--------------------------------------------
            int n = client.receive(buffer, sizeof(buffer));
            printf("n value :'%s'\n",n);
            if (n <= 0) break;
            
            // print received message to terminal
            buffer[n] = '\0';
            printf("Received message from Client :'%s'\n",buffer);
                
            //-------------------------------------------    
            // Traitement du statut
            //-------------------------------------------
            if(buffer[0] == 'S'){   // Statut
                if(buffer[1] == 'T'){   // Temp
                    printf("Temp = %c",&lect_temp);
                    client.send((char*)&lect_temp, 2);       
                    
                }
                else if(buffer[1] == 'L'){  // Lum
                    printf("Lum = %c", &lect_lum);
                    client.send((char*)&lect_lum,1);  
                            
                }
            } 
            
            //--------------------------------------------
            // Traitement de la commande
            //--------------------------------------------
            if(buffer[0] == 'C'){               // Commande
                if(buffer[1] == 'L'){           // Lumiere
                    etat_lum[0] = buffer[2];    // Etat demande
                    etat_lum[1] = buffer[3];    // Couleur choisie  
                    flag_lum = 1;
                }
                if(buffer[1] == 'T'){   // Temperature
                    etat_temp[0] = buffer[2];   // Temperature demandee (dizaines)
                    etat_temp[1] = buffer[3];   // Temperature demandee (unites)
                    flag_temp = 1;
                }
            }
        }    
        client.close();
    }
}
 