#include "mbed.h"

AnalogIn analog_value(PA_0);

I2C i2c(I2C_SDA,I2C_SCL);
Serial PC(USBTX, USBRX);

// Programme principal
int main()
{
    // Declaration des variables
    float mesure;
    float temp;
    char nb[1];                 // Tableau de donnees
    const int POT = 0xA9;       // Adresse du potentiometre

    while(1) {

        // Conversion
        mesure = analog_value.read();   // Assigne une valeur de 0.0 à 1.0 a mesure
        temp = mesure * 330;            // Conversion en degres Celsius
        
        // Affichage de la temperature
        PC.printf("Temperature = %u C",(unsigned)temp);
        
        // Envoi au pot
        nb[0] = 256 * mesure;
        i2c.write(POT,nb,1,0);
    }
}
