#include "mbed.h"

AnalogIn analog_value(PA_0);    // Entree analogique
Serial PC(USBTX, USBRX);        // Port USB
I2C i2c(I2C_SDA,I2C_SCL);       // Port I2C

Ticker enregist;        // Fonction d'ecriture dans la EEPROM

// Declaration des variables
float mesure,temp;
int compte = 0;
char data[1] = {};
const int addr = 0xA0;

void enregistre(){
    
    // Conversion
    mesure = analog_value.read();   // Assigne une valeur de 0.0 à 1.0 a mesure
    temp = mesure * 330;            // Conversion en degres Celsius
    data[1] = (char)temp;           // Enregistrement dans data
    
    // Enregistrement
    i2c.write(addr,data,1,0);
    
    // Verification du temps ecoule
    compte = compte +1;
    if(compte == 599){
        enregist.detach();   
    } 
}

int main()
{
    enregist.attach(&enregistre,0.1); // Ticker appele a toutes les 100 ms
    while(1) {
        // Attente
    }
}
