/*     
*   Copyright (c) 2015, Baser Kandehir, baser.kandehir@ieee.metu.edu.tr
*
*   Permission is hereby granted, free of charge, to any person obtaining a copy
*   of this software and associated documentation files (the "Software"), to deal
*   in the Software without restriction, including without limitation the rights
*   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
*   copies of the Software, and to permit persons to whom the Software is
*   furnished to do so, subject to the following conditions:
*
*   The above copyright notice and this permission notice shall be included in
*   all copies or substantial portions of the Software.
*
*   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
*   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
*   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
*   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
*   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
*   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
*   THE SOFTWARE.
*
*/

// Some part of the code is adapted from Adafruit HMC5883 library

#ifndef HMC5883L_H
#define HMC5883L_H

#include "mbed.h"
#include "math.h"
#define M_PI 3.14159265359 
#define PI 3.14159265359 
#define GAUSS_TO_MICROTESLA 100
#define HMC5883L_ADDRESS 0x3C

/* Register Definitions */
#define CONFIG_A     0x00
#define CONFIG_B     0x01
#define MODE         0x02
#define OUT_X_MSB    0x03
#define OUT_X_LSB    0x04
#define OUT_Z_MSB    0x05
#define OUT_Z_LSB    0x06
#define OUT_Y_MSB    0x07
#define OUT_Y_LSB    0x08
#define STATUS       0x09
#define ID_A         0x0A
#define ID_B         0x0B
#define ID_C         0x0C
#define COMPASS_SCALE_088  0x00 << 2
#define COMPASS_SCALE_130  0x01 << 2
#define COMPASS_SCALE_190  0x02 << 2
#define COMPASS_SCALE_250  0x03 << 2
#define COMPASS_SCALE_400  0x04 << 2
#define COMPASS_SCALE_470  0x05 << 2
#define COMPASS_SCALE_560  0x06 << 2
#define COMPASS_SCALE_810  0x07 << 2

//  xxXXXYYYZZZxxxxx
//  ORIENTATION: 
#define COMPASS_NORTH 0x00 
#define COMPASS_SOUTH 0x01
#define COMPASS_WEST  0x02
#define COMPASS_EAST  0x03
#define COMPASS_UP    0x04
#define COMPASS_DOWN  0x05
#define COMPASS_CONTINUOUS 0x00
#define COMPASS_SINGLE     0x01
#define COMPASS_IDLE       0x02


// When "pointing" north, define the direction of each of the silkscreen'd arrows
// (imagine the Z arrow points out of the top of the device) only N/S/E/W are allowed
#define COMPASS_HORIZONTAL_X_NORTH  ( (COMPASS_NORTH << 6)  | (COMPASS_WEST  << 3)  | COMPASS_UP    ) << 5
#define COMPASS_HORIZONTAL_Y_NORTH  ( (COMPASS_EAST  << 6)  | (COMPASS_NORTH << 3)  | COMPASS_UP    ) << 5
#define COMPASS_VERTICAL_X_EAST     ( (COMPASS_EAST  << 6)  | (COMPASS_UP    << 3)  | COMPASS_SOUTH ) << 5
#define COMPASS_VERTICAL_Y_WEST     ( (COMPASS_UP    << 6)  | (COMPASS_WEST  << 3)  | COMPASS_SOUTH ) << 5
/* Magnetometer Gain Settings */

    
enum MagGain
{
    MagGain_088 =  0x00,      // +/- 0.88 Ga
    MagGain_13  =  0x20,      // +/- 1.3  Ga
    MagGain_19  =  0x40,      // +/- 1.9  Ga
    MagGain_25  =  0x60,      // +/- 2.5  Ga
    MagGain_40  =  0x80,      // +/- 4.0  Ga
    MagGain_47  =  0xA0,      // +/- 4.7  Ga
    MagGain_56  =  0xC0,      // +/- 5.6  Ga
    MagGain_81  =  0xE0       // +/- 8.1  Ga
};

class HMC5883L
{
    public:
        void init();
        double getHeading();
        void readMagData(float* dest);  
        void setScale(uint16_t sampling_mode );
        void setOrientation(uint16_t sampling_mode );    
    private:
        
        void writeByte(uint8_t address, uint8_t regAddress, uint8_t data);
        char readByte(uint8_t address, uint8_t regAddress);
        void readBytes(uint8_t address, uint8_t regAddress, uint8_t byteNum, uint8_t* dest);
};

#endif