/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "ble/BLE.h"
#include "nrf_error.h"

//BEACON
#include "ble/services/iBeacon.h"
#include "HMC5883L.h"
#include "ble/services/UARTService.h"
#include "ble/services/iBeacon.h"
#define NEED_CONSOLE_OUTPUT 0 /* Set this if you need debug messages on the console;
                               * it will have an impact on code-size and power consumption. */

#if NEED_CONSOLE_OUTPUT
#define DEBUG(...) { printf(__VA_ARGS__); }
#else
#define DEBUG(...) /* nothing */
#endif /* #if NEED_CONSOLE_OUTPUT */

BLE ble;
int countState = 0;
DigitalOut led1(LED1);
HMC5883L hmc5883l; 
UARTService *uartServicePtr;
bool beaconMode = false;
//BEACON
GapAdvertisingData adv_data = GapAdvertisingData();   

void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    DEBUG("Disconnected!\n\r");
    DEBUG("Restarting the advertising process\n\r");
    ble.startAdvertising();
}

float start = 0;

InterruptIn buttonReset(p6);

void resetDeg(){
    start = 0;
    countState++;
    if(countState >= 3){
        beaconMode = !beaconMode;
        }
    
}

void periodicCallback(void){

 //float magData[3];
 //   hmc5883l.readMagData(magData);
//float x = magData[0];
//float y = magData[1];
//float z = magData[2];
//char temp[200];

//snprintf(temp, 20, "%d:%d:%d", (int)x,(int)y,(int)z);
char temp[20];

float g = hmc5883l.getHeading();

if(start == 0){
    start = g;
    }
    float d = g - start;
    //POSITIVE
    if( d < 0){
      d =   d + 360;
    }
    if( d > start){
      d =  0;
    }
    //NEGATIVE 
snprintf(temp, 20, "%g deg", d);

    ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(),(uint8_t *)temp, strlen(temp));

}

//BEACON
void bleInitComplete(BLE::InitializationCompleteCallbackContext *params)
{
    BLE &ble          = params->ble;
    ble_error_t error = params->error;

    if (error != BLE_ERROR_NONE) {
        return;
    }
    
    /**
     * The Beacon payload has the following composition:
     * 128-Bit / 16byte UUID = E2 0A 39 F4 73 F5 4B C4 A1 2F 17 D1 AD 07 A9 61
     * Major/Minor  = 0x1122 / 0x3344
     * Tx Power     = 0xC8 = 200, 2's compliment is 256-200 = (-56dB)
     *
     * Note: please remember to calibrate your beacons TX Power for more accurate results.
     */
    const uint8_t uuid[] = {0xE2, 0x0A, 0x39, 0xF4, 0x73, 0xF5, 0x4B, 0xC4,
                            0xA1, 0x2F, 0x17, 0xD1, 0xAD, 0x07, 0xA9, 0x61};
    uint16_t majorNumber = 1122;
    uint16_t minorNumber = 3344;
    uint16_t txPower     = 0xC8;
    iBeacon *ibeacon = new iBeacon(ble, uuid, majorNumber, minorNumber, txPower);

    ble.gap().setAdvertisingInterval(1000); /* 1000ms. */
   
    ble.gap().startAdvertising();
}

//BEACON
void updateData(){  
 adv_data = ble.getAdvertisingData();
    adv_data.updateData(adv_data.MANUFACTURER_SPECIFIC_DATA, "ALO",3);
    ble.setAdvertisingData(adv_data);
}


int main(void){  

if(beaconMode){
    ble.init(bleInitComplete);
    
    /* SpinWait for initialization to complete. This is necessary because the
     * BLE object is used in the main loop below. */
    while (!ble.hasInitialized()) { /* spin loop */ }

    while (true) {
        ble.waitForEvent(); // allows or low power operation
    }
    }else{
    buttonReset.fall(&resetDeg);
    hmc5883l.init();
    hmc5883l.setScale(COMPASS_SCALE_130);
    hmc5883l.setOrientation(COMPASS_VERTICAL_X_EAST);
       
    Ticker ticker;
    ticker.attach(periodicCallback, 1);

    DEBUG("Initialising the nRF51822\n\r");
    ble.init();
    ble.onDisconnection(disconnectionCallback);

    
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED);
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME,
                                     (const uint8_t *)"DOOR BLE", sizeof("DOOR BLE") - 1);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS,
                                     (const uint8_t *)UARTServiceUUID_reversed, sizeof(UARTServiceUUID_reversed));

    ble.setAdvertisingInterval(1000);
    ble.startAdvertising();

    UARTService uartService(ble);
    uartServicePtr = &uartService;

    while (true) {
        ble.waitForEvent();
    }
    
    /* SpinWait for initialization to complete. This is necessary because the
     * BLE object is used in the main loop below. */
    /**   UARTService uartService(ble);
    uartServicePtr = &uartService;
    while (!ble.hasInitialized()) {  }

    while (true) {
        ble.waitForEvent(); // allows or low power operation
    }*/
    }
}
