#ifndef _devices_h_
#define _devices_h_
#include "mbed.h"
#include "funcoesSDCard.h"
#include "modbusMaster1.h"
#include "SDFileSystem.h"
#include "DS18B20_SensorTemperatura.h"
#define maxCaractereLeLinha 40
#include <cstdlib>

#define maxAlarms 300                   //Parcial de 26 Bytes Total de  
#define maxReadings 150                 //Parcial de 6 Bytes Total de   
#define maxSchedules 200                //Parcial de 8 Bytes Total de   
#define maxSchedulesExceptions 50       //Parcial de 12 Bytes Total de  

#define enderecoControladoraVirtual 0

enum {        
    modBusType_float=1,
    modBusType_bit,
    modBusType_uint8_t,
    modBusType_uint16_t,
    modBusType_uint32_t,
    modBusType_int16_t,
    modBusType_int32_t,
    IrCommandType,
    PWMCommandType
};

typedef struct _alarm{
    //Total de 26 Bytes
    uint32_t id;
    //Tempos de confirmação
    uint32_t seconds;
    //Var Read block
    uint8_t type;
    uint16_t addrModbusRead;
    uint8_t funcModbusRead;
    uint16_t regModbusRead;             
    uint8_t max; //1 Max; 0 Min
    uint8_t value[4];
    
    //Act block
    uint32_t idAct;    

    //Maquina de estados alarme    
    uint32_t secAlarm;    
    bool alarmFound;
    bool on;
}alarm;



typedef struct _reading{
    //Total de 6 Bytes
    uint8_t type;
    uint8_t addr;
    uint8_t func;
    uint16_t reg;               
    uint8_t numRegs;        
}reading;

typedef struct _scheduleException{
    //Total de 8 Bytes
    uint32_t id_schedule;
    uint32_t timestamp;
}scheduleException;

typedef struct _schedule{    
    //Total de 12 Bytes
    uint32_t id;
    uint8_t weekday;
    uint16_t minute; // Minuto do dia em que será executada a ação programada
    
    //Act block
    uint32_t idAct;
    //Maquina de estados alarme
    bool actSent;
}schedule;



extern uint8_t numAlarms;
extern uint8_t numSchedules;
extern uint8_t numScheduleExceptions;                
extern uint16_t numReadings;
extern alarm alarms[maxAlarms] __attribute__ ((section("AHBSRAM0")));
extern reading readings[maxReadings] __attribute__ ((section("AHBSRAM0")));
extern schedule schedules[maxSchedules] __attribute__ ((section("AHBSRAM0")));
extern scheduleException scheduleExceptions[maxSchedulesExceptions] __attribute__ ((section("AHBSRAM0")));

uint8_t execAct(uint32_t);
void floatToBin(uint8_t,float *,uint8_t *);                
void uint32_t_ToBin(uint8_t,uint32_t *,uint8_t *);
void uint16_t_ToBin(uint8_t,uint16_t *,uint8_t *);
void setAlarm(char *);
void setReading(char *);
void setSchedule(char *);
void setScheduleException(char *);        
void verifyAlarms();
void verifySchedules();        
void writeReadingsToSD();
void alarmOnOff(uint32_t,bool);
int criaDevices(FILE *);
int configuraDevices(FILE *); 
void testaTudoDevices();

#endif
