#include "serialPC.h"

osTimerId serialPC::timer_pacote;
bool serialPC::startTimer_pacote;

/*Timers*/
//osTimerDef( "nomeDoTimer", "Função chamada pelo timer when match")
osTimerDef(timerProcessaPacotePC,serialPC::processaPacotePC);
/*Timers*/

void serialPC::serialPC_init(){
    //Instnciando o timer de processamento de pacotes entrantes na serial PC            
    pc.baud(115200); //Inicialização de recurso Serial uart pc com baudrate 230400
    pc.printf("Serial PC inicializado.\n");    //Exibe mensagem de inicialização da serial pc        
    
    //Criando timer_pacote
    serialPC::timer_pacote = osTimerCreate(osTimer(timerProcessaPacotePC),osTimerOnce,NULL);        
    
    //Associando função a ISR da serial PC
    pc.attach(&serialPC::isr_serialPC); //Setando uma função para ISR Serial 0 (Serial pc)
}
void serialPC::isr_serialPC(){
    uint32_t RBR = LPC_UART0->RBR;      //Reset RBR interrupt flag e captura o caractere entrante    

    bufPC.putc(RBR);
    serialPC::startTimer_pacote=true;
    osSignalSet(idThreadTimers, 0x1);                
}

void serialPC::processaPacotePC(void const *args){    
    char * bufIn;
    char *ptr;
    uint16_t bufLength = bufPC.getLength();        
    bufIn = bufPC.get();
    
    
    if(strstr(bufIn,"execAct(")){
        strtok(bufIn,"(");
        act=atoi(strtok(NULL,")"));
        boolExecAct = true;
        return;
    }
        
    if(strstr(bufIn,"modem:")!=NULL){
        bufIn = &bufIn[6];
        pc.printf("Mensagem ao modem <%s>.\r\n",bufIn);
        modemCom::sendToModem(bufIn,1,NULL,NULL,150,1,1);
        pc.printf("Mesagem do modem <%s>.\r\n",bufModem.getRowBuffer());
        return;
    }      
    
    
    if(strstr(bufIn,"escreveFlash")!=NULL){        
        NVIC_DeInit();        
        bootLoader();
    }
        
        
    if(strstr(bufIn,"config")!=NULL){        
        sdCard::exibeArquivo(&sdCard::config);
    }
    
    if(strstr(bufIn,"sensUP")!=NULL){        
        temperaturas[0]=55;
    }    
    
    if(strstr(bufIn,"sensDOWN")!=NULL){        
        temperaturas[0]=0;        
    }    
    
    if(strstr(bufIn,"devices")!=NULL){        
        sdCard::exibeArquivo(&sdCard::devices);
    }    
    
    if(strstr(bufIn,"testaTudoDevices()")!=NULL){        
        testaTudoDevices();
    }
    
    ptr=strstr(bufIn,"deleteArmazenamento");
    if(ptr){
        pc.printf("Deletando banks.\r\n");
        sdCard::deleteBanks(2);
    }    

    if(strstr(bufIn,"enviaDadosAoServer")){
        eventosRTC::rotinaEnvioDeDados=maxTentativasEnvioDados;
        modemCom::timeOutEnvioDados=maxTimeEnvioDados;
    }

    if(strstr(bufIn,"wdtReset")){
        pc.printf("Comandando Reset por wdt.\r\n");
        osDelay(50);
        diversos::wdt.kick(0.1);
        while(true);
    }
    
    if(strstr(bufIn,"debug")){
        debug = !debug;
    }
    
    if(strstr(bufIn,"xereta")){
        xeretaModem = !xeretaModem;
    }        
    
    if(strstr(bufIn,"excluiArquivoPeloNome:")!=NULL){        
        strtok(bufIn,":");
        ptr = strtok(NULL,":");
        remove(ptr);
        return;
    }
    
    if(strstr(bufIn,"excluiArquivo:devices.cfg")!=NULL){        
        sdCard::excluiArquivo(&sdCard::devices);
    }    
}
