#include "serialModem.h"
#include "modem.h"

//extern Serial pc(USBTX, USBRX); //Instancia de recurso Serial uart pc
//extern Serial modem(P0_10, P0_11); //Instancia de recurso Serial uart Modem



osTimerId serialModem::timer_pacote;
bool serialModem::startTimer_pacote;
bool serialModem::processarPacote;

/*Timers*/
//osTimerDef( "nomeDoTimer", "Função chamada pelo timer when match")
osTimerDef(timerProcessaPacoteModem,serialModem::chamaProcessaPacote);
/*Timers*/

void serialModem::chamaProcessaPacote(void const *args){
    osSignalSet(idThreadProcessaPacote,0x1);
    serialModem::processarPacote = true;
}

void serialModem::configBaud(){       
    uint32_t baud = 9600;    
    modem.baud(baud);    
    while((!modemCom::sendToModem("ATE0\r\n",1,&modemCom::status.OK,NULL,50,1,50))&&(baud <= 230400)){
        baud += 9600;
        pc.printf("\r\n Tentando %lu.\r\n",baud);
        modem.baud(baud);        
    }    
    if(baud<=230400){
        pc.printf("\r\n Conectado a %lu baud/s.\r\n",baud);    
    }else{
        pc.printf("Modem inacessivel.\r\n");
     }
}

void serialModem::serial_init(){    
    //Instnciando o timer de processamento de pacotes entrantes na serial PC        
    //Criando timer_pacote
    serialModem::timer_pacote = osTimerCreate(osTimer(timerProcessaPacoteModem),osTimerOnce,NULL);    
    //Associando função a ISR da serial PC
    modem.attach(&serialModem::isr_serial); //Setando uma função para ISR Serial 2 (Serial modem)
}
void serialModem::isr_serial(){
    uint32_t RBR = LPC_UART2->RBR;      //Reset RBR interrupt flag e captura o caractere entrante      
    bufModem.putc(RBR);
    //pc.putc(RBR);
    serialModem::startTimer_pacote=true; //Agenda o inicio do timer  na thread de manipulação de timers
    osSignalSet(idThreadTimers, 0x1); //Envia sinal para a thread de manipulação dos timers para ativar os timers agendados           
    //timeOutModem.attach(&chamaProcessaPacotePeloTimeOut, 0.1);
}
