//#include "main.h"
#ifndef _modem_h_
#define _modem_h_

#include "serialModem.h"
#include "serialPC.h"
#include "funcoesSDCard.h"
#include "cmsis_os.h"   //Nucleo do Real Time Operational System
#include "diversos.h"

#define maxTamFileSend 1048576

#define dadosStatus 1
#define dadosArmazenados 2

#define maxTimeEnvioDados 700 //Significarão 70 segundos.

#define xereta_modem

typedef struct{
    uint32_t sent;
    uint32_t received;
    uint16_t buff_in;
    uint16_t ack_waiting;
}socket_info;

typedef struct{ 
 char commandMode;
 char RSSI;
 char dnsError;
 char serverConnected; 
 char associated; 
 char operadora;
 char OK;
 char SEND_OK;
 char ERROR;
 char ServerAck;
 char STAIP[16];
 char subnetmask[16];
 char gateway[16];  
 char MAC[20];
 char IMSI[30]; 
 char ssid[40]; 
 char password[50];
 char serverIP[50]; 
 char port[6];
 char host[50];
 uint32_t periodo;
 uint32_t periodoConfiguracao;
 char SRINGsockEntrante;
 char ping; 
 char socketBufferPending;
 uint16_t socketBufferPendingLength;
 uint16_t socketBuffer_ack_waiting; 
 bool emComunicacao;
 char PROMPT_ENVIO_COMMAND_MODE;
 uint8_t timeOut;
 uint8_t recebendoArquivoDoServer;
 bool exibeBufModem;
 bool socketEntranteAtivo;
 char CLOSED;
 char busy;
 char modemResponse;
 uint8_t connIDWebServer;
 uint8_t connIDServerCommand;
 uint8_t connIDSendData;
 socket_info socketInfo[2];
 bool ALREADY_CONNECTED;
 char wifi_connected;
}modemStatus;

extern int16_t numeroDeBytesPorEnvio;
extern uint8_t connID;
extern uint16_t IPDNumBytes;
extern bool enviaSendData;
extern char *bufInPtr;
extern bool mudaRede;
extern char webServerBuff[256];

namespace modemCom{ 
    extern modemStatus status; //Struct que comporta os status do modem
    extern char* bufIn; //Ponteiro para buffer de entrada do modem;   
    extern uint32_t timeOutModem;
    extern uint16_t timeOutEnvioDados;   
    extern bool exibeEntradaPacote;
    extern bool atendendoWebServer;      
    //Funções    
    uint8_t sendToModem(char *,uint8_t,char *,char *,uint16_t,uint8_t,uint16_t);  //Função que envia strings ao modem
    void processaPacote(void const *); //Função que processa pacotes entrantes do modem
    uint8_t inicializaModem(void);
    uint8_t enviaDados();
    //void sendEscapeSequence(void);    
    char aguardaFlush(uint8_t);    //connection id 1 a 6 atualmente 1 a 2
    //uint8_t sendFileCommandMode(FILE *,bool *,char *,uint32_t,char *);
    uint8_t postFileCommandMode(char *,char *,char *,arquivoSD *);
    bool montaStatus(void);
    void leMAC(void); 
    void atendeSRING(uint8_t);       
    bool sendBufferCommandMode(uint8_t, char *, uint16_t);
    char closeConnection(uint8_t*);
    void webServer(uint8_t);
    char cipSend(uint8_t,char *,uint16_t);
    bool conectaWiFi(void);
    bool leParametrosConexaoSDCard();
    int16_t getRSSI(void);
    bool writeStatusToSD(void);
    bool verificaConexao(void);
    bool leIP(void);    
}
#endif
