#include "modem.h"

modemStatus modemCom::status;
char* modemCom::bufIn; //Ponteiro para buffer de entrada do modem;
uint32_t modemCom::timeOutModem;
bool modemCom::atendendoWebServer;
bool modemCom::exibeEntradaPacote;
int16_t numeroDeBytesPorEnvio;
uint16_t modemCom::timeOutEnvioDados;
uint8_t connID;
uint16_t IPDNumBytes;
bool enviaSendData;
char *bufInPtr;
bool mudaRede = false;
char webServerBuff[256];

void modemCom::atendeSRING(uint8_t conId){           
            //pc.printf("Atendendo a conexao entrante.\n");
            
            if(modemCom::status.emComunicacao){
                modemCom::cipSend(conId,"ocupado",7);
                pc.printf("Fechando socket chave 1.\r\n");
                modemCom::closeConnection(&modemCom::status.connIDServerCommand);
                modemCom::closeConnection(&modemCom::status.connIDWebServer);
                modemCom::closeConnection(&modemCom::status.connIDSendData);
            }
            
            modemCom::status.socketEntranteAtivo=true;            
            modemCom::status.timeOut = 30;
            modemCom::timeOutModem = 10;
            
            //pc.printf("Entrei em modemCom::atendeSRING.\r\n");
            
            while(modemCom::status.timeOut){
             if(modemCom::status.timeOut){modemCom::status.timeOut--;}
             /*//Aqui devo perguntar e pedir os dados em buffer
             */             
             osDelay(100);
            }

            //Para parar de colocar dentro do arquivo
            modemCom::status.recebendoArquivoDoServer = false;
            
            modemCom::status.serverConnected=0;
            modemCom::timeOutModem = 10;            
                        
            //Fechando o socket         
            pc.printf("Fechando socket chave 2.\r\n");               
            modemCom::closeConnection(&modemCom::status.connIDServerCommand);
            modemCom::closeConnection(&modemCom::status.connIDWebServer);
            modemCom::closeConnection(&modemCom::status.connIDSendData);
            modemCom::status.socketEntranteAtivo=false;
            modemCom::status.emComunicacao = false;
            modemCom::timeOutModem = 10;
}

bool modemCom::sendBufferCommandMode(uint8_t sId, char *buffer, uint16_t bufferLength){    
    char aux[25];
    uint16_t numeroByteSendoEnviado;

    sprintf(aux,"AT+CIPSEND=%u,%lu\r\n",sId,bufferLength);    
    if(modemCom::sendToModem(aux,1,&modemCom::status.PROMPT_ENVIO_COMMAND_MODE,NULL,500,2,1)) {    
        for(numeroByteSendoEnviado = 0; numeroByteSendoEnviado<bufferLength; numeroByteSendoEnviado++) {            
            modem.printf("%c",buffer[numeroByteSendoEnviado]);            
            if(debug){
                pc.printf("%c",buffer[numeroByteSendoEnviado]);
            }
            
        }        
        numeroByteSendoEnviado = modemCom::sendToModem(NULL,1,&modemCom::status.SEND_OK,NULL,500,1,1);
    }else{
        numeroByteSendoEnviado = false;   //Reaproveitando numeroByteSendoEnviado para resultado de retorno
     }
    return numeroByteSendoEnviado; //Reaproveitando numeroByteSendoEnviado para resultado de retorno
}   

void modemCom::leMAC(void)
{
    char *ptr;    
    if(modemCom::sendToModem("AT+CIPSTAMAC?\r\n",1,&modemCom::status.modemResponse,NULL,500,2,1)){
        //resposta: +CIPSTAMAC:"18:fe:34:f4:5f:c4"
        ptr = strtok(bufModem.getRowBuffer(),"\"");
        ptr = strtok(NULL,"\"");
        if(ptr) {
            strcpy(modemCom::status.MAC,ptr);
            //pc.printf("Lido MAC <%s>.\n",modemCom::status.MAC);
        }
    }
}



bool modemCom::writeStatusToSD(void){
    char aux[50],*ptr;
    int16_t RSSI;
    RSSI = modemCom::getRSSI();
    sdCardBuf.del();
    sdCardBuf.fill("log{status:ip=255.255.255.255;csq=",34);
    
    sprintf(aux,"%d",RSSI);
    sdCardBuf.fill(aux,strlen(aux));
    
    
    
    sprintf(aux,";fv=%s",firmVersion);    
    sdCardBuf.fill(aux,strlen(aux));    
    
    sprintf(aux,";rc=%s",resetCauses);    
    sdCardBuf.fill(aux,strlen(aux));    
    
    sprintf(aux,";imsi=%s}log",modemCom::status.MAC);    
    sdCardBuf.fill(aux,strlen(aux));
    
    //Escrevendo uma única vez o WDT
    ptr = strstr(resetCauses,",WDT");
    if(ptr!=NULL){
        ptr[0]=0;
    };
    
    //Escrevendo uma única vez o WDT
    ptr = strstr(resetCauses,",NOW");
    if(ptr!=NULL){
        ptr[0]=0;
    };
    
    return sdCard::insereDadosBank(sdCardBuf.get(),sdCardBuf.getLength());    
}

bool modemCom::montaStatus(void)
{
    if(sdCard::abreArquivo(&sdCard::status,"w")) {                
        fprintf(sdCard::status.fp,"log{status:ip:255.255.255.255;csq:30;imsi:%s}log",modemCom::status.MAC);        
        sdCard::fechaArquivo(&sdCard::status);        
        sdCard::exibeArquivo(&sdCard::status);
    } else {
        return 0;
    }
    return true;
}



uint8_t modemCom::enviaDados()
{
    uint8_t result=false;    
    pc.printf("modemCom::enviaDados[1].\r\n");
    if(!sdCard::preparaEnvio()){
        pc.printf("modemCom::enviaDados[2].\r\n");
        //pc.printf("Nao foi possivel preparar o envio.\n");
        return false;                
    }
    sdCard::verificaCurrentBank();
    pc.printf("modemCom::enviaDados[3], currentBank = %lu currentBankSending = %lu.\r\n",sdCard::currentBank,sdCard::currentBankSending);
    sdCard::getFileTam(&sdCard::bank0);
    sdCard::getFileTam(&sdCard::bank1);
    if((sdCard::bank0.bytes > 230400) || (sdCard::bank1.bytes > 230400)){
        pc.printf("Arquivo muito grande. Deletado.");
        sdCard::excluiArquivo(&sdCard::currentBankFile);
        sdCard::excluiArquivo(&sdCard::bank0);
        sdCard::excluiArquivo(&sdCard::bank1);
        return false;
    }
    switch(sdCard::currentBankSending){
        case 0:
                if(sdCard::currentBank==0){                                        
                    sdCard::modificaCurrentBank(1,0);
                }
                pc.printf("modemCom::enviaDados[4].\r\n");
                
                if(!sdCard::getFileTam(&sdCard::bank0)){
                    sdCard::modificaCurrentBank(0,1);
                }else{                
                   pc.printf("modemCom::enviaDados[11].\r\n");                   
                   if(modemCom::postFileCommandMode(modemCom::status.serverIP,modemCom::status.host,"/drome/Parser/",&sdCard::bank0)){
                   //if(modemCom::postFileCommandMode(modemCom::status.serverIP,modemCom::status.host,"/sistema/Parser/",&sdCard::bank0)){
                    pc.printf("Enviado o bank0.\r\n");
                    result = true;                    
                   }
                }
                
            break;
        case 1:
                if(sdCard::currentBank==1){                    
                    sdCard::modificaCurrentBank(0,1);
                }
                pc.printf("modemCom::enviaDados[5].\r\n");
                if(!sdCard::getFileTam(&sdCard::bank1)){
                   sdCard::modificaCurrentBank(1,0);
                }else{
                   pc.printf("modemCom::enviaDados[12].\r\n");                   
                   if(modemCom::postFileCommandMode(modemCom::status.serverIP,modemCom::status.host,"/drome/Parser/",&sdCard::bank1)){
                   //if(modemCom::postFileCommandMode(modemCom::status.serverIP,modemCom::status.host,"/sistema/Parser/",&sdCard::bank1)){
                    pc.printf("Enviado o bank1.\r\n");
                    result = true;
                   }
                 }
            break;
        case 2:
                pc.printf("modemCom::enviaDados[10].\r\n");                
                result = false;
            break;
    }    
    return result;
}



uint8_t modemCom::postFileCommandMode(char *serverIP, char *host, char *uri, arquivoSD *arquivo)
{
    #define maxRetentativasEnvioParteArquivo 20
    uint32_t numeroDePartes;
    uint16_t restoDoEnvio;
    int32_t parteSendoEnviada;
    uint16_t numeroByteSendoEnviado;
    uint16_t maxTentativas=0;
    //unsigned int result;
    char header[512];
    char aux[40];    
    uint16_t headerTam;
    uint32_t dataTam=0;
    char c;
    bool passaParaProximaParte = false;
    char nomeArquivo[50];
    uint32_t parteEnviadaAntes = 0;
    sdCard::deleteSentFiles = false;

    if(strstr(arquivo->nome,"bank0.txt")||strstr(arquivo->nome,"bank1.txt")){
        strcpy(nomeArquivo,"/sd/RAD/envio.txt");
    }else{
        strcpy(nomeArquivo,arquivo->nome);
     }

    //Para garantir que não seja duvidoso proveniente de outra conexão.
    modemCom::status.ServerAck=0;

    modemCom::status.dnsError=0;

    pc.printf("Iniciando envio de arquivo.\r\n");
    if(arquivo->bytes==0){        
        if((!sdCard::getFileTam(arquivo))||(arquivo->bytes == 0)){
            if(arquivo->bytes == 0){
                sdCard::excluiArquivo(arquivo);    
            }            
            return false;    
        }
    }
    
    pc.printf("Abrindo o socket em <%s>.\n",serverIP);
    modemCom::status.ALREADY_CONNECTED=0;
    sprintf(header,"AT+CIPSTART=1,\"TCP\",\"%s\",80\r\n",serverIP);
    if(modemCom::sendToModem(header,1,&modemCom::status.OK,NULL,20000,3,1000)){

        pc.printf("Aberto o socket em command mode.\n");
        pc.printf("Enviando arquivo com nome %s.\n",nomeArquivo);
        modemCom::status.connIDSendData=1;
        modemCom::status.serverConnected=1;
        modemCom::timeOutModem = 50;
        modemCom::status.emComunicacao = true;
    } else {
        pc.printf("Nao foi possivel Abrir o socket. Abortando tentativa.\n");
        if(modemCom::status.ALREADY_CONNECTED){
            //Socket aberto, fecho-o antes de partir.
            modemCom::closeConnection(&modemCom::status.connIDSendData);    
        }
        modemCom::timeOutModem = 20;
        modemCom::status.emComunicacao = false;
        return 0;
    }
    
    numeroDePartes = arquivo->bytes / numeroDeBytesPorEnvio;
    restoDoEnvio = arquivo->bytes % numeroDeBytesPorEnvio;
    
    
    if(xeretaModem){
        pc.printf("Iniciando o envio do arquivo de %lu bytes\nnumeroDePartes = %lu\nrestoDoEnvio = %lu\n",arquivo->bytes,numeroDePartes,restoDoEnvio);
    }
    
    if(!sdCard::abreArquivo(arquivo,"r")){
        pc.printf("Nao foi posssivel abrir o arquivo de dentro da funcao postFileCommandMode().\n");
        modemCom::status.emComunicacao = false;
        return 0;
    }        
    
    
    //Monta Header aqui!
    //application/octet-stream
    sprintf(header,"--xxBOUNDARYxx\r\nContent-Type: text/plain\r\nContent-Disposition: form-data; name=\"IMEI\"\r\n\r\n%s\r\n--xxBOUNDARYxx\r\nContent-Type: application/octet-stream\r\nContent-Disposition: form-data; name=\"file\"; filename=\"%s\"\r\n\r\n",modemCom::status.MAC,nomeArquivo);
    
    dataTam = strlen(header);   
    dataTam+=arquivo->bytes;
    dataTam+= strlen("\r\n--xxBOUNDARYxx--");
    //"/drome/parser/index.php" uri drome
    sprintf(header,"POST %s HTTP/1.1\r\nHost: %s\r\nContent-Type: multipart/form-data; boundary=xxBOUNDARYxx\r\nContent-Length: %lu\r\n\r\n",uri,host,dataTam); 
    headerTam = strlen(header); //Pego o tamanho parcial para fazer a concatenaçao a fim de predizer o tamanho do post total
    
    sprintf(&header[headerTam],"--xxBOUNDARYxx\r\nContent-Type: text/plain\r\nContent-Disposition: form-data; name=\"IMEI\"\r\n\r\n%s\r\n--xxBOUNDARYxx\r\nContent-Type: application/octet-stream\r\nContent-Disposition: form-data; name=\"file\"; filename=\"%s\"\r\n\r\n",modemCom::status.MAC,nomeArquivo);
    headerTam = strlen(header);

    sprintf(aux,"AT+CIPSEND=1,%u\r\n",headerTam);
    if(modemCom::sendToModem(aux,1,&modemCom::status.PROMPT_ENVIO_COMMAND_MODE,NULL,1000,1,1)) {
        if(!modemCom::sendToModem(header,1,&modemCom::status.SEND_OK,NULL,1000,1,1)) {            
            sdCard::fechaArquivo(arquivo);
            modemCom::status.emComunicacao = false;
            pc.printf("Cabecalho http nao enviado.\n");
            return 0;
        } else {
            pc.printf("Cabecalho http enviado.\n");
        }
    } else {
        pc.printf("Erro enviando arquivo.\n");
        sdCard::fechaArquivo(arquivo);
        modemCom::status.emComunicacao = false;
        return 0;
    }

    //Enviando as partes inteiras
    maxTentativas = maxRetentativasEnvioParteArquivo;
    for(parteSendoEnviada=0; parteSendoEnviada<numeroDePartes; parteSendoEnviada++) {
        //Aqui realizo o envio de cada parte.
        passaParaProximaParte = false;
        if((parteSendoEnviada%10)==0){
            //Kick no watchdog
            if(parteEnviadaAntes!=parteSendoEnviada){
                diversos::wdt.kick(90.0);
                parteEnviadaAntes=parteSendoEnviada;
                if(debug){pc.printf("Watchdog KICK!.");}
            }
        }
        while((maxTentativas)&&(!passaParaProximaParte)) {
            sprintf(aux,"AT+CIPSEND=1,%u\r\n",numeroDeBytesPorEnvio);
            if(modemCom::sendToModem(aux,1,&modemCom::status.PROMPT_ENVIO_COMMAND_MODE,NULL,1000,1,1)) {
                if(maxTentativas!=maxRetentativasEnvioParteArquivo) {
                    //Estou realizando reenvio desta parte logo preciso fazer fseek para a quantidade de bytes do envio anterior
                    fseek(arquivo->fp,-numeroDeBytesPorEnvio,SEEK_CUR);
                }
                if(debug){pc.printf("Numero de bytes por envio = %lu.\r\n",numeroDeBytesPorEnvio);}
                for(numeroByteSendoEnviado=0; numeroByteSendoEnviado<(numeroDeBytesPorEnvio); numeroByteSendoEnviado++) {                    
                    c = fgetc(arquivo->fp);                    
                    modem.printf("%c",c);
                    if(debug){
                        pc.printf("%c",c);
                    }
                }

                if(modemCom::sendToModem(NULL,1,&modemCom::status.SEND_OK,NULL,5000,1,1)) {
                    diversos::progressBar(parteSendoEnviada,numeroDePartes);
                    //Preciso verificar se o buffer esvaziou. Se deu "flush"
                    //if(modemCom::aguardaFlush(0)==1) {
                    //passa pra proxima parte
                    passaParaProximaParte = true;
                    maxTentativas = maxRetentativasEnvioParteArquivo;                    
                } else {
                    maxTentativas--;
                    if(maxTentativas == 1) {
                        if(debug){pc.printf("MaxTentativas dentro de envio das partes == 1, vou aguardar o flush.\n");}
                    }
                    if(maxTentativas == 0) {
                        sdCard::fechaArquivo(arquivo);
                        modemCom::status.emComunicacao = false;
                        return 0;
                    }                    
                }
            } else {
                pc.printf("Erro enviando o arquivo nao recebeu a tentativa de envio de parte inteira.\n");
                sdCard::fechaArquivo(arquivo);
                modemCom::status.emComunicacao = false;
                return 0;
            }
        }
        if(!passaParaProximaParte) {
            pc.printf("Erro enviando o arquivo nao recebeu a tentativa de envio de parte inteira.\n");
            sdCard::fechaArquivo(arquivo);
            modemCom::status.emComunicacao = false;
            return 0;
        }
    }    

    //Enviando o resto
    passaParaProximaParte = false;
    maxTentativas = maxRetentativasEnvioParteArquivo;
    while((maxTentativas)&&(!passaParaProximaParte)) {
        sprintf(aux,"AT+CIPSEND=1,%u\r\n",restoDoEnvio+strlen("\r\n--xxBOUNDARYxx--\r\n\r\n")); //Para incluir "\n--xxBOUNDARYxx--\n\n" no fim da msg http
        if(modemCom::sendToModem(aux,1,&modemCom::status.PROMPT_ENVIO_COMMAND_MODE,NULL,1000,1,1)) {
            for(numeroByteSendoEnviado=0; numeroByteSendoEnviado<restoDoEnvio; numeroByteSendoEnviado++) {
                //Envio os bytes aqui! Menos o ultimo para ter o check;
                c = fgetc(arquivo->fp);
                modem.printf("%c",c);
                if(debug){
                    pc.printf("%c",c);
                }
            }
            if(modemCom::sendToModem("\r\n--xxBOUNDARYxx--\r\n\r\n",1,&modemCom::status.SEND_OK,NULL,5000,1,1)) {
                if(numeroDePartes) {
                    diversos::progressBar(parteSendoEnviada,numeroDePartes);
                }                
                passaParaProximaParte = true;
                if(debug){
                    pc.printf("\nEnviado o resto do envio com fim de cabecalho!\n",parteSendoEnviada);
                }
                modemCom::timeOutModem = 250;
                //}
                /*else {
                    pc.printf("Erro enviando arquivo.\n");
                    fclose(fp);
                    *aberto = false;
                    return 0;
                }*/
            } else {
                sdCard::fechaArquivo(arquivo);
                modemCom::status.emComunicacao = false;
                return 0;
            }
        } else {
            maxTentativas--;
            modemCom::sendToModem("AT\r\n",1,&modemCom::status.OK,NULL,1000,1,1);            
        }
    }

    if(!passaParaProximaParte) {
        pc.printf("Erro enviando o arquivo nao recebeu a tentativa de envio de parte inteira.\n");
        sdCard::fechaArquivo(arquivo);
        modemCom::status.emComunicacao = false;
        return 0;
    }

    sdCard::fechaArquivo(arquivo);

    //Logica de timeout esperando confirmação modemCom::status.ServerAck 20 segundos
    parteSendoEnviada = 300; //Reaproveitando variável
    while((parteSendoEnviada)&&(!modemCom::status.ServerAck)) {
        osDelay(100);
        parteSendoEnviada--;
    }

    modemCom::status.serverConnected=0;    
    //modemCom::sendToModem("AT+CIPCLOSE=1\r\n",1,&modemCom::status.OK,500,3);    
    modemCom::closeConnection(&modemCom::status.connIDSendData);
    modemCom::status.emComunicacao = false;    
    
    return modemCom::status.ServerAck;
}

uint8_t modemCom::sendToModem(char *string,uint8_t confirmado,char *codigoConfirmacao,char *stringConfirmacao,uint16_t timeOut,uint8_t maxTentativas,uint16_t delayEntreTentativas)
{
    uint16_t timeOutProcesso;
    uint16_t indexString,strLen; //Para exibir retentativas!    
    timeOut/=5;
    while(maxTentativas){
        timeOutProcesso=timeOut;
        
        
        bufModem.del(); //Deletando o buffer antes de iniciar envio
        
        if(string!=NULL) {
            modem.puts(string);
            if(xeretaModem){
                pc.printf("Sai pro modem <%s>\n",string); //Enviando na serial PC para debug
            }        
        }
        if(confirmado==1){           
            modemCom::status.ERROR=0;
            modemCom::status.busy=0;
            
            if(codigoConfirmacao!=NULL){
                *codigoConfirmacao=0;
                while((timeOutProcesso)&&(!(*codigoConfirmacao))&&(!modemCom::status.ERROR)&&(!modemCom::status.busy)){
                    osDelay(5); //timeOut em mS
                    timeOutProcesso--;
                }
            }else{
                    while((timeOutProcesso)&&(!modemCom::status.ERROR)&&(!modemCom::status.busy)&&(!strstr(bufModem.getRowBuffer(),stringConfirmacao))) {
                        osDelay(5); //timeOut em mS
                        timeOutProcesso--;
                    }
                }
            if(modemCom::status.ERROR||modemCom::status.busy) {
                osDelay(1000);//espera 1S
            }
            
            if(modemCom::status.dnsError){
               modemCom::status.dnsError=false;
               return 0;
            }    
            
            if(timeOutProcesso) {
                if(confirmado==1){
                    if(!(*codigoConfirmacao)){return 0;}
                }else{
                    if(!strstr(bufModem.getRowBuffer(),stringConfirmacao)){return 0;}
                 }
                return maxTentativas;                
            }                                    
            
            strLen = strlen(string);
            for(indexString=0; indexString<(strLen-1); indexString++) {
                pc.putc(string[indexString]);
            }
        
            if(xeretaModem){
                pc.printf("> maxTentativas = %lu.\n",maxTentativas);
            }
            
        }else{return 1;}
        maxTentativas--;
        osDelay(delayEntreTentativas);    
    }    
    return 0;
}

char modemCom::closeConnection(uint8_t *id){
    char command[20];
    if(debug){pc.printf("Lido %u como sendo o id em closeConnection.\r\n",*id);}
    if((*id)==255){
        return 2;
    }
    sprintf(command,"AT+CIPCLOSE=%u\r\n",*id);
    if(modemCom::sendToModem(command,1,NULL,",CLOSED",1000,1,300)){
        *id = 255;
        return 1;
    }
    return 0;
}

char modemCom::cipSend(uint8_t idConnection,char *buffer,uint16_t len){
    char aux[20];
    uint16_t i;
    if(!len){
        len = strlen(buffer);    
    }
    if(debug){printf("conteudo de cipsend.<");}
    sprintf(aux,"AT+CIPSENDEX=%u,%lu\r\n",idConnection,len);
    if(sendToModem(aux,1,&modemCom::status.OK,NULL,2000,1,1)){        
        for(i=0;i<len;i++){
            modem.putc(buffer[i]);
            if(debug){pc.putc(buffer[i]);}
        }
    }else{       
        return 0;            
    }
    if(debug){printf(">\r\n");}
    if(sendToModem("",1,&modemCom::status.SEND_OK,NULL,2000,1,1)){
        return 1;
    }
    return 2;
}

void modemCom::webServer(uint8_t id){    
    //char aux[50];
    bool encontrado=0;
    char buf[1024];
    char *strOutput;
    //uint32_t aux_int;    
    
    if(strstr(webServerBuff,"favicon.ico")){        
        //sprintf(buf,"<!DOCTYPE html><html><body><h1>DROME-Seu processo na palma da sua mao!</h1><img src='http://criandoriquezaimagens.s3.amazonaws.com/wp-content/uploads/2014/12/casaPropria.png' width='200' height='210'><br><p><a href='/lecomandocontrole.htm'>Ler comando do controle.</a></p><br></body></html>");
        sprintf(buf,"HTTP/1.1 200 OK\r\nContent-Type: text/html\r\n\r\n<!DOCTYPE html><html><body><link rel=\"icon\" href=\"http://%s/drome/assets/local/images/favicon/favicon.ico\" type=\"image/x-icon\"></body></html>",modemCom::status.host);
        if(cipSend(id,buf,0)==1){
            //printf("Requisicao enviada!\n");    
        }else{
            printf("Requisicao nao enviada 1!!\n");
        }        
        encontrado = 1;
    }
    
    if(strstr(webServerBuff,"comandos.htm")&&(!encontrado)){
        
        //sprintf(buf,"<!DOCTYPE html><html><body><h1>DROME-Seu processo na palma da sua mao!</h1><img src='http://criandoriquezaimagens.s3.amazonaws.com/wp-content/uploads/2014/12/casaPropria.png' width='200' height='210'><br><p><a href='/lecomandocontrole.htm'>Ler comando do controle.</a></p><br></body></html>");
        sprintf(buf,"HTTP/1.1 200 OK\r\nContent-Type: text/html\r\n\r\n<!DOCTYPE html><html><head><title>ConfigRede DROME</title></head><body><h1>DROME-Dispositivo Remoto de Operacao e Monitoramento de Equipamentos</h1><br><p><a href='/lecomandocontrole.htm'>Ler comando do controle.</a><a href='/configRede.htm'><br>Configurar rede.</a></p><br></body></html>");
        if(cipSend(id,buf,0)==1){
            printf("Requisicao enviada!\n");    
        }else{
            //printf("Requisicao nao enviada 1!!\n");
        }        
        encontrado = 1;
    }
        
    if(strstr(webServerBuff,"configRede.htm")&&(!encontrado)){        
        //Pegando o IP
        modemCom::leIP();        
        sprintf(buf,"HTTP/1.1 200 OK\r\nContent-Type: text/html\r\n\r\n<!DOCTYPE html><html><head><title>ConfigRede DROME</title></head><body><form action='cwjap.htm' method='GET'><fieldset><legend>Parametros de Configuracao da rede:</legend>SSID WiFi:<br><input type='text' name='ssid' value='%s'><br>Senha WiFi:<br><input type='text' name='password' value='%s'><br>Porta:<br><input type='text' name='porta' value='%s'><br>ServerIP:<br><input type='text' name='serverIP' value='%s'><br>Host:<br><input type='text' name='host' value='%s'><br>Periodo<br><input type='text' name='periodo' value='%lu'><br>IP<br><input type='text' name='STAIP' value='%s'><br>Mascara de Sub Rede<br><input type='text' name='subnetmask' value='%s'><br>Gateway/dhcp<br><input type='text' name='gateway' value='%s'><br>------ModBus------<br>BaudRate<br><input type='text' name='baudrate' value='%lu'><br>TimeOut<br><input type='text' name='timeout' value='%lu'><br><input type='submit' value='Configurar'></fieldset></form></body>",modemCom::status.ssid,modemCom::status.password,modemCom::status.port,modemCom::status.serverIP,modemCom::status.host,modemCom::status.periodo,modemCom::status.STAIP,modemCom::status.subnetmask,modemCom::status.gateway,modBusMaster1::MODBUS_SERIAL_BAUD,modBusMaster1::MODBUS_TIMEOUT);
        cipSend(id,buf,0);
        encontrado = 1;
    }

    if(strstr(webServerBuff,"lecomandocontrole.htm")&&(!encontrado)){
        uint16_t timeout = 5000;

        IrDetect.reset();
        IrDetect.start();

        diversos::wdt.kick(90.0);        
        ledUsoGeral = true;
        while((IrDetect.read_ms()<timeout) && (!detectaIRIn()));
        if(IrDetect.read_ms()<timeout){
            serializaPacoteIR(modemCom::status.connIDWebServer);            
        }else{
            sprintf(buf,"HTTP/1.1 200 OK\r\nContent-Type: text\r\n\r\nerro");   
            if(cipSend(id,buf,0)==1){
                //printf("Requisicao enviada!\n");    
            }
         }
        IrDetect.stop();   
        ledUsoGeral = false;
        encontrado = 1;        
    }
    
    if(strstr(webServerBuff,"wdtreset.htm")&&(!encontrado)){
        sprintf(buf,"HTTP/1.1 200 OK\n\n ACK");                              
        cipSend(id,buf,0);
        if(debug){pc.printf("Fechando socket chave 4.\r\n");}
        modemCom::closeConnection(&modemCom::status.connIDWebServer);
        diversos::wdt.kick(0.1);
        while(true);        
    }
    
    if(strstr(webServerBuff,"reset.htm")&&(!encontrado)){
        sprintf(buf,"HTTP/1.1 200 OK\n\n ACK");                              
        cipSend(id,buf,0);
        if(debug){pc.printf("Fechando socket chave 5.\r\n");}
        modemCom::closeConnection(&modemCom::status.connIDWebServer);
        NVIC_SystemReset();
    }
    
    if(strstr(webServerBuff,"cwjap.htm")&&(!encontrado)){
        pc.printf("Lido de cwjap <%s>.\r\n\r\n",webServerBuff);
        
        strtok(webServerBuff,"=");
        strcpy(modemCom::status.ssid,strtok(NULL,"&")); //pegando ssid        
        
        strtok(NULL,"=");
        strcpy(modemCom::status.password,strtok(NULL,"&")); //pegando password
                
        strtok(NULL,"=");
        strcpy(modemCom::status.port,strtok(NULL,"&")); //pegando port
        
        strtok(NULL,"=");
        strcpy(modemCom::status.serverIP,strtok(NULL,"&")); //pegando serverIP
        
        strtok(NULL,"=");
        strcpy(modemCom::status.host,strtok(NULL,"&")); //pegando host
        
        strtok(NULL,"=");
        strcpy(buf,strtok(NULL,"&")); //pegando periodo
        modemCom::status.periodo = atoi(buf);
        modemCom::status.periodoConfiguracao = modemCom::status.periodo;
        
        //*************************IP ou DHCP****************************
        
        strtok(NULL,"=");
        strcpy(modemCom::status.STAIP,strtok(NULL,"&")); //pegando IP/DHCP
        
        strtok(NULL,"=");
        strcpy(modemCom::status.subnetmask,strtok(NULL,"&")); //pegando subnetmask
        
        strtok(NULL,"=");
        strcpy(modemCom::status.gateway,strtok(NULL,"&")); //pegando gateway
        
        //*************************  ModBus  ****************************
        
        strtok(NULL,"=");
        strcpy(buf,strtok(NULL,"&")); //pegando BaudRate
        modBusMaster1::MODBUS_SERIAL_BAUD = atoi(buf);
        
        
        strtok(NULL,"=");
        strcpy(buf,strtok(NULL," ")); //pegando timeout
        modBusMaster1::MODBUS_TIMEOUT = atoi(buf);
        
        
        //Decodificando URL
        strOutput = (char *) malloc(strlen(modemCom::status.ssid)+1);
        diversos::urldecode2(strOutput, modemCom::status.ssid);
        strcpy(modemCom::status.ssid,strOutput);
        free(strOutput);
        
        strOutput = (char *) malloc(strlen(modemCom::status.password)+1);
        diversos::urldecode2(strOutput, modemCom::status.password);
        strcpy(modemCom::status.password,strOutput);
        free(strOutput);
        
        
        if((modemCom::status.ssid[0]!=0) && (modemCom::status.password[0]!=0)){
            sprintf(buf,"HTTP/1.1 200 OK\n\nACK");                      
            mudaRede = true;
        }else{
            sprintf(buf,"HTTP/1.1 200 OK\n\nNACK");
        }
        cipSend(id,buf,0);
        encontrado = 1;
    }
    
    if(!encontrado){        
        sprintf(buf,"Pagina Nao Encontrada.");
        if(cipSend(id,buf,0)==1){
            //printf("Requisicao enviada!\n");    
        }else{
            printf("Requisicao nao enviada 3!!\n");
        }         
    }    
    if(debug){pc.printf("Fechando socket chave 3.\r\n");}
    modemCom::closeConnection(&modemCom::status.connIDWebServer);
    if(mudaRede){            
        mudaRede = false;
        modemCom::sendToModem("AT+CIPSERVER=0\r\n",1,&modemCom::status.OK,NULL,2000,1,1);        
        pc.printf("Mudando para rede:\r\nSSID:%s\r\nPASSWORD:%S\r\nPORTA:%s\r\nserverIP:%s\r\nHOST:%s\r\nPERIODO:%lu\r\nIP/DHCP:%s\r\nsubnetmask:%s\r\ngateway:%s\r\nBaudRate:%lu\r\nTimeOut:%lu\r\n\r\n",modemCom::status.ssid,modemCom::status.password,modemCom::status.port,modemCom::status.serverIP,modemCom::status.host,modemCom::status.periodo,modemCom::status.STAIP,modemCom::status.subnetmask,modemCom::status.gateway,modBusMaster1::MODBUS_SERIAL_BAUD,modBusMaster1::MODBUS_TIMEOUT);
        
        if(strstr(modemCom::status.gateway,"dhcp")){
            strcpy(modemCom::status.STAIP,"dhcp");
            strcpy(modemCom::status.subnetmask,"dhcp");
        }
        
        if(sdCard::abreArquivo(&sdCard::config,"w")){
            pc.printf("Guardando config.\r\n");
            fprintf(sdCard::config.fp,"SSID:%s\r\nPASSWORD:%s\r\nPORT:%s\r\nserverIP:%s\r\nHOST:%s\r\nPERIODO:%lu\r\nSTAIP:%s\r\nsubnetmask:%s\r\ngateway:%s\r\nModBus_BaudRate:%lu\r\nModBus_TimeOut:%lu\r\n",modemCom::status.ssid,modemCom::status.password,modemCom::status.port,modemCom::status.serverIP,modemCom::status.host,modemCom::status.periodo,modemCom::status.STAIP,modemCom::status.subnetmask,modemCom::status.gateway,modBusMaster1::MODBUS_SERIAL_BAUD,modBusMaster1::MODBUS_TIMEOUT);
            sdCard::fechaArquivo(&sdCard::config);
            modemCom::inicializaModem();
            modemCom::conectaWiFi();
        }    
    }
}

bool modemCom::leIP(void){    
    char *ptr;    
    sendToModem("AT+CIFSR\r\n",1,NULL,"+CIFSR:STAIP,",2000,1,1);
    pc.printf("Lido de leIP <%s>.\r\n",modemCom::bufIn);
    ptr=strstr(modemCom::bufIn,"+CIFSR:STAIP,");
    if(ptr) {        
        ptr = strtok(ptr,"\"");
        ptr = strtok(NULL,"\"");
        strcpy(modemCom::status.STAIP,ptr);
    }
    if(strstr(modemCom::status.STAIP,"0.0.0.0")){return false;}
    return true;    
}

int16_t modemCom::getRSSI(void){
    char *ptr;
    int16_t RSSI = 255;
        
    if(modemCom::sendToModem("AT+CWJAP?\r\n",1,&modemCom::status.OK,NULL,10000,1,1000)){
        ptr = strstr(modemCom::bufIn,(const char*)modemCom::status.ssid);
        if(ptr){
            ptr = strtok(ptr,",");  //Descarta SSID
            ptr = strtok(NULL,","); //Descarta MAC
            ptr = strtok(NULL,","); //Descarta Canal
            ptr = strtok(NULL,","); //Captura RSSI
            RSSI = atoi(ptr);
        }
    }
    return RSSI;
    //return -50;
}

bool modemCom::verificaConexao(void){
    uint8_t i = 1;
    while(i){
        if(modemCom::getRSSI()==255){
            if(modemCom::conectaWiFi()){            
                return true;
            }
            i--;    
        }else{
            return true;
         }
    }    
    return false;
}
    
bool modemCom::conectaWiFi(void){
    //Função para mudança de rede
    
    char aux[128];    
    //modemCom::leParametrosConexaoSDCard();    
    //AT+CWJAP=\"\",\"\"\r\n
    sprintf(aux,"AT+CWJAP=\"%s\",\"%s\"\r\n",modemCom::status.ssid,modemCom::status.password);
    if(modemCom::sendToModem(aux,1,&modemCom::status.wifi_connected,NULL,7000,2,1000)) {
        if(debug){pc.printf("WiFi Conectado.\n");}
        return true;
    }else{
            return false;
        }            
}

void modemCom::processaPacote(void const *args){
    char *ptr,*scanPtr;            
    uint16_t bufInLength = bufModem.getLength();
    uint16_t timeOut;
    //bool getFound=false;
    modemCom::bufIn = bufModem.get();
    
    modemCom::status.modemResponse=true;
    
    if(xeretaModem){pc.printf("Vem do modem <%s>.\r\n",modemCom::bufIn);}
    
    //Reconhecimento dos status
    modemCom::status.PROMPT_ENVIO_COMMAND_MODE=0;
    ptr=strstr(modemCom::bufIn,"> ");
    if(ptr) {
        
        modemCom::status.serverConnected=1;
        modemCom::status.commandMode=1;
        
        modemCom::status.PROMPT_ENVIO_COMMAND_MODE=1;
    }

    modemCom::status.busy=false;
    ptr=strstr(modemCom::bufIn,"busy p...");
    if(ptr) {
        modemCom::status.OK=0;
        modemCom::status.ERROR=1;
        modemCom::status.busy=1;
    }
    
    /*modemCom::status.busy=false;
    ptr=strstr(modemCom::bufIn,"busy s...");
    if(ptr) {
        modemCom::status.OK=0;
        //modemCom::status.ERROR=1;
        modemCom::status.busy=1;
    }*/
    
    modemCom::status.SEND_OK=0;
    ptr=strstr(modemCom::bufIn,"SEND OK");
    if(ptr) {
        
        modemCom::status.SEND_OK=1;
    }

    modemCom::status.ERROR=0;
    ptr=strstr(modemCom::bufIn,"ERROR");
    if(ptr) {
        
        modemCom::status.ERROR=1;
        modemCom::status.OK=0;
    }
    
    ptr=strstr(modemCom::bufIn,"FAIL");
    if(ptr) {
        
        modemCom::status.ERROR=1;
        modemCom::status.OK=0;
    }
    
    
    
    ptr=strstr(modemCom::bufIn,"DNS Fail");
    if(ptr) {
        modemCom::status.dnsError=1;
        modemCom::status.ERROR=1;
        modemCom::status.OK=0;
    }    
    
    ptr=strstr(modemCom::bufIn,"WIFI CONNECTED");
    if(ptr) {
        modemCom::status.wifi_connected=1;
        
    }        
    
    ptr=strstr(modemCom::bufIn,"ALREADY CONNECTED");
    if(ptr) {
        modemCom::status.ALREADY_CONNECTED=1;
        modemCom::status.ERROR=1;
        modemCom::status.OK=0;
    }        
   
    modemCom::status.OK=0;
    ptr=strstr(modemCom::bufIn,"OK\r");
    if(ptr) {        
        modemCom::status.OK=1;
        modemCom::status.ERROR=0;
        modemCom::status.busy=0;
    }
   
    //modemCom::status.CLOSED=false;    
    ptr=strstr(modemCom::bufIn,"CLOSED");
    if(ptr) {        
        modemCom::status.CLOSED=1;
    }
    
    /*if(strstr(modemCom::bufIn,"GET /")){
        getFound = true;
    }*/
    
    //Buscando connect
    /*if(!modemCom::atendendoWebServer){
        ptr=strstr(modemCom::bufIn,"CONNECT\r\n");        
        if(ptr) {                
            ptr = strstr(ptr,"+IPD");
            ptr = strtok(ptr,",");
            ptr = strtok(NULL,",");
            connID = atoi(ptr);
            modemCom::status.connIDServerCommand = connID;
            modemCom::status.serverConnected=1;        
            pc.printf("Recebido string CONNECT socket na conexao %u.\n",connID);
            if(!modemCom::status.emComunicacao){                                                
                if(!getFound){
                    pc.printf("Atendendo socket entrante na conexao %u.\n",connID);
                    modemCom::status.SRINGsockEntrante = true;                    
                }
            }
            modemCom::status.emComunicacao=true;
            modemCom::bufIn = strtok(NULL,"");
        }    
    }*/
    
    IPDNumBytes = 0;
    ptr = strstr(modemCom::bufIn,"+IPD");
    if(ptr!=NULL){
        //+IPD,0,480:GET
        strtok(ptr,",");           //Separando +IPD
        
        ptr = strtok(NULL,",");    //Pegando o numero da conexão
        connID = atoi(ptr);        
        
        ptr = strtok(NULL,":");    //Pegando o numero de caracteres IPD
        IPDNumBytes = atoi(ptr);
        
        modemCom::bufIn = strtok(NULL,"");
        
        //printf("Recebido pacote via conexao %u com %lu bytes.\n",connID,IPDNumBytes);
        
    }     
    
    if((connID==modemCom::status.connIDServerCommand)&& IPDNumBytes && modemCom::status.recebendoArquivoDoServer && (strstr(modemCom::bufIn,"CONNECT")==NULL) && (strstr(modemCom::bufIn,"*ServerCommand*")==NULL) ){
        pc.printf("sendData recebidos %lu bytes\n",sdCard::nBytesArquivoRecebidos/2);
        sdCard::insereDadosArquivoHex(&sdCard::tempFile,modemCom::bufIn,IPDNumBytes);
        //sdCard::insereDadosArquivo(&sdCard::tempFile,modemCom::bufIn,IPDNumBytes);
        sdCard::nBytesArquivoRecebidos+=IPDNumBytes;
        bufModem.del();
        sprintf(modemCom::bufIn,"AT+CIPSEND=%u,%lu\r\n",modemCom::status.connIDServerCommand,10);
        modem.puts(modemCom::bufIn);
        timeOut = 500;
        while(timeOut && (strstr(bufModem.getRowBuffer(),">")==NULL)){
            osDelay(10);
            timeOut--;
        }
        modemCom::status.timeOut = 30;
        
        modem.puts("sendData\r\n");        
        diversos::wdt.kick();
        modemCom::status.recebendoArquivoDoServer = 250;
        return;
    }
        
    //Reconhecendo GET HTTP e atendendo com um servidor web    
    if(strstr(modemCom::bufIn,"HTTP/1.1")){
        ptr=strstr(modemCom::bufIn,"GET /");
        if(ptr) {            
            ptr = strtok(ptr,"/");
            ptr = strtok(NULL," ");
            bufInPtr = ptr;
            strcpy(webServerBuff,ptr);
            modemCom::atendendoWebServer = true;
            modemCom::status.connIDWebServer = connID;
        }
    }
    
    ptr=strstr(modemCom::bufIn,"*ServerAck*");
    if(ptr) {        
        modemCom::status.ServerAck=1;        
    }    
    
    ptr=strstr(modemCom::bufIn,"*ServerCommand*");
    if(ptr) {        
        scanPtr = strtok (ptr,"\\");
        scanPtr = strtok (NULL,">");        
        strcpy(commands::buffer,scanPtr);
        if(debug){pc.printf("Comandos <%s>.\n",commands::buffer);}
        modemCom::status.connIDServerCommand = connID;
        executaComandoServer = true;
    }    
}

bool modemCom::leParametrosConexaoSDCard(){
    char *ptr;
    char aux[128];
    if(sdCard::abreArquivo(&sdCard::config,"r")){
        //pc.printf("Abrindo arquivo de config para buscar dados de conexao.\r\n");        
        //"SSID:DROME\r\nPASSWORD:VITAE\r\nPORT:80"
        
        //Pegando SSID        
        fgets(modemCom::status.ssid,40,sdCard::config.fp);
        ptr = strstr(modemCom::status.ssid,"SSID");
        if(ptr!=NULL){
            ptr = strtok(modemCom::status.ssid,":");        
            ptr = strtok(NULL,"\r\n");
            strcpy(modemCom::status.ssid,ptr);
            
            //Pegando PASSWORD
            fgets(modemCom::status.password,50,sdCard::config.fp);
            ptr = strtok(modemCom::status.password,":");
            ptr = strtok(NULL,"\r\n");
            strcpy(modemCom::status.password,ptr);
            
            //Pegando PORT
            fgets(modemCom::status.port,20,sdCard::config.fp);
            ptr = strtok(modemCom::status.port,":");
            ptr = strtok(NULL,"\r\n");        
            strcpy(modemCom::status.port,ptr);            
            
            //Pegando serverIP
            fgets(aux,50,sdCard::config.fp);
            ptr = strtok(aux,":");
            ptr = strtok(NULL,"\r\n");
            strcpy(modemCom::status.serverIP,ptr);
                        
            //Pegando host
            fgets(aux,50,sdCard::config.fp);
            ptr = strtok(aux,":");
            ptr = strtok(NULL,"\r\n");
            strcpy(modemCom::status.host,ptr);
            
            //Pegando periodo
            fgets(aux,20,sdCard::config.fp);
            ptr = strtok(aux,":");
            ptr = strtok(NULL,"\r\n");        
            modemCom::status.periodo = atoi(ptr);
            modemCom::status.periodoConfiguracao = modemCom::status.periodo;
            
            //*************IP ou DHCP*****************
            
            //Pegando STAIP
            fgets(aux,50,sdCard::config.fp);
            ptr = strtok(aux,":");
            ptr = strtok(NULL,"\r\n");
            strcpy(modemCom::status.STAIP,ptr);
            
            //Pegando subnetmask
            fgets(aux,50,sdCard::config.fp);
            ptr = strtok(aux,":");
            ptr = strtok(NULL,"\r\n");
            strcpy(modemCom::status.subnetmask,ptr);
            
            //Pegando gateway
            fgets(aux,50,sdCard::config.fp);
            ptr = strtok(aux,":");
            ptr = strtok(NULL,"\r\n");
            strcpy(modemCom::status.gateway,ptr);
            
            //------ModBus_BaudRate------
            fgets(aux,50,sdCard::config.fp);
            ptr = strtok(aux,":");
            ptr = strtok(NULL,"\r\n");        
            modBusMaster1::MODBUS_SERIAL_BAUD = atoi(ptr);
            modBusMaster1::setBaud(modBusMaster1::MODBUS_SERIAL_BAUD);
            
            //------ModBus_TimeOut------
            fgets(aux,50,sdCard::config.fp);
            ptr = strtok(aux,":");
            ptr = strtok(NULL,"\r\n");        
            modBusMaster1::MODBUS_TIMEOUT = atoi(ptr);
        }else{
            strcpy(modemCom::status.ssid,"VSE");
            strcpy(modemCom::status.password,"vitaeBBYP");
            strcpy(modemCom::status.port,"4012");
            strcpy(modemCom::status.serverIP,"191.252.119.127");
            strcpy(modemCom::status.host,"www.drome.com.br");
            strcpy(modemCom::status.gateway,"dhcp");
            modemCom::status.periodo = 900;
            modBusMaster1::MODBUS_SERIAL_BAUD = 19200;
            modBusMaster1::setBaud(modBusMaster1::MODBUS_SERIAL_BAUD);
            modBusMaster1::MODBUS_TIMEOUT = 100;            
            modemCom::status.periodoConfiguracao = modemCom::status.periodo;
         }
        sdCard::fechaArquivo(&sdCard::config);
        if(debug){pc.printf("Lidos os parametros de configuracao de wifi como sendo:\r\nSSID:<%s>\r\nPASSWORD:<%s>\r\nPORT:<%s>\r\nserverIP:<%s>\r\nHOST:<%s>\r\nPERIODO:<%lu>\r\nSTAIP:<%s>\r\nsubnetmask:<%s>\r\ngateway:<%s>\r\nbaudRateModbus:<%lu>\r\ntimeOutModbus:<%lu>\r\n",modemCom::status.ssid,modemCom::status.password,modemCom::status.port,modemCom::status.serverIP,modemCom::status.host,modemCom::status.periodo,modemCom::status.STAIP,modemCom::status.subnetmask,modemCom::status.gateway,modBusMaster1::MODBUS_SERIAL_BAUD,modBusMaster1::MODBUS_TIMEOUT);
        pc.printf("Iniciando conexao wifi.\r\n");}
        return true;        
    }else{
            strcpy(modemCom::status.ssid,"VSE");
            strcpy(modemCom::status.password,"vitaeBBYP");
            strcpy(modemCom::status.port,"4012");
            strcpy(modemCom::status.serverIP,"191.252.119.127");
            strcpy(modemCom::status.host,"www.drome.com.br");
            strcpy(modemCom::status.gateway,"dhcp");
            modemCom::status.periodo = 900;            
            modBusMaster1::MODBUS_SERIAL_BAUD = 19200;
            modBusMaster1::setBaud(modBusMaster1::MODBUS_SERIAL_BAUD);
            modBusMaster1::MODBUS_TIMEOUT = 100;
            modemCom::status.periodoConfiguracao = modemCom::status.periodo;
            return false;
         }           
}

uint8_t modemCom::inicializaModem(void)
{    
    char aux[255];    
    modemCom::timeOutModem = 10;
    modemCom::status.emComunicacao = true;    
    
    serialModem::configBaud();

    modemCom::leMAC();
    
    modemCom::leParametrosConexaoSDCard();
    
    //Colocando aqui o conteudo de conectaWiFi
    //Mudando mode para AP e Station
    if(modemCom::sendToModem("AT+CWMODE=3\r\n",1,&modemCom::status.OK,NULL,3000,2,250)) {
        pc.printf("Modo AP+STATION aceito.\n");
    }    
        
    
    if(modemCom::sendToModem("AT+CIPMUX=1\r\n",1,&modemCom::status.OK,NULL,500,2,100)) {
        pc.printf("Recebeu o comando AT+CIPMUX=1.\n");
    }
    
        
    //AT+CIPSERVER=1,portaLidaDoSDCard
    sprintf(aux,"AT+CIPSERVER=1,%s\r\n",modemCom::status.port);
    if(modemCom::sendToModem(aux,1,&modemCom::status.OK,NULL,400,2,100)) {
        pc.printf("Recebeu o comando <%s>.\n",aux);
    }

    if(modemCom::sendToModem("AT+CIPSTO=10\r\n",1,&modemCom::status.OK,NULL,400,2,100)) {
        pc.printf("Recebeu o comando AT+CIPSTO=10.\n");
    }        
    
    sprintf(aux,"AT+CWSAP_CUR=\"DROME_WIFI_%s\",\"VseDROME\",5,3\r\n",modemCom::status.MAC);
    if(modemCom::sendToModem(aux,1,&modemCom::status.OK,NULL,1000,2,300)) {
        pc.printf("Recebeu o comando %s.\n",aux);
    }

    
    if(modemCom::sendToModem("AT+CIPAP_CUR=\"192.168.4.1\",\"192.168.4.1\",\"255.255.255.0\"\r\n",1,&modemCom::status.OK,NULL,500,2,100)) {
        pc.printf("Recebeu o comando AT+CIPAP_CUR=\"192.168.4.1\",\"192.168.4.1\",\"255.255.255.0\".\n");
    }    
    
    //Aqui decido se uso DHCP ou não.
    if(strstr(modemCom::status.gateway,"dhcp")||(strlen(modemCom::status.gateway)==0)){
        //usando dhcp
        if(modemCom::sendToModem("AT+CWDHCP_CUR=2,1\r\n",1,&modemCom::status.OK,NULL,500,2,100)) {
            pc.printf("Recebeu o comando AT+CWDHCP_CUR=2,1.\n");
        }
    }else{
        if(modemCom::sendToModem("AT+CWDHCP_CUR=2,0\r\n",1,&modemCom::status.OK,NULL,500,2,100)) {
            pc.printf("Recebeu o comando AT+CWDHCP_CUR=2,0.\n");
        }
        //AT+CIPSTA_DEF="192.168.6.100","192.168.6.1","255.255.255.0"
        sprintf(aux,"AT+CIPSTA_CUR=\"%s\",\"%s\",\"%s\"\r\n",modemCom::status.STAIP,modemCom::status.gateway,modemCom::status.subnetmask);
        if(modemCom::sendToModem(aux,1,&modemCom::status.OK,NULL,500,2,100)) {
            pc.printf("Recebeu o comando <%s>.\n",aux);
        }
        
     }
    modemCom::status.emComunicacao = false;
    return 1;
}


