#include "mbed.h"
#include "cmsis_os.h"   //Nucleo do Real Time Operational System
#include "main.h"
#ifndef _modbus_master_
#define _modbus_master_
     
#define maxLenBufModBus 850



namespace modBusMaster1{        
    extern Serial *serModBus;
    extern uint16_t T3_5;
    extern uint16_t T1_5;
    extern uint16_t MODBUS_SERIAL_BAUD;
    extern uint16_t MODBUS_TIMEOUT;    
    extern DigitalOut *de;
    extern uint8_t buffer[maxLenBufModBus]; //Buffer in e out;
    extern uint16_t index;    
    extern bool pacoteEmEspera;
    extern bool pacoteEmEsperaValido;
    extern bool startThreadModBusMaster;
    extern osTimerId timer_pacote;
    
    //Functions
    uint16_t CRC16(uint8_t*,uint16_t); //Ponteiro para buffer e len
    void modBusMaster(Serial *,uint32_t,DigitalOut *); //Objeto serial, objeto DigitalOut
    void setBaud(uint32_t); //Seta baudrate
    uint8_t readFloat(uint8_t,uint8_t,uint16_t,uint16_t,float*); //Endereço slave, funcCode, registrador, quantidade de registros,ponteiro para registros float
    uint8_t writeFloat(uint8_t,uint16_t,uint8_t,float*); //Endereço slave, registrador, quantidade de registros,ponteiro para registros float
    uint8_t writeRegister16BIT(uint8_t,uint16_t,uint16_t,uint16_t*); //Endereço slave, registrador, quantidade de registros,ponteiro para registros uint16_t
    uint8_t writeRegister32BIT(uint8_t,uint16_t,uint16_t,uint32_t*); //Endereço slave, registrador, quantidade de registros,ponteiro para registros uint32_t
    uint8_t readRegister16BIT(uint8_t,uint8_t,uint16_t,uint16_t,uint16_t*); //Endereço slave, funcao, registrador, quantidade de registros,ponteiro para registros uint16_t
    uint8_t readRegister32BIT(uint8_t,uint8_t,uint16_t,uint16_t,uint32_t*); //Endereço slave, funcao, registrador, quantidade de registros,ponteiro para registros uint32_t
    uint16_t sendFrame(uint16_t); //Quantidade de caracteres;
    uint8_t readCoils(uint8_t,uint16_t,uint16_t,bool*); //Endereço slave, registrador, quantidade de registros, ponteiro para bool
    uint8_t writeSingleCoil(uint8_t,uint16_t,bool); //Endereço slave, registrador, bool
    void processaCaractere();    
    void processaPacote(void const *);
};
#endif
