#ifndef _main_h_
#define _main_h_
#include "mbed.h"
#include "modem.h"
#include "devices.h"
#include "CircularBuffer.h"
#include "mediaMovel.h"
#include "math.h"
#include "IOs.h"
#include "IRPack.h"
#include "DS18B20_SensorTemperatura.h"
#include "HighSpeedAnalogIn.h"
#include "bootloader.h"
#define xereta_modem
#define maxTentativasEnvioDados 5



//#define serverAddress "186.202.127.244"
#define serverAddress "www.drome.com.br"

//Inicializações de máquina;
/*
typedef struct _typeConfig{ 
 //Guarda todos os parametros de configuração do aparelho.
 //Sequencia Claro, Vivo, Tim, Oi 
 char apnList[4][30];    //Endereço de APN para cada operadora. No caso Claro, Vivo, Tim, Oi
 char login[4][11];      //Login para cada operadora
 char senha[4][11];      //Senha para cada operadora
 char serverAddress[50]; //Dns para o servidor ex. norsulengenharia.com.br
 char numeroReportSMS[16];
 char serverPort[7];     //Porta para conexão entrante ex 44000
 uint16_t periodoDeEnvioDeDadosMinutos;
 char ultimoEstadoLigadoDesligado;
 uint16_t CRC;
}typeConfig;

extern typeConfig flashConfig;
*/

//Definições de hardware
extern DigitalOut ledLigado;
extern DigitalOut ledEmComunicacao;
extern DigitalOut ledConectadoInternet;
extern DigitalOut ledUsoGeral;
extern bool hardwareReset;
extern bool debug;
extern bool xeretaModem;
extern char firmVersion[20];
extern char resetCauses[30];

extern DigitalOut ESP_CH_PD;
extern DigitalOut ESP_RESET;
extern DigitalOut ESP_ESPGPIO_2;

/*extern AnalogIn ai4;
extern AnalogIn ai3;
extern AnalogIn ai2;
extern AnalogIn ai1;*/

extern MediaMovel FiltroAI4;
extern MediaMovel FiltroAI3;
extern MediaMovel FiltroAI2;
extern MediaMovel FiltroAI1;

extern uint16_t aiFiltrada[4];
extern bool entradasDigitais[9];



extern Serial pc; //Instancia de recurso Serial uart pc
extern Serial modem; //Instancia de recurso Serial uart Modem
extern Serial m200_Serial; //Instancia de recurso serial para medidor m200 modbus

extern CircularBuffer bufModem;
extern CircularBuffer bufPC;
extern CircularBuffer sdCardBuf;
extern uint32_t act;
extern bool boolExecAct;
extern bool inicializaModemBool;

extern bool reportaMudancaAoServer;
extern bool executaComandoServer;
extern bool envioDadosAoServer;

extern uint8_t enviaDadosPorAlarme;
extern DigitalOut max_de;

void loadStandardConfig(void);
void RTC_POR_MINUTO(void);
void inicializaMaquina(void);



extern arquivoSD *arquivoEnvioPointer;

//Threads
    //Timers    
    extern osThreadId idThreadTimers;
    void threadTimers(void const *);   
    
    //Comunicacões
    extern osThreadId idThreadComunicacoes;    
    void threadComunicacoes(void const *);
    
    //ProcessaPacote
    extern osThreadId idThreadProcessaPacote;    
    void threadProcessaPacote(void const *);
//Threads

//Devices    
    extern uint8_t devices;
    extern uint16_t alarmes;     
    extern uint16_t leituras;
    extern uint16_t qtdSchedules;
    extern uint16_t qtdScheduleExceptions;
    void loadDevices();   
//Devices

#endif
