#include "mbed.h"   //API mBed com diversos drivers para os perifÃ©ricos LPC1768
#include "stdio.h"
#include "cmsis_os.h"   //Nucleo do Real Time Operational System
#include "main.h"   //InicializaÃ§Ãµes de maquina e demais ajustes de hardware
#include "funcoesSDCard.h"  //FunÃ§Ãµes para manipulaÃ§Ã£o do SDCard que incluem rotinas de inicializaÃ§Ã£o, setar pastas e arquivos e demais usos
#include "RTC.h"    //API de uso das interrupÃ§Ãµes do Real Time Clock
#include "serialPC.h"   //FunÃ§Ãµes de comunicaÃ§Ã£o entre RAD e PC via usb
#include "modbusMaster1.h"
//#include "lpc17xx_nvic.h"


//DefiniÃ§Ãµes de Hardware acessÃ­veis em qualquer modulo
/*LEDs de informação visual*/
DigitalOut ledLigado(P1_0);
DigitalOut ledEmComunicacao(P1_1);
DigitalOut ledConectadoInternet(P1_4);
DigitalOut ledUsoGeral(P1_8);
/*LEDs de informação visual*/

/*Pinos de controle do modulo WiFi*/
DigitalOut ESP_CH_PD(P0_6);
DigitalOut ESP_RESET(P0_0);
DigitalOut ESP_ESPGPIO_2(P0_1);
/*Pinos de controle do modulo WiFi*/

/*Interrupções externas para contagem de pulsos rapidos*/
InterruptIn eInt1(P2_11);
InterruptIn eInt2(P2_12);
InterruptIn eInt3(P2_13);
/*Interrupções externas para contagem de pulsos rapidos*/

/*Leituras analógicas*/
/*AnalogIn   ain1(p17);
AnalogIn   ain2(p18);
AnalogIn   ain3(p19);
AnalogIn   ain4(p20);*/
/*Leituras analógicas*/

//Função para reset do ARM
extern "C" void mbed_reset();

//Devices    
    uint8_t devices=0;
    uint16_t alarmes=0;
    uint16_t leituras=0;
    uint16_t qtdSchedules=0;
    uint16_t qtdScheduleExceptions=0;
//Devices

//Variáveis para envio de arquivo em qualquer lugar do código
extern arquivoSD *arquivoEnvioPointer = NULL;

uint32_t act;
bool boolExecAct;
bool inicializaModemBool;
bool debug = false;
bool xeretaModem = false;
bool hardwareReset = false;
char firmVersion[20];
char resetCauses[30];


MediaMovel FiltroAI4(5);
MediaMovel FiltroAI3(5);
MediaMovel FiltroAI2(5);
MediaMovel FiltroAI1(5);

uint16_t aiFiltrada[4];
bool entradasDigitais[9];

CircularBuffer bufModem(maxBufInModem,0);// __attribute__ ((section("AHBSRAM0")));    
CircularBuffer bufPC(128,0);
CircularBuffer sdCardBuf(1024,0);

uint8_t enviaDadosPorAlarme = 255;
//bool reportaMudancaAoServer;
bool executaComandoServer;

//typeConfig flashConfig;  

//Instancia das portas Seriais do ARM
Serial pc(USBTX, USBRX); //Instancia de recurso Serial uart pc
Serial modem(P0_10,P0_11); //Instancia de recurso Serial uart Modem 
DigitalOut max_de(P2_7); //Pino de habilitaÃ§Ã£o max485 para porta Energy Metering ModBus
Serial modBusMaster1Serial(P2_0,P2_1);  //Recurso serial para porta Energy Metering ModBus

/*
//InterrupÃ§Ãµes externas e botÃµes
InterruptIn int_wh(P2_11);
InterruptIn int_varh(P2_12);

void whCount(void){
    whled=1;
    wait(0.2);
    whled=0;
}

void varhCount(void){
    varhled=1;
    wait(0.2);
    varhled=0;
}*/
//DefiniÃ§Ãµes de Hardware acessÃ­veis em qualquer modulo

/*
void loadStandardConfig(){ 
 strcpy(flashConfig.apnList[0],"claro.com.br");
 strcpy(flashConfig.apnList[1],"zap.vivo.com.br");
 strcpy(flashConfig.apnList[2],"tim.br");
 strcpy(flashConfig.apnList[3],"generica.oi.com.br"); 

 strcpy(flashConfig.login[0],"claro");
 strcpy(flashConfig.login[1],"vivo");
 strcpy(flashConfig.login[2],"tim");
 strcpy(flashConfig.login[3],"oi"); 

 strcpy(flashConfig.senha[0],"claro");
 strcpy(flashConfig.senha[1],"vivo");
 strcpy(flashConfig.senha[2],"tim");
 strcpy(flashConfig.senha[3],"oi"); 

 strcpy(flashConfig.serverAddress,serverAddress); 
 
 strcpy(flashConfig.serverPort,"80"); 
 
 flashConfig.periodoDeEnvioDeDadosMinutos=15;  //PadrÃ£o 15 minutos
 flashConfig.ultimoEstadoLigadoDesligado=0;    //PadrÃ£o de fÃ¡brica desligado
}
*/

void leiturasDigitais(){    
    entradasDigitais[0] = ED1;
    entradasDigitais[1] = ED2;
    entradasDigitais[2] = ED3;
    entradasDigitais[3] = ED4;
    entradasDigitais[4] = ED5;
    entradasDigitais[5] = ED6;
    entradasDigitais[6] = ED7;
    entradasDigitais[7] = ED8;
    entradasDigitais[8] = ED9;    
}

HighSpeedAnalogIn ain(p17, p18, p19, p20);

void leiturasAnalogicas(){
    static uint8_t leituraAtual;
    switch(leituraAtual){
        case 0:                
                aiFiltrada[0] = FiltroAI1.get(ain.read_u16(p17));
            break;
        case 1:
                aiFiltrada[1] = FiltroAI2.get(ain.read_u16(p18));
            break;
        case 2:
                aiFiltrada[2] = FiltroAI3.get(ain.read_u16(p19));
            break;
        case 3:
                aiFiltrada[3] = FiltroAI4.get(ain.read_u16(p20));
            break;        
    }
    if(leituraAtual<3){leituraAtual++;}
    else{leituraAtual=0;}
} 

void verificaSaidasDigitais(){
    SD_OE_R = 1;
    /*if(SD_FAULT){
        if(debug)pc.printf("Fault\r\n");
    }else{
        if(debug)pc.printf("No Fault\r\n");
     }*/
}

//Thread timers Ã© utilizada para dar start nos timers de dentro das ISRs de comunicaÃ§Ã£o serial porque nÃ£o Ã© permitido inicializar osTimers de dentro de ISRs.
osThreadId idThreadTimers;
void threadTimers(void const *args){
    while(true){
        osSignalWait(0x1,1000); //Executo compulsoriamente mesmo que nÃ£o haja sinal num periodo de 1 segundo        
        //if(enviaDadosPorAlarme==255){//debug        
            if(serialPC::startTimer_pacote){
              serialPC::startTimer_pacote = false;
              osTimerStart(serialPC::timer_pacote,100);            
            }
            if(serialModem::startTimer_pacote){
              serialModem::startTimer_pacote = false;
              osTimerStart(serialModem::timer_pacote,modemCom::timeOutModem);            
            }
        //}        
        if(modBusMaster1::startThreadModBusMaster){
          modBusMaster1::startThreadModBusMaster = false;
          osTimerStart(modBusMaster1::timer_pacote,4);            
        }                
    }        
}
osThreadDef(threadTimers, osPriorityNormal, 128);


osThreadId idThreadProcessaPacote;
void threadProcessaPacote(void const *args){
    while(true){
        osSignalWait(0x1,100); //Executo compulsoriamente mesmo que nÃ£o haja sinal num periodo de 1 segundo
        if(serialModem::processarPacote){
            serialModem::processarPacote = false;
            modemCom::processaPacote(NULL);
        }        
    }    
}
osThreadDef(threadProcessaPacote, osPriorityNormal, DEFAULT_STACK_SIZE);



//Thread que gerencia as comunicacoes (DROME - SERVER)
osThreadId idThreadComunicacoes;
void threadComunicacoes(void const *args){
    //Esta thread faz todo o tratamento de comunicação.    
    
    //char aux[30];                   
    while(true){                
        osSignalWait(0x1,1000); //Libero processamento e executo compulsoriamente mesmo que nÃ£o haja sinal num periodo de um segundo        
        if(inicializaModemBool){
            inicializaModemBool = false;
            modemCom::conectaWiFi();    
        }        
              
        if(eventosRTC::rotinaEnvioDeDados){
            //Faço aqui o que for devido.            
            if((!modemCom::status.recebendoArquivoDoServer)&&(enviaDadosPorAlarme==255)){
                if(!modemCom::timeOutEnvioDados){
                    modemCom::timeOutEnvioDados=maxTimeEnvioDados;    
                }
                if(debug){pc.printf("Enviando dados de hora completa ao server.\n");}
                modemCom::status.emComunicacao = true;
                eventosRTC::rotinaEnvioDeDados--;
                modemCom::status.periodo = 900;
                diversos::wdt.kick(180);
                if(modemCom::verificaConexao()){
                    //Estou conectado                    
                    if(modemCom::enviaDados()){
                        eventosRTC::rotinaEnvioDeDados=0;
                        modemCom::timeOutEnvioDados=0;
                        modemCom::status.periodo = modemCom::status.periodoConfiguracao; //Restaurando o período configurado no sistema
                    }
                }
                modemCom::status.emComunicacao = false;
            }
            
        }        
        
        if(arquivoEnvioPointer!=NULL){            
            if(debug){pc.printf("Enviando o arquivo <%s> ao server.\n",arquivoEnvioPointer->nome);}
            if(modemCom::postFileCommandMode(modemCom::status.serverIP,modemCom::status.host,"/drome/parser/index.php",arquivoEnvioPointer)){
            //if(modemCom::postFileCommandMode(modemCom::status.serverIP,modemCom::status.host,"/sistema/Parser/index.php",arquivoEnvioPointer)){
                if(debug){pc.printf("Enviado o arquivo <%s>.\n",arquivoEnvioPointer->nome);}
                arquivoEnvioPointer = NULL;        
            }else{
                if(debug){pc.printf("Erro enviando o arquivo <%s>.\n",arquivoEnvioPointer->nome);}
             }
        }
        
        if(modemCom::status.SRINGsockEntrante){
            modemCom::status.SRINGsockEntrante=false;
            modemCom::atendeSRING(modemCom::status.connIDServerCommand);
        }
        modemCom::timeOutModem = 30;
    }
}
//osThreadDef(threadComunicacoes, osPriorityNormal, 3072); 
osThreadDef(threadComunicacoes, osPriorityNormal, (DEFAULT_STACK_SIZE*2)); 

void RTC_POR_SEGUNDO(void){
    time_t seconds;
    seconds = time(NULL);        
    //osSignalSet(idThreadComunicacoes, 0x1);
    eventosRTC::rotina1segundo=true;
    
    if(((seconds+5)%10)==0){     
     eventosRTC::rotina10Segundos = true;                
    }
    
    if((seconds%60)==0){     
     eventosRTC::minutos = true;   
    }

    if(((seconds-15)%modemCom::status.periodo)==0){
    //if((seconds%300)==0){
        eventosRTC::rotinaEnvioDeDados = maxTentativasEnvioDados;
        osSignalSet(idThreadComunicacoes, 0x1);
    }    
}

void loadDevices(){    
    if(sdCard::abreArquivo(&sdCard::devices,"r")){
        criaDevices(sdCard::devices.fp);
        if(devices){
            configuraDevices(sdCard::devices.fp);
            printf("Dispositivos configurados.\n");            
        }
        sdCard::fechaArquivo(&sdCard::devices); 
        if(devices){testaTudoDevices();}
    }    
}

void inicializaMaquina(){
    //char aux[15];
    time_t seconds;
    seconds = time(NULL);     
    //Resetei pq?    
    sprintf(resetCauses,"TSOn:%lu",seconds);
    if((LPC_WDT->WDMOD >> 2) & 1){
        strcat(resetCauses,",WDT");
    }else{strcat(resetCauses,",NOW");}
    
    diversos::wdt.kick(90.0);
    
    pwmPeriod = 100000;
    SD1.period_us(pwmPeriod);
    modemCom::atendendoWebServer = false;
    
    printf("Versao: %s.\r\n",firmVersion);
    printf("Reset Causes: %s.\r\n",resetCauses);
    modemCom::timeOutModem = 30;
    serialModem::serial_init();
    numeroDeBytesPorEnvio = 768;
    modBusMaster1::modBusMaster(&modBusMaster1Serial,19200,&max_de);
    inicializaSensoresTemperatura();
    
    if(sdCard::init()){
     printf("SD Card inicializado com sucesso.\n");
     //Carregando a lista de dispositivos
     loadDevices();
    }else{
        printf("Nao foi possivel inicializar o SD Card.\n");   
     }   

          
    //Tick Timer por segundo
    RTC::attach(&RTC_POR_SEGUNDO, RTC::Second);                  
    
    /*Chamada de threads*/
    
    //Thread timers
    idThreadTimers = osThreadCreate(osThread(threadTimers), NULL);    
    //Thread comunicacoes
    idThreadComunicacoes = osThreadCreate(osThread(threadComunicacoes), NULL);
    //Thread processaPacote
    idThreadProcessaPacote = osThreadCreate(osThread(threadProcessaPacote), NULL);
    
    /*Chamada de threads*/    
    modemCom::status.connIDServerCommand = 255;
    modemCom::status.connIDWebServer = 255;
    modemCom::status.connIDSendData = 255;    
}

//Inicio do programa;
int main() {    
    //uint8_t i;
    ESP_CH_PD = 0;          
    ESP_ESPGPIO_2 = 0;
    ESP_RESET = 0;

    flashPrepare();
    firmDescToRam();
    serialPC::serialPC_init();
    pc.printf("firmDesc: nome <%s> tamFirmware = %lu executaBootLoader = %u.\r\n",(char*)&memBufConfigBootLoader[5],tamFirmware,executaBootLoader);
    
    if(executaBootLoader==1){        
        executaBootLoader=0;
        pc.printf("Chamando o bootloader logo apos dar reset.\r\n");
        while( ((LPC_UART0->LSR >> 6) &0x1) == 0 );
        //__disable_irq();        
        SysTick->CTRL &= ~0x00000002;           // disable SysTick interrupt
        NVIC_DeInit();
        firmDescToFlash();
        bootLoader();        
    }
    
    sprintf(firmVersion,"08/06/18(BL)");
    

    eInt1.rise(&diversos::processaPulsosEDs);
    eInt2.rise(&diversos::processaPulsosEDs);
    eInt3.rise(&diversos::processaPulsosEDs);        
    
    modem.baud(76800);
    
    ESP_CH_PD = 1;          
    ESP_ESPGPIO_2 = 1;
    ESP_RESET = 1;
    
    wait(5);    
    
    inicializaMaquina();
    modemCom::inicializaModem();
    /*if(!modemCom::verificaConexao()){
        modemCom::conectaWiFi();
    }*/
    
    //Agendando primeiro envio de cara.
    eventosRTC::rotinaEnvioDeDados=maxTentativasEnvioDados;    
    osSignalSet(idThreadComunicacoes, 0x1);    
    
    
        
    while(true){
        osDelay(100);
        if(callBootLoader){
            diversos::wdt.kick(180.0);
            SysTick->CTRL &= ~0x00000002;           // disable SysTick interrupt
            NVIC_DeInit();
            
            //Bloco novo
            //SysTick->CTRL = 0;
            //SysTick->LOAD = 0;
            //SysTick->VAL = 0;
        
            /**
             * Step: Disable all interrupts
             */
            //__disable_irq();
        
            /* ARM Cortex-M Programming Guide to Memory Barrier Instructions.*/
            //__DSB();
            //Bloco novo
            //__disable_irq();
            //__disable_irq();
            bootloader_fillUpFlash(&sdCard::newFirmware);
            pc.printf("Logo depois de fillUpFlash firmDesc: nome <%s> tamFirmware = %lu\r\n",(char*)&memBufConfigBootLoader[5],tamFirmware);  
            
            
            NVIC_SystemReset();
            /*while( ((LPC_UART0->LSR >> 6) &0x1) == 0 );
            //__enable_irq();
            bootLoader();*/
        }

        /*---------------------Bloco de prevenção de bloqueio-------------------------------*/
        if((!modemCom::status.recebendoArquivoDoServer)&&(!modemCom::status.emComunicacao)){
            diversos::wdt.kick(180.0);
        }else{            
            /*-----------------Bloco temporizador de recepção de arquivo--------------*/
            if(modemCom::status.recebendoArquivoDoServer){
                if(modemCom::status.recebendoArquivoDoServer==1){
                    modemCom::closeConnection(&modemCom::status.connIDServerCommand);                    
                    //Insere erro no arquivo.
                }
                modemCom::status.recebendoArquivoDoServer--;                
                if(xeretaModem){pc.printf("recebendoArquivoDoServer = %lu.\r\n",modemCom::status.recebendoArquivoDoServer);}
            }
            /*-----------------Bloco temporizador de recepção de arquivo--------------*/
            
            /*-----------------Bloco temporizador de recepção de envio de dados-------*/
            if(modemCom::status.emComunicacao){
                if(modemCom::timeOutEnvioDados==1){
                    modemCom::status.emComunicacao=0;
                    modemCom::closeConnection(&modemCom::status.connIDServerCommand);
                    modemCom::closeConnection(&modemCom::status.connIDWebServer);
                    modemCom::closeConnection(&modemCom::status.connIDSendData);
                    //Insere erro no arquivo.
                }
                modemCom::timeOutEnvioDados--;
                if(xeretaModem){pc.printf("timeOutEnvioDados = %lu.\r\n",modemCom::timeOutEnvioDados);}
            }
            /*-----------------Bloco temporizador de recepção de envio de dados-------*/
         }
        /*---------------------Bloco de prevenção de bloqueio-------------------------------*/
        
        if(executaComandoServer){
            executaComandoServer = false;
            
            commands::exec(modemCom::status.connIDServerCommand);            
            if(!modemCom::status.recebendoArquivoDoServer){
                if(debug){pc.printf("Fechando socket chave 4.\r\n");}
                modemCom::closeConnection(&modemCom::status.connIDServerCommand);
            }
        }        
    
        if(sdCard::deleteSentFiles){
            printf("Recebido comando para deletar arquivos enviados.\n");
            sdCard::deleteBanks(sdCard::currentBankSending);
            if(sdCard::modificaCurrentBank(sdCard::currentBank,!sdCard::currentBankSending)){
                sdCard::deleteSentFiles=false;
            }
        }
    
        if(modemCom::atendendoWebServer){                
                modemCom::atendendoWebServer = false;
                if(debug){pc.printf("Atendendo webServer na conexao %u.\r\n",modemCom::status.connIDWebServer);}
                modemCom::status.emComunicacao=true;
                modemCom::webServer(modemCom::status.connIDWebServer);                
                modemCom::status.emComunicacao=false;
        }
        
        if(boolExecAct){
            execAct(act);
            boolExecAct = false;    
        }        
        
        if((!modemCom::status.recebendoArquivoDoServer)&&(!modemCom::status.emComunicacao)){
            if(eventosRTC::rotina1segundo){
                eventosRTC::rotina1segundo = false;
                if(enviaDadosPorAlarme!=255){
                    enviaDadosPorAlarme--;
                    if(enviaDadosPorAlarme==0){
                        eventosRTC::rotinaEnvioDeDados=maxTentativasEnvioDados;
                        enviaDadosPorAlarme=255;                        
                    }
                }
                leiturasAnalogicas();                
                verificaSaidasDigitais();
                leiturasDigitais();                
            
                if(debug){
                    pc.printf("\nMemoria RAM disponivel = %lu\n",diversos::memAvailable());
                    //pc.printf("\nEntrada 4 = %lu.\nEntrada 3 = %lu.\nEntrada 2 = %lu.\nEntrada 1 = %lu.\r\n",aiFiltrada[3],aiFiltrada[2],aiFiltrada[1],aiFiltrada[0]);            
                    //pc.printf("Pulsos <%lu><%lu><%lu>.\r\n",pulsosEDs[0],pulsosEDs[1],pulsosEDs[2]);                    
                }                    
                time_t seconds = time(NULL);
                pc.printf("Drome %s, %s\n",firmVersion,ctime(&seconds));
            }            
            if(eventosRTC::rotina10Segundos){                                    
                //Executo abaixo a rotina de 10 segundos
                eventosRTC::rotina10Segundos = false;
                verifySchedules();                
                verifyAlarms();                
            }
            if((eventosRTC::minutos)){//&&(!modemCom::status.recebendoArquivoDoServer)){
                //Executo abaixo a rotina de 1 minuto
                eventosRTC::minutos = false;
                refreshSensoresTemperatura();
                writeReadingsToSD();
            }
        }        
        
        if(hardwareReset){
            //Resetando
            pc.printf("hardwareReset = true.\r\n");
            osDelay(50);      //Para dar tempo de enviar todo o printf.
            //diversos::wdt.kick(0.1);
            NVIC_SystemReset();            
            while(true);
        }  
    }
}
