#ifndef _funcoesSDCard_h_
#define _funcoesSDCard_h_
#include "SDFileSystem.h"
#define timeOutArquivoAberto 10000
//#include "modem.h"


typedef struct{
    FILE *fp;    
    bool aberto;    
    uint32_t bytes;
    char nome[30];
}arquivoSD;

namespace sdCard{
 extern SDFileSystem sd;    
 extern arquivoSD bank0;
 extern arquivoSD bank1;
 extern arquivoSD currentBankFile;
 extern arquivoSD config;
 extern arquivoSD devices;
 extern arquivoSD status; 
 extern arquivoSD tempFile;
 extern arquivoSD newFirmware;
 extern uint32_t nBytesArquivoRecebidos;
 extern bool arquivosAbertos;
 extern bool deleteSentFiles;
 extern char nomeArquivoEmRecebimento[30];
 extern uint8_t currentBank;
 extern uint8_t currentBankSending;
 extern uint16_t checkSum;
 
  
 int init();
 uint8_t file_rename(const char *, const char *); 
 int preparaEnvio(void);
 void finalizaEnvio(void); 
 bool getFileTam(arquivoSD *);
 bool abreArquivo(arquivoSD *,char *); //Struct do arquivo e modo ('w','r+',etc)
 bool insereDadosArquivo(arquivoSD *, char*,uint16_t);//Struct do arquivo, dados a inserir e tamanho deles
 bool insereDadosArquivoHex(arquivoSD *, char*,uint16_t);//Struct do arquivo, dados a inserir e tamanho deles
 bool insereDadosBank(char*,uint16_t); //Dados a inserir e tamanho deles
 //bool insereDadosArquivoPeloNome(char *, char*,uint16_t);//nome do arquivo, dados a inserir e tamanho deles
 bool fechaArquivo(arquivoSD *); //Struct do arquivo
 bool exibeArquivo(arquivoSD *);
 bool excluiArquivo(arquivoSD *);
 bool arquivoAberto(uint16_t);
 uint16_t calcCheckSum16BITFile(char *);
 void verificaCurrentBank(void); //Verifica o banco atualmente utilizado 
 uint8_t modificaCurrentBank(uint8_t,uint8_t);
 bool deleteBanks(uint8_t);
}
#endif
