#include "funcoesSDCard.h"
#include "serialPC.h"


arquivoSD sdCard::bank0;
arquivoSD sdCard::bank1;
arquivoSD sdCard::currentBankFile;
arquivoSD sdCard::config;
arquivoSD sdCard::devices;
arquivoSD sdCard::status;
arquivoSD sdCard::tempFile;
arquivoSD sdCard::newFirmware;
uint32_t sdCard::nBytesArquivoRecebidos;
uint8_t sdCard::currentBank;
uint8_t sdCard::currentBankSending;
uint16_t sdCard::checkSum;
bool sdCard::arquivosAbertos=false;

char sdCard::nomeArquivoEmRecebimento[30];


bool sdCard::deleteSentFiles;

SDFileSystem sd(p11, p12, p13, p14, "sd");


bool sdCard::abreArquivo(arquivoSD *arquivo,char *mode){
    //Struct do arquivo e seu nome
    /*uint32_t timeOut=30000;
    while(timeOut && arquivo->aberto){
        timeOut--; 
        osDelay(1);
    }
    if(arquivo->aberto){return false;}
    */
    //if(!sdCard::arquivoAberto(15000)){return false;}    
    
    //if(debug)pc.printf("Abrindo um arquivo de nome <%s> em modo <%s>.\r\n",arquivo->nome,mode);
    
    //if(debug)pc.printf("Abrindo arquivo <%s>.\n",arquivo->nome);
    if((arquivo->fp = fopen(arquivo->nome,mode))!=NULL){
        arquivo->aberto = true;    
        return true;
    }else{
        return false;   
     } 
}

uint16_t sdCard::calcCheckSum16BITFile(char *nome){
    FILE *fp;
    char c;
    uint16_t sum = 0;
    
    fp = fopen (nome,"r");    
    if(fp != NULL){            
        do{
            c = fgetc(fp);
            if(!feof(fp)){sum+=c;}
        }while(!feof(fp));
        fclose(fp);                
    }
    return sum;
}

/*bool sdCard::insereDadosArquivoPeloNome(char *nome, char *dados,uint16_t tam){
    FILE *fp;
    fp = fopen(nome,"a");
    uint16_t i;
    if(fp!=NULL){
        sdCard::arquivoAberto = true;
        for(i=0;i<tam;i++){
            fprintf(fp,"%c",dados[i]);
            fflush(fp);    
        }
        fclose(fp);
        sdCard::arquivoAberto = false;
    }else{
        return false;  
     }    
    return true;
}*/

void sdCard::verificaCurrentBank(void){                   
    if(sdCard::abreArquivo(&sdCard::currentBankFile,"r")){            
        if(debug)pc.printf("sdCard::verificaCurrentBank[1]\r\n");        
        if(debug)pc.printf("sdCard::verificaCurrentBank[2]\r\n");
        sdCard::currentBank = 3;
        sdCard::currentBankSending = 3;
        sdCard::currentBank = fgetc(sdCard::currentBankFile.fp);
        sdCard::currentBank = sdCard::currentBank - 48;
        sdCard::currentBankSending = fgetc(sdCard::currentBankFile.fp);
        sdCard::currentBankSending = sdCard::currentBankSending -48;
        sdCard::fechaArquivo(&sdCard::currentBankFile);
    }else{
        sdCard::currentBank = 3;
        sdCard::currentBankSending = 3;
        if(debug)pc.printf("sdCard::verificaCurrentBank[8]\r\n");
     }
    if((sdCard::currentBankSending > 1)||(sdCard::currentBank > 1)){
        sdCard::deleteBanks(2);
        /*if(debug)pc.printf("sdCard::verificaCurrentBank[3]\r\n");
        
        //Criando bank 0
        sdCard::excluiArquivo(&sdCard::bank0);
        if(sdCard::abreArquivo(&sdCard::bank0,"w")){
            sdCard::fechaArquivo(&sdCard::bank0);
        }else{
            if(debug)pc.printf("sdCard::verificaCurrentBank[4]\r\n");
            //return;
         }
        //Criando bank 1
        sdCard::excluiArquivo(&sdCard::bank1);
        if(sdCard::abreArquivo(&sdCard::bank1,"w")){
            sdCard::fechaArquivo(&sdCard::bank1);
        }else{            
            if(debug)pc.printf("sdCard::verificaCurrentBank[5]\r\n");
            //return;
         }
        //Criando currentBank
        sdCard::excluiArquivo(&sdCard::currentBankFile);
        if(sdCard::abreArquivo(&sdCard::currentBankFile,"w")){            
            fputc('0',sdCard::currentBankFile.fp);
            fputc('0',sdCard::currentBankFile.fp);
            //fflush(sdCard::currentBankFile.fp);
            sdCard::fechaArquivo(&sdCard::currentBankFile);
            sdCard::currentBank = 0;
            sdCard::currentBankSending = 0;
        }else{            
            if(debug)pc.printf("sdCard::verificaCurrentBank[6]\r\n");
            return;
         }*/
     }    
    if(debug)pc.printf("sdCard::verificaCurrentBank[7]\r\n");    
}

uint8_t sdCard::modificaCurrentBank(uint8_t newCurrentBank,uint8_t newCurrentBankSending){
    //sdCard::verificaCurrentBank();
    if((sdCard::currentBank == newCurrentBank)&&(sdCard::currentBankSending == newCurrentBankSending)){
        return 1;    
    }else{
        //if(!sdCard::excluiArquivo(&sdCard::currentBankFile)){return 0;}
        if(sdCard::abreArquivo(&sdCard::currentBankFile,"w")){
            if(newCurrentBank){fputc('1',sdCard::currentBankFile.fp);fflush(sdCard::currentBankFile.fp);}
            else{fputc('0',sdCard::currentBankFile.fp);fflush(sdCard::currentBankFile.fp);}
            if(newCurrentBankSending){fputc('1',sdCard::currentBankFile.fp);fflush(sdCard::currentBankFile.fp);}
            else{fputc('0',sdCard::currentBankFile.fp);fflush(sdCard::currentBankFile.fp);}
            sdCard::fechaArquivo(&sdCard::currentBankFile);            
            sdCard::currentBank = newCurrentBank;
            sdCard::currentBankSending = newCurrentBankSending;            
        }else{
            return 0;   
         }
     }
    return 1;
}

bool sdCard::insereDadosBank(char* data,uint16_t tam){
    //Struct do arquivo, dados a inserir e tamanho deles    
    uint16_t i;
    arquivoSD *arquivo;    
    //verificaCurrentBank();
    if(sdCard::currentBank > 1){
        if(debug)pc.printf("sdCard::insereDadosBank[1]\r\n");
        return false;
    }
    
    if(sdCard::currentBank){
        arquivo = &sdCard::bank1;
    }else{
        arquivo = &sdCard::bank0;
     }
    
    if(!sdCard::abreArquivo(arquivo,"a")){    
        sdCard::fechaArquivo(arquivo);
        if(debug)pc.printf("sdCard::insereDadosBank[2]\r\n");
        return false;        
    }
    
    for(i=0;i<tam;i++){
        //fprintf(arquivo->fp,"%c",data[i]);
        fputc(data[i],arquivo->fp);
        fflush(arquivo->fp);    
    }    
    sdCard::fechaArquivo(arquivo);
    if(debug)pc.printf("sdCard::insereDadosBank[3]\r\n");
    return true;
}

bool sdCard::insereDadosArquivo(arquivoSD *arquivo, char* data,uint16_t tam){
    //Struct do arquivo, dados a inserir e tamanho deles    
    uint16_t i;
    if(!sdCard::abreArquivo(arquivo,"a")){    
        sdCard::fechaArquivo(arquivo);    
        return false;        
    }
    
    for(i=0;i<tam;i++){
        //fprintf(arquivo->fp,"%c",data[i]);
        
        sdCard::checkSum+=data[i];
        
        fputc(data[i],arquivo->fp);
        fflush(arquivo->fp);    
    }    
    sdCard::fechaArquivo(arquivo); 
    
    return true;
}

uint32_t hextobin(char *hex,uint32_t len){
    int i;
    uint32_t bin=0;
    for(i=len;i>0;i--){
        if(hex[len-i]<65){            
            bin+=((hex[len-i]-48)<<(4*(i-1)));
        }else{
            bin+=((hex[len-i]-55)<<(4*(i-1)));
         }
    }
    return bin;    
}

bool sdCard::insereDadosArquivoHex(arquivoSD *arquivo, char* data,uint16_t tam){
    //Struct do arquivo, dados a inserir e tamanho deles    
    uint16_t i;
    char c,hex[3];
    
    
    if(!sdCard::abreArquivo(arquivo,"a")){    
        sdCard::fechaArquivo(arquivo);    
        return false;        
    }
    for(i=0;i<tam;i+=2){
        //fprintf(arquivo->fp,"%c",data[i]);
        
        hex[0]=data[i];
        hex[1]=data[i+1];        
        c = hextobin(hex,2);
        
        sdCard::checkSum+=c;
        fputc(c,arquivo->fp);
        fflush(arquivo->fp);    
    }    
    sdCard::fechaArquivo(arquivo); 
    return true;
}

bool sdCard::fechaArquivo(arquivoSD* arquivo){
    //Struct do arquivo
    fclose(arquivo->fp);
    arquivo->aberto = false;
    return true;    
}

bool sdCard::excluiArquivo(arquivoSD *arquivo){
    if(arquivo->aberto){
        sdCard::fechaArquivo(arquivo);
    }
    if(!remove(arquivo->nome)){return false;}
    arquivo->bytes = 0;
    return true;
}

bool sdCard::exibeArquivo(arquivoSD *arquivo){
    char c;    
    if(!sdCard::arquivoAberto(2000)){return false;}
    
    if(!sdCard::abreArquivo(arquivo,"r")){
        return false;
    }   
    
    if(debug)pc.printf("\n\nInicio do arquivo %s.\n\n",arquivo->nome);
    
    do{
        c = fgetc(arquivo->fp);
        if(!feof(arquivo->fp)){if(debug)pc.printf("%c",c);}
    }while(!feof(arquivo->fp));
    if(debug)pc.printf("\n\nFim do arquivo %s.\n",arquivo->nome);
    sdCard::fechaArquivo(arquivo);
    return true;    
}

int sdCard::init(){
    //Inicializando SDCard         
    
    strcpy(sdCard::bank0.nome,"/sd/RAD/bank0.txt");
    strcpy(sdCard::bank1.nome,"/sd/RAD/bank1.txt");
    strcpy(sdCard::currentBankFile.nome,"/sd/RAD/currentBank.txt");    
    strcpy(sdCard::config.nome,"/sd/RAD/config.bin");    
    strcpy(sdCard::devices.nome,"/sd/RAD/devices.cfg");
    strcpy(sdCard::status.nome,"/sd/RAD/status.txt");
    strcpy(sdCard::tempFile.nome,"/sd/RAD/tempFile.bin");        
    strcpy(sdCard::newFirmware.nome,"/sd/RAD/firmware.bin");        
    
    
    if(!sdCard::abreArquivo(&sdCard::devices,"r")){
        if(debug)pc.printf("Remota nao parametrizada!!!\n");
        mkdir("/sd/RAD", 0777);            
    }else{
        fechaArquivo(&sdCard::devices);   
     }
    sdCard::verificaCurrentBank();
    return 1;
}

bool sdCard::deleteBanks(uint8_t bank){
    switch(bank){
        case 0:
                sdCard::excluiArquivo(&sdCard::bank0);
                /*sdCard::abreArquivo(&sdCard::bank0,"w");
                sdCard::fechaArquivo(&sdCard::bank0);*/
            break;
        case 1:
                sdCard::excluiArquivo(&sdCard::bank1);
                /*sdCard::abreArquivo(&sdCard::bank1,"w");
                sdCard::fechaArquivo(&sdCard::bank1);*/
            break;
        case 2:
                sdCard::excluiArquivo(&sdCard::bank0);
                /*sdCard::abreArquivo(&sdCard::bank0,"w");
                sdCard::fechaArquivo(&sdCard::bank0);*/
                sdCard::excluiArquivo(&sdCard::bank1);
                /*sdCard::abreArquivo(&sdCard::bank1,"w");
                sdCard::fechaArquivo(&sdCard::bank1);    */
                sdCard::excluiArquivo(&sdCard::currentBankFile);
                if(sdCard::abreArquivo(&sdCard::currentBankFile,"w")){
                    fputc('0',sdCard::currentBankFile.fp);
                    fputc('0',sdCard::currentBankFile.fp);
                    fflush(sdCard::currentBankFile.fp);
                    sdCard::fechaArquivo(&sdCard::currentBankFile);
                }    
            break;    
    }
    return true;
}

int sdCard::preparaEnvio(void){         
    //Verifico se existe arquivo pendente de envio.    
    //if(!sdCard::arquivoAberto(5000)){return 2;}    
    //Incluindo o status no envio    
    modemCom::writeStatusToSD();    
    return 1;
}

bool sdCard::getFileTam(arquivoSD *arquivo){
    uint32_t tam=0;        
    
    if(!sdCard::arquivoAberto(5000)){return false;}
    
    if(arquivo->aberto){
        fechaArquivo(arquivo);
    }        
    
    if(sdCard::abreArquivo(arquivo,"r")){                    
        fseek(arquivo->fp, 0, SEEK_END); // seek to end of file
        tam = ftell(arquivo->fp);       // get current file pointer
        fseek(arquivo->fp, 0, SEEK_SET); // seek back to beginning of file         
        
        /*while(fgetc(arquivo->fp)!=EOF){
            tam++;
        }*/
        
        sdCard::fechaArquivo(arquivo);
    }else{
        return false;   
     }
    arquivo->bytes = tam;
    return true;
}

bool sdCard::arquivoAberto(uint16_t timeOut){
    timeOut /= 100;    
    while(
    (sdCard::bank0.aberto||sdCard::bank1.aberto||sdCard::currentBankFile.aberto||sdCard::config.aberto||sdCard::devices.aberto||sdCard::status.aberto||sdCard::tempFile.aberto||sdCard::arquivosAbertos)
    &&
    timeOut){
     timeOut--;
     if((timeOut%10)==0){if(debug)pc.printf("Timeout em arquivoAberto()<%lu>.\r\n",timeOut);}
     osDelay(100);           
    }
    if(timeOut){return true;}
    else{return false;}
}


//----------------------------------------------
// file_rename: renames a file (via copy & delete).
//    Moves data instead of adjusting the file name in the
//    file directory. Checks to insure the file was renamed.
//    Returns 0 = error; 1 = success
//----------------------------------------------
/*uint8_t sdCard::file_rename(const char *oldfname, const char *newfname) {    
    //rename(oldfname,newfname);
    int retval = 0;
    int ch;
    sdCard::envio.bytes=0;    
    
    if(!sdCard::arquivoAberto(30000)){return false;}
    
    
    FILE *fpold = fopen(oldfname, "r");   // src file
    
    if(fpold == NULL){
        if(debug)pc.printf("file_rename 4.\r\n");
        fclose(fpold);
        return 0;    
    }    
    
    FILE *fpnew = fopen(newfname, "w");   // dest file
    
    if(fpnew == NULL){      
    
        fclose(fpnew);        
        return 0;    
    }    
    
    if(debug)pc.printf("Iniciando copia.\n");
    
    sdCard::envio.bytes=0;
    ch = fgetc(fpold);    
    while(ch != EOF){
        fputc(ch, fpnew);    
        ch = fgetc(fpold);
        sdCard::envio.bytes++;    
    }    
    
    fclose(fpnew);
    fclose(fpold);
 
    fpnew = fopen(newfname, "r"); // Reopen dest to insure
    if(fpnew == NULL) {           // that it was created.
        retval = (0);            // Return Error.
    } 
    else {
        fclose(fpnew);  
        remove(oldfname);         // Remove original file.
        retval = (1);             // Return Success.
    }
    sdCard::arquivosAbertos=false;
    if(debug)pc.printf("file_rename retval <%lu>.\r\n",retval);
    return (retval);
}*/



//***********************************************************
// file_rename: renames a file (via copy & delete).
//    Moves data instead of adjusting the file name in the
//    file directory. Checks to insure the file was renamed.
//    Returns 0 = error; 1 = success
//***********************************************************



uint8_t sdCard::file_rename(const char *oldfname, const char *newfname) {    
    /*if(remove(oldfname)<0){
        if(debug)pc.printf("file_rename 1.\r\n");
        return 0;
    }    
    if(rename(oldfname,newfname)<0){
        if(debug)pc.printf("file_rename 2.\r\n");
        return 0;
    }else{
        if(debug)pc.printf("file_rename 3.\r\n");
        return 1;   
     }*/
    
    #define maxTamFileCopy 128
    char bufCopy[maxTamFileCopy];
    uint8_t retval = 0;
    uint32_t fileSize = 0;
    uint32_t fileNumParts = 0;
    uint32_t fileEnding=0;
    
    uint32_t i,j;    
    if(!sdCard::arquivoAberto(30000)){return false;}    
    FILE *fpold = fopen(oldfname, "r");   // src file
    
    if(fpold == NULL){        
        fclose(fpold);
        return 0;    
    }    
    
    sdCard::arquivosAbertos = true;
    
    FILE *fpnew = fopen(newfname, "w");   // dest file
    
    if(fpnew == NULL){          
        fclose(fpnew);        
        sdCard::arquivosAbertos = false;
        return 0;        
    }    
    
    
    if(debug)pc.printf("Iniciando copia.\n");
    
    
    fseek(fpold, 0, SEEK_END); // seek to end of file
    fileSize = ftell(fpold);       // get current file pointer
    fseek(fpold, 0, SEEK_SET); // seek back to beginning of file    
    
    
    fileNumParts = fileSize/maxTamFileCopy;
    fileEnding = fileSize%maxTamFileCopy;    
    for(i=0;i<fileNumParts;i++){
        for(j=0;j<maxTamFileCopy;j++){
            bufCopy[j]=fgetc(fpold);
        }
        for(j=0;j<maxTamFileCopy;j++){
            fputc(bufCopy[j],fpnew);
        }
    }    
    for(j=0;j<fileEnding;j++){
        bufCopy[j]=fgetc(fpold);
    }
    for(j=0;j<fileEnding;j++){
        fputc(bufCopy[j],fpnew);
    }    
    fclose(fpnew);
    fclose(fpold);    
 
    fpnew = fopen(newfname, "r"); // Reopen dest to insure
    if(fpnew == NULL) {           // that it was created.
        retval = (0);            // Return Error.
    } 
    else {
        fclose(fpnew);  
        remove(oldfname);         // Remove original file.
        retval = (1);             // Return Success.
    }
    sdCard::arquivosAbertos=false;
    if(debug)pc.printf("file_rename retval <%lu>.\r\n",retval);
    
    return (retval);
    
}
