#include "diversos.h"
// - 09/01/2018
bool eventosRTC::segundos;
bool eventosRTC::minutos;
bool eventosRTC::rotina10Segundos;
char eventosRTC::rotinaEnvioDeDados;
bool eventosRTC::rotina1hora;
bool eventosRTC::rotina1segundo;
WatchdogTimer diversos::wdt;
char commands::buffer[tamBufferCommands];


uint32_t diversos::memAvailable(){
   char   stackVariable;
   char   *heap;
   uint32_t result;
   heap  = (char*)malloc(1);
   result  = (uint32_t) ((&stackVariable) - heap);
   free(heap);
   return result;
}

void WatchdogTimer::kick(float s) {
        LPC_WDT->WDCLKSEL = 0x1;                // Set CLK src to PCLK
        uint32_t clk = SystemCoreClock / 16;    // WD has a fixed /4 prescaler, PCLK default is /4
        LPC_WDT->WDTC = s * (float)clk;
        LPC_WDT->WDMOD = 0x3;                   // Enabled and Reset
        kick();
    }
// "kick" or "feed" the dog - reset the watchdog timer
// by writing this required bit pattern
void WatchdogTimer::kick() {
    LPC_WDT->WDFEED = 0xAA;
    LPC_WDT->WDFEED = 0x55;
}

/*double diversos::stringToFloat(char *p,uint16_t max){    
    uint16_t caractere=0;
    double iPart=0.0,dPart=0.0,f=0.0,mult=0.1;
    while(*p != '.') {
         caractere++;
         if(caractere>(max-1)){return 0.0;}
         iPart = (iPart*10) + (double)((*(p++)-'0')); 
    }
    p++;
    while(*p!= '\0') {
         if(caractere>(max-1)){return 0.0;}
         dPart += (double)(((*(p++)-'0'))*mult);
         mult /= 10;
    }
    f = iPart + dPart;
    return f;
}*/

/*double diversos::stringToFloat(char *p,uint16_t max){    
    uint16_t caractere=0;    
    double iPart=0.0,dPart=0.0,f=0.0,mult=0.1;
    while(p[caractere] != '.'){
         caractere++;
         if(caractere>(max-1)){return 0.0;}
         iPart = (iPart*10) + (((uint8_t)p[caractere])-30); 
    }
    caractere++;
    while(p[caractere]!= '\0'){
         if(caractere>(max-1)){return 0.0;}
         dPart += (((uint8_t)p[caractere])-30)*mult;
         mult /= 10;
    }
    f = iPart + dPart;
    return f;
}*/

void diversos::strReplace(char *str, char *find, char *replace){
    char aux[100];
    char *ptr;
    char replaced = 0;
    char maxIterations = 0;
    replaced = 0;
    strcpy(aux,"");
    ptr = strtok(str,find);
    while((ptr!=NULL)&&(maxIterations<9)){
        replaced = 1;
        maxIterations++;
        strcat(aux,ptr);
        strcat(aux,replace);    
        ptr = strtok(NULL,find); 
        pc.printf("Tirando <%s> em <%s>.\r\n",find,str);   
    }   
    if(replaced){    
     aux[strlen(aux)-1]=0;
     strcpy(str,aux);
    }
    //--------------------
}

bool isxdigit(char c){    
    if((c>47)&&(c<58)){return true;}
    if((c>64)&&(c<71)){return true;}
    if((c>96)&&(c<103)){return true;}
    return false;
}

void diversos::urldecode2(char *dst, const char *src){
        char a, b;
        while (*src) {
                if ((*src == '%') &&
                    ((a = src[1]) && (b = src[2])) &&
                    (isxdigit(a) && isxdigit(b))) {
                        if (a >= 'a')
                                a -= 'a'-'A';
                        if (a >= 'A')
                                a -= ('A' - 10);
                        else
                                a -= '0';
                        if (b >= 'a')
                                b -= 'a'-'A';
                        if (b >= 'A')
                                b -= ('A' - 10);
                        else
                                b -= '0';
                        *dst++ = 16*a+b;
                        src+=3;
                } else if (*src == '+') {
                        *dst++ = ' ';
                        src++;
                } else {
                        *dst++ = *src++;
                }
        }
        *dst++ = '\0';
}

void diversos::processaPulsosEDs(){    
    if(ED1){pulsosEDs[0]++;}    
    if(ED2){pulsosEDs[1]++;}    
    if(ED3){pulsosEDs[2]++;}    
}

void diversos::progressBar(uint32_t progresso,uint32_t total){
     int i,j;
     char maxTam = 20;
     char engrenagem[4]={179,0x2F,0x2D,0x5C};
     
     j=((double)progresso/(double)total)*maxTam;
     pc.printf("%c%c%c<",179,engrenagem[(unsigned int)progresso%4],179);
     for(i=0;i<maxTam;i++){
      if(i<=j){
       pc.printf("%c",178);       
      }else{
        pc.printf("%c",176);
       }                       
     }
     pc.printf("> %3.0f%% Progresso %5lu de %5lu\r ",((double)progresso/(double)total)*100,progresso,total);    
}


void commands::exec(uint8_t idConnection){
    char *ptr,*pCharFile,*ptrComando;
    char msg[100];
    uint16_t currentCur,totalLengthCommands;
    static uint16_t fileCheckSum16BIT,checkSum16BIT_Lido;
        
    totalLengthCommands = strlen(commands::buffer);
    ptrComando = strtok(commands::buffer,";");
    
    do{        
        
        
        
        ptr=strstr(ptrComando,"DELETE_SENT_FILES");
        if(ptr) {            
            sdCard::deleteSentFiles = true;
        }
        
        ptr=strstr(ptrComando,"SET_RTC:");
        if(ptr) {
            ptr = strtok(ptr,":");
            ptr = strtok(NULL,";");
            set_time(atoi(ptr));
            time_t seconds = time(NULL);    
            pc.printf("Horario atualizado pelo server %s",ctime(&seconds));
        }
        
        ptr=strstr(ptrComando,"sendArmazenamento");
        if(ptr) {            
            sprintf(msg,"sendArmazenamento_ack");   
            modemCom::sendBufferCommandMode(idConnection,msg,strlen(msg));
            eventosRTC::rotinaEnvioDeDados=maxTentativasEnvioDados;
            modemCom::timeOutEnvioDados=maxTimeEnvioDados;
        }
        
        ptr=strstr(ptrComando,"deleteArmazenamento");
        if(ptr) {
            sdCard::deleteBanks(2);
            sprintf(msg,"deleteArmazenamento_ack");   
            modemCom::sendBufferCommandMode(idConnection,msg,strlen(msg));
        }
        
        ptr=strstr(ptrComando,"StartSendFile");
        if(ptr){        
            modemCom::status.timeOut=100;
            sdCard::nBytesArquivoRecebidos = 0;
            sdCard::checkSum = 0;
            strtok(ptr,",");//Descartando inicio
            pCharFile = strtok(NULL,",");//Selecionando nome do arquivo                   
            strcpy(sdCard::nomeArquivoEmRecebimento,pCharFile);        
            pCharFile = strtok(NULL,";");//Selecionando string checkSum16BIT        
            fileCheckSum16BIT = atoi(pCharFile);
            remove("/sd/RAD/tempFile.bin");
            pc.printf("Iniciando recepcao do server arquivo deviceCfg.\n");
            modemCom::status.recebendoArquivoDoServer = 250;
            diversos::wdt.kick(180.0);
            
            
            /*
            sprintf(msg,"AT+CIPSEND=%u,%lu\r\n",idConnection,10);
            if(modemCom::sendToModem(msg,1,&modemCom::status.OK,NULL,20,3,1000)){
                modemCom::sendToModem("sendData\r\n",0,NULL,NULL,20,3,1000);
            }
            */
            sprintf(msg,"sendData\r\n");
            modemCom::cipSend(idConnection,msg,10);
            /*
            modem.puts(modemCom::bufIn);
            osDelay(100);
            modem.puts("sendData\r\n");*/
            
            //pc.printf("sendData\n");                                
            modemCom::timeOutModem = 150;
            return;
        }        
                                     
        ptr=strstr(ptrComando,"StopSendFile");
        if(ptr){
            pc.printf("Finalizando recepcao de arquivo.\n");
            checkSum16BIT_Lido = sdCard::checkSum;//sdCard::calcCheckSum16BITFile("/sd/RAD/tempFile.bin");
            pc.printf("Feito o calculo de CRC = %lu.\n",checkSum16BIT_Lido);
            if(fileCheckSum16BIT == checkSum16BIT_Lido){
                if(sdCard::file_rename("/sd/RAD/tempFile.bin",sdCard::nomeArquivoEmRecebimento)){                    
                    sprintf(msg,"File Received checkSum16BIT_Lido <%lu>.\r\n",checkSum16BIT_Lido);
                    modemCom::sendBufferCommandMode(idConnection,msg,strlen(msg));
                    pc.printf("File Received checkSum16BIT_Lido <%lu>.\r\n",checkSum16BIT_Lido);
                    
                    if(strstr(sdCard::nomeArquivoEmRecebimento,"config.bin")!=NULL){                                                
                        pc.printf("Resetando o drome.\r\n");
                        hardwareReset=true;
                    }
                    
                    if(strstr(sdCard::nomeArquivoEmRecebimento,"devices.cfg")!=NULL){                                                
                        sdCard::deleteBanks(2);
                        pc.printf("Resetando o drome.\r\n");
                        hardwareReset=true;
                    }
                    
                    if(strstr(sdCard::nomeArquivoEmRecebimento,"firmware.bin")!=NULL){                                                
                        pc.printf("Chamando bootloader.\r\n");
                        callBootLoader = true;
                    }                    
                }else{
                    //modemCom::sendBufferCommandMode(2,"FileCorrupted.\r\n",strlen("FileCorrupted.\r\n"));                                        
                    sprintf(msg,"erro");
                    modemCom::sendBufferCommandMode(idConnection,msg,strlen(msg));
                    pc.printf("Recebido correto mas n foi possivel renomear arquivo.\r\n");                    
                 }                    
            }else{
                /*sprintf(diversos::msg,"File Corrupted checkSum16BIT_Lido <%lu>.\r\n",checkSum16BIT_Lido);
                modemCom::sendBufferCommandMode(2,diversos::msg,strlen(diversos::msg));*/                
                sprintf(msg,"erro");
                modemCom::sendBufferCommandMode(idConnection,msg,strlen(msg));
                pc.printf("File Corrupted checkSum16BIT_Lido <%lu>.\r\n",checkSum16BIT_Lido);
             }
            modemCom::status.recebendoArquivoDoServer = 0;            
            modemCom::timeOutModem = 50;
            modemCom::status.timeOut = 30;
        }
        
        /*ptr=strstr(ptrComando,"requestFile,");
        if(ptr){            
            FILE *fp;
            char c;
            strtok(ptr,",");
            pCharFile = strtok(NULL,";");
            
            fp = fopen(pCharFile,"r");
            if(fp!=NULL){
                do{
                    c = fgetc(fp);
                    if(!feof(fp)){modem.printf("%c",c);}
                    modemCom::status.timeOut=10;
                }while(!feof(fp));
                fclose(fp);
            }else{
                modem.printf("Nao foi possivel abrir o arquivo.\n");   
             }
        }*/
        
        ptr=strstr(ptrComando,"execAct:");    
        if(ptr){
            char *pChar;
            uint32_t actId;
            pChar = strtok(ptr,":");
            pChar = strtok(NULL,"");
            actId = atoi(pChar);        
            if(execAct(actId)){
                sprintf(msg,"execAct_ack");                
            }else{
                sprintf(msg,"execAct_nack");   
             }            
            modemCom::sendBufferCommandMode(idConnection,msg,strlen(msg));    
        }
        
        if(strstr(ptr,"enviaDadosAoServer")){                                    
            sprintf(msg,"ack");
            modemCom::sendBufferCommandMode(idConnection,msg,strlen(msg));    
            eventosRTC::rotinaEnvioDeDados=maxTentativasEnvioDados;
            modemCom::timeOutEnvioDados=maxTimeEnvioDados;
        }
        
        ptr=strstr(ptrComando,"mbwrite:");    
        if(ptr){
            uint8_t addr;
            uint16_t reg;
            uint32_t auxMod;        
            char *pChar;        
            
            //IR
            if(strstr(ptr,"IR,")){
                uint8_t freq=38,porta=0;
                pChar = strtok(ptr,",");                
                freq = atoi(strtok(NULL,","));
                porta = atoi(strtok(NULL,","));                              
                                
                pChar = strtok(NULL,"S");
                deserializaPacoteIR(pChar);
                enviaComandoIR(freq,porta);
                sprintf(msg,"WriteIR_ack");
                modemCom::sendBufferCommandMode(idConnection,msg,strlen(msg));    
            }
            
            //Float
            if(strstr(ptr,"float,")){
                float v_float;        
                
                //Capturando parametros comuns
                pChar = strtok(ptr,",");
                    
                //Parametro 1
                pChar = strtok(NULL,",");
                addr = atoi(pChar);        
                
                //Parametro 2
                pChar = strtok(NULL,",");
                reg = atoi(pChar);
                
                //Parametro 3 
                pChar = strtok(NULL,",");
                //v_float = diversos::stringToFloat(pChar,50);
                v_float = atof(pChar);
            
                //Envio o dado via Modbus                    
                if(!modBusMaster1::writeFloat(addr,reg,1,&v_float)){
                    //pc.printf("Valor <%f> escrito no registrador %lu do endereco modbus %u.\n",v_float,reg,addr);
                    /*sprintf(diversos::msg,"WriteFloat_ack");
                    modemCom::sendBufferCommandMode(2,diversos::msg,strlen(diversos::msg));*/
                    
                    sprintf(msg,"WriteFloat_ack");
                    modemCom::sendBufferCommandMode(idConnection,msg,strlen(msg));
                }else{
                    //pc.printf("Erro ao escrever valor <%f> no registrador %lu do endereco modbus %u.\n",v_float,reg,addr);
                    /*sprintf(diversos::msg,"WriteFloat_nack");
                    modemCom::sendBufferCommandMode(2,diversos::msg,strlen(diversos::msg));*/
                    
                    sprintf(msg,"WriteFloat_nack");
                    modemCom::sendBufferCommandMode(idConnection,msg,strlen(msg));
                 }                 
            }
            
            //PWM
            if(strstr(ptr,"PWM,")){
                float v_float;        
                
                //Capturando parametros comuns
                pChar = strtok(ptr,",");
                    
                //Parametro 1
                pChar = strtok(NULL,",");
                addr = atoi(pChar);        
                
                //Parametro 2
                pChar = strtok(NULL,",");
                reg = atoi(pChar);
                
                //Parametro 3 
                pChar = strtok(NULL,",");
                //v_float = diversos::stringToFloat(pChar,50);
                v_float = atof(pChar);
                
                pc.printf("\r\n\r\nVerificando conteudo de pChar antes de converter para float <%s>.\r\n",pChar);                
                
                //Retirando a parte inteira referente ao periodo em us do pwm
                                    
                auxMod = v_float/10;
                v_float = v_float-(auxMod*10);
                SD1.period_us(auxMod);
                pwmPeriod = auxMod;
                switch(reg){
                    case 0:                                
                            SD1.write(v_float);
                        break;
                    case 1:                       
                            SD2.write(v_float);
                        break;
                    case 2:                       
                            SD3.write(v_float);
                        break;
                    case 3:                       
                            SD4.write(v_float);
                        break;
                    case 4:                       
                            SD5.write(v_float);
                        break;
                    case 5:                       
                            SD6.write(v_float);
                        break;                    
                 }
                 //pc.printf("Valor puro %f, %lu escrito como periodo e %f como duty no reg %u.\n",v_float,auxMod,v_float,reg);
                /*sprintf(diversos::msg,"WriteFloat_ack");
                modemCom::sendBufferCommandMode(2,diversos::msg,strlen(diversos::msg));*/
                
                sprintf(msg,"WritePWM_ack");
                modemCom::sendBufferCommandMode(idConnection,msg,strlen(msg));
            }
            
            //uint32_t
            if(strstr(ptr,"uint32_t,")){
                uint32_t v_uint32_t;        
    
                //Capturando parametros comuns
                pChar = strtok(ptr,",");
                    
                //Parametro 1
                pChar = strtok(NULL,",");
                addr = atoi(pChar);        
                
                //Parametro 2
                pChar = strtok(NULL,",");
                reg = atoi(pChar);
    
                //Parametro 3 
                pChar = strtok(NULL,",");
                v_uint32_t = atoi(pChar);
                
                if(!modBusMaster1::writeRegister32BIT(addr,reg,1,&v_uint32_t)){
                    pc.printf("Valor <%lu> escrito no registrador %lu do endereco modbus %u.\n",v_uint32_t,reg,addr);
                    /*sprintf(diversos::msg,"Write_uint32_t_ack");
                    modemCom::sendBufferCommandMode(2,diversos::msg,strlen(diversos::msg));*/
                    
                    sprintf(msg,"Write_uint32_t_ack");
                    modemCom::sendBufferCommandMode(idConnection,msg,strlen(msg));
                }else{
                    pc.printf("Erro ao escrever valor <%lu> no registrador %lu do endereco modbus %u.\n",v_uint32_t,reg,addr);
                    /*sprintf(diversos::msg,"Write_uint32_t_nack");
                    modemCom::sendBufferCommandMode(2,diversos::msg,strlen(diversos::msg));*/
                    
                    sprintf(msg,"Write_uint32_t_nack");
                    modemCom::sendBufferCommandMode(idConnection,msg,strlen(msg));
                 }            
            }
            
            //uint16_t
            if(strstr(ptr,"uint16_t,")){
                uint16_t v_uint16_t;        
    
                //Capturando parametros comuns
                pChar = strtok(ptr,",");
                    
                //Parametro 1
                pChar = strtok(NULL,",");
                addr = atoi(pChar);        
                
                //Parametro 2
                pChar = strtok(NULL,",");
                reg = atoi(pChar);
    
                //Parametro 3 
                pChar = strtok(NULL,",");
                v_uint16_t = atoi(pChar);
                
                if(!modBusMaster1::writeRegister16BIT(addr,reg,1,&v_uint16_t)){
                    pc.printf("Valor <%lu> escrito no registrador %lu do endereco modbus %u.\n",v_uint16_t,reg,addr);
                    /*sprintf(diversos::msg,"Write_uint16_t_ack");
                    modemCom::sendBufferCommandMode(2,diversos::msg,strlen(diversos::msg));*/
                    
                    sprintf(msg,"Write_uint16_t_ack");
                    modemCom::sendBufferCommandMode(idConnection,msg,strlen(msg));
                }else{
                    pc.printf("Erro ao escrever valor <%lu> no registrador %lu do endereco modbus %u.\n",v_uint16_t,reg,addr);
                    /*sprintf(diversos::msg,"Write_uint16_t_nack");
                    modemCom::sendBufferCommandMode(2,diversos::msg,strlen(diversos::msg));                    */
                    
                    sprintf(msg,"Write_uint16_t_nack");
                    modemCom::sendBufferCommandMode(idConnection,msg,strlen(msg));
                 }            
            }
            
            //bit
            if(strstr(ptr,"bit,")){
                bool v_bool;        
    
                //Capturando parametros comuns
                pChar = strtok(ptr,",");
                    
                //Parametro 1
                pChar = strtok(NULL,",");
                addr = atoi(pChar);        
                
                //Parametro 2
                pChar = strtok(NULL,",");
                reg = atoi(pChar);
    
                //Parametro 3 
                pChar = strtok(NULL,",");
                v_bool = (atoi(pChar) > 0);
                
                if(addr != enderecoControladoraVirtual){
                    //writeSingleCoil(uint8_t,uint16_t,bool); //Endereço slave, registrador, bool
                    if(!modBusMaster1::writeSingleCoil(addr,reg,v_bool)){
                        pc.printf("Valor <%u> escrito no registrador %lu do endereco modbus %u.\n",v_bool,reg,addr);
                        /*sprintf(diversos::msg,"Write_bool_ack");
                        modemCom::sendBufferCommandMode(2,diversos::msg,strlen(diversos::msg));*/
                        
                        sprintf(msg,"Write_bool_ack");
                        modemCom::sendBufferCommandMode(idConnection,msg,strlen(msg));
                    }else{
                        pc.printf("Erro ao escrever valor <%u> no registrador %lu do endereco modbus %u.\n",v_bool,reg,addr);
                        /*sprintf(diversos::msg,"Write_bool_nack");
                        modemCom::sendBufferCommandMode(2,diversos::msg,strlen(diversos::msg));*/
                        
                        sprintf(msg,"Write_bool_nack");
                        modemCom::sendBufferCommandMode(idConnection,msg,strlen(msg));
                     }            
                }else{
                    switch(reg){
                        case 0:                                
                                SD1.write(v_bool*1.0f);
                            break;
                        case 1:                               
                                SD2.write(v_bool*1.0f);
                            break;
                        case 2:
                                SD3.write(v_bool*1.0f);
                            break;
                        case 3:
                                SD4.write(v_bool*1.0f);
                            break;
                        case 4:
                                SD5.write(v_bool*1.0f);
                            break;
                        case 5:
                                SD6.write(v_bool*1.0f);
                            break;
                        case 6:
                                SD7 = v_bool;
                            break;                            
                        case 7:
                                SD8 = v_bool;
                            break;                            
                    }
                    pc.printf("Valor <%u> escrito no registrador %lu do endereco modbus %u.\n",v_bool,reg,addr);
                    /*sprintf(diversos::msg,"Write_bool_ack");
                    modemCom::sendBufferCommandMode(2,diversos::msg,strlen(diversos::msg));*/
                    
                    sprintf(msg,"Write_bool_ack");
                    modemCom::sendBufferCommandMode(idConnection,msg,strlen(msg));
                 }
            } 
            modemCom::status.timeOut=5;       
        }
        
        currentCur = strlen(ptrComando) + 1; //Aqui eu pego onde devo buscar novamente mais algum comando.
        if(currentCur>=totalLengthCommands){
         //modemCom::status.timeOut=10;
         ptrComando = NULL;
        }else{
            ptrComando = strtok(&ptrComando[currentCur],";");   
         }
    }while(ptrComando != NULL);//Este loop executa cada instrução.    
    pc.printf("Atendidos todos os comandos.\n");    
}
