#include "bootloader.h"
#define IAP_LOCATION    0x1fff1ff1
#define memBufTam 1024
bool callBootLoader = false;
char memBufConfigBootLoader[256];
char executaBootLoader;
uint32_t tamFirmware;
//firmwareDescriptor firmDesc;
IAP IAP_call;
/*****************************************************************************//**
 * @brief       De-initializes the NVIC peripheral registers to their default
 *              reset values.
 * @param       None
 * @return      None
 *
 * These following NVIC peripheral registers will be de-initialized:
 * - Disable Interrupt (32 IRQ interrupt sources that matched with LPC17xx)
 * - Clear all Pending Interrupts (32 IRQ interrupt source that matched with LPC17xx)
 * - Clear all Interrupt Priorities (32 IRQ interrupt source that matched with LPC17xx)
 *******************************************************************************/
void NVIC_DeInit(void)
{
    uint8_t tmp;

    /* Disable all interrupts */
    NVIC->ICER[0] = 0xFFFFFFFF;
    NVIC->ICER[1] = 0x00000001;
    /* Clear all pending interrupts */
    NVIC->ICPR[0] = 0xFFFFFFFF;
    NVIC->ICPR[1] = 0x00000001;

    /* Clear all interrupt priority */
    for (tmp = 0; tmp < 32; tmp++) {
        NVIC->IP[tmp] = 0x00;
    }
}



/*****************************************************************************//**
 * @brief           De-initializes the SCB peripheral registers to their default
 *                  reset values.
 * @param           none
 * @return          none
 *
 * These following SCB NVIC peripheral registers will be de-initialized:
 * - Interrupt Control State register
 * - Interrupt Vector Table Offset register
 * - Application Interrupt/Reset Control register
 * - System Control register
 * - Configuration Control register
 * - System Handlers Priority Registers
 * - System Handler Control and State Register
 * - Configurable Fault Status Register
 * - Hard Fault Status Register
 * - Debug Fault Status Register
 *******************************************************************************/
void NVIC_SCBDeInit(void)
{
    uint8_t tmp;

    SCB->ICSR = 0x0A000000;
    SCB->VTOR = 0x00000000;
    SCB->AIRCR = 0x05FA0000;
    SCB->SCR = 0x00000000;
    SCB->CCR = 0x00000000;

    for (tmp = 0; tmp < 32; tmp++) {
        SCB->SHP[tmp] = 0x00;
    }

    SCB->SHCSR = 0x00000000;
    SCB->CFSR = 0xFFFFFFFF;
    SCB->HFSR = 0xFFFFFFFF;
    SCB->DFSR = 0xFFFFFFFF;
}

#define APPL_RUN_ADDR 0x70000
__asm void boot_jump(uint32_t address)
{
    LDR SP, [R0]
    LDR PC, [R0, #4]
}

void flashPrepare(){
    IAP_call=(IAP) IAP_LOCATION;
}

void firmDescToFlash(){
    //Guardo tamanho do firmware em bytes na flash no setor 29    
    //Preparing flash sectors to write    
    unsigned int commandBytes[5];
    unsigned int outputBytes[5]; 
    
    //Preparo setores
    commandBytes[0]=50;
    commandBytes[1]=29;
    commandBytes[2]=29;
    commandBytes[3]=96000;
    commandBytes[4]=0x0;
    IAP_call(commandBytes,outputBytes);    
    if(outputBytes[0]!=0x0){
        printf("Falha na escrita em flash parte 7 -> codigo [%lu].\r\n",outputBytes[0]);
        return;
    }    
    
    //Erasing flash sectors
    commandBytes[0]=52;
    commandBytes[1]=29;
    commandBytes[2]=29;
    commandBytes[3]=96000;
    commandBytes[4]=0x0;
    IAP_call(commandBytes,outputBytes);    
    if(outputBytes[0]!=0x0){
        printf("Falha na escrita em flash parte 2 -> codigo [%lu].\r\n",outputBytes[0]);
        return;
    }
    
    //Preparo setores
    commandBytes[0]=50;
    commandBytes[1]=29;
    commandBytes[2]=29;
    commandBytes[3]=96000;
    commandBytes[4]=0x0;
    IAP_call(commandBytes,outputBytes);    
    if(outputBytes[0]!=0x0){
        printf("Falha na escrita em flash parte 7 -> codigo [%lu].\r\n",outputBytes[0]);
        return;
    }  
    
    memBufConfigBootLoader[0]=(tamFirmware>>24)&0xFF;
    memBufConfigBootLoader[1]=(tamFirmware>>16)&0xFF;
    memBufConfigBootLoader[2]=(tamFirmware>>8)&0xFF;
    memBufConfigBootLoader[3]=(tamFirmware>>0)&0xFF;
    memBufConfigBootLoader[4]=executaBootLoader;
    
    //escrevo nos setores
    commandBytes[0]=51;
    commandBytes[1]=((unsigned long) sector_start_adress[29]);
    commandBytes[2]=(unsigned long) memBufConfigBootLoader;
    commandBytes[3]=256;
    commandBytes[4]=96000;
    
    IAP_call(commandBytes,outputBytes);
    
    if(outputBytes[0]!=0x0){
        printf("Falha na escrita em flash parte 8 -> codigo [%lu].\r\n",outputBytes[0]);
        return;
    }    
}

void bootLoader(void)
{
     /* Change the Vector Table to the USER_FLASH_START
     in case the user application uses interrupts */
     diversos::wdt.kick(90.0);
     SysTick->CTRL &= ~0x00000002;           // disable SysTick interrupt
     //NVIC_DeInit();     
     //__disable_irq();
     LPC_SC->PCONP = 0x001817BE;
     SCB->VTOR = APPL_RUN_ADDR & 0x1FFFF80;
     boot_jump(APPL_RUN_ADDR);
}

uint8_t bootloader_fillUpFlash(arquivoSD *arquivo){
    #define flashSectorFirmwareCopyOffset 20
    
    /*IAP IAP_call;
    IAP_call=(IAP) IAP_LOCATION;*/
    
    //firmwareDescriptor firmDesc;
    unsigned int commandBytes[5];
    unsigned int outputBytes[5]; 
    uint32_t i;
    uint32_t chunkIndex=0;
    uint32_t nChunks,nEndChunk; 
    unsigned char memBuf[memBufTam];   
    sdCard::getFileTam(arquivo);
    tamFirmware = 0;
    if(!sdCard::abreArquivo(arquivo,"r")){
        printf("Arquivo nao encontrado.\r\n");
        while(1);    
    }
    
    //Excluindo o start no inicio
    tamFirmware=arquivo->bytes-5;
    for(i=0;i<5;i++){
        memBuf[i] = fgetc(arquivo->fp);
        //printf("%c",memBuf[i]);
    }    
    nChunks   = tamFirmware/memBufTam;
    nEndChunk = tamFirmware%memBufTam;       
    
    printf("Tamanho do arquivo %s = %lu bytes.\r\n",arquivo->nome,tamFirmware);
    printf("nChunks = %lu, nEndChunk = %lu.\r\n",nChunks,nEndChunk);
    printf("Iniciando processo de escrita em flash.\r\nDesligando interrupcoes.\r\n");
    
    
    //Preparing flash sectors to write
    commandBytes[0]=50;
    commandBytes[1]=20;
    commandBytes[2]=26;
    commandBytes[3]=96000;
    commandBytes[4]=0x0;
    IAP_call(commandBytes,outputBytes);    
    if(outputBytes[0]!=0x0){
        printf("Falha na escrita em flash parte 1 -> codigo [%lu].\r\n",outputBytes[0]);
        return 0;
    }
        
    //Erasing flash sectors
    commandBytes[0]=52;
    commandBytes[1]=20;
    commandBytes[2]=26;
    commandBytes[3]=96000;
    commandBytes[4]=0x0;
    IAP_call(commandBytes,outputBytes);    
    if(outputBytes[0]!=0x0){
        printf("Falha na escrita em flash parte 2 -> codigo [%lu].\r\n",outputBytes[0]);
        return 0;
    }    
    
    //Flashing entire chunks
    for(chunkIndex=0;chunkIndex<nChunks;chunkIndex++){        
        //Load from file to ram
        printf("Escrevendo o chunk %lu.\r\n",chunkIndex);
        //printf("Conteudo do chunk <");
        for(i=0;i<memBufTam;i++){
            memBuf[i] = fgetc(arquivo->fp);
            //printf("%c",memBuf[i]);
        }
        //printf(">.\r\n");                
                
        //Copy from ram to flash
        //Preparing flash sectors to write
        commandBytes[0]=50;
        commandBytes[1]=20;
        commandBytes[2]=26;
        commandBytes[3]=96000;
        commandBytes[4]=0x0;
        IAP_call(commandBytes,outputBytes);    
        if(outputBytes[0]!=0x0){
            printf("Falha na escrita em flash parte 3 -> codigo [%lu].\r\n",outputBytes[0]);
            return 0;
        }
        
        //Flashing this part
        commandBytes[0]=51;
        commandBytes[1]=((unsigned long) sector_start_adress[flashSectorFirmwareCopyOffset])+(chunkIndex*memBufTam);
        commandBytes[2]=(unsigned long)memBuf;
        commandBytes[3]=memBufTam;
        commandBytes[4]=96000;
        IAP_call(commandBytes,outputBytes);
        if(outputBytes[0]!=0x0){
            printf("Falha na escrita em flash parte 4 -> codigo [%lu].\r\n",outputBytes[0]);
            return 0;
        }
    }
    
    
    //Flashing the last part     
    //Preparing flash sectors to write
    commandBytes[0]=50;
    commandBytes[1]=20;
    commandBytes[2]=26;
    commandBytes[3]=96000;
    commandBytes[4]=0x0;
    IAP_call(commandBytes,outputBytes);    
    if(outputBytes[0]!=0x0){
        printf("Falha na escrita em flash parte 5 -> codigo [%lu].\r\n",outputBytes[0]);
        return 0;
    }
   
   if(nEndChunk<256){nEndChunk = 256;}
        else if(nEndChunk<512){nEndChunk = 512;}
            else if(nEndChunk<1024){nEndChunk = 1024;}
                else {nEndChunk = 4096;}                    
   
    for(i=0;i<nEndChunk;i++){
        memBuf[i] = fgetc(arquivo->fp);    
    }
    
    //Preenchendo o resto com 0xFF
    for(i=i;i<memBufTam;i++){
        memBuf[i] = 0xFF;
    }    
    
    
    
    commandBytes[0]=51;
    commandBytes[1]=((unsigned long) sector_start_adress[flashSectorFirmwareCopyOffset])+(nChunks*memBufTam);
    commandBytes[2]=(unsigned long)memBuf;
    commandBytes[3]=nEndChunk;
    commandBytes[4]=96000;
    IAP_call(commandBytes,outputBytes);
    if(outputBytes[0]!=0x0){
        printf("Falha na escrita em flash parte 6 -> codigo [%lu].\r\n",outputBytes[0]);
        return 0;
    }
    
    printf("Escrevendo tamanho de arquivo em firmDescToFlash = %lu.\r\n",tamFirmware);
    
    
    strcat((char*)&memBufConfigBootLoader[5],"executaBootLoader");
    executaBootLoader = 1;
    firmDescToFlash();
    
    sdCard::fechaArquivo(arquivo);
    printf("Escrita em swapfile concluido.\r\n");
    wait(0.2);
    return 0;
}

void firmDescToRam(){
    #define flashSectorFirmwareCopyOffset 20

    uint32_t i;    
    //Recuperando a struct firmwareDescriptor
    for(i=0;i<40;i++){
        memBufConfigBootLoader[i] = sector_start_adress[29][i];
    }
    
    tamFirmware  = memBufConfigBootLoader[0]<<24;
    tamFirmware += memBufConfigBootLoader[1]<<16;
    tamFirmware += memBufConfigBootLoader[2]<<8;
    tamFirmware += memBufConfigBootLoader[3]<<0;
    executaBootLoader = memBufConfigBootLoader[4];
    
    return;
}

/*
========================================================================================
========================================================================================
========================================================================================
========================================================================================
========================================================================================
========================================================================================
========================================================================================
========================================================================================
========================================================================================
========================================================================================
========================================================================================
========================================================================================
========================================================================================
========================================================================================
========================================================================================
========================================================================================
========================================================================================
========================================================================================
========================================================================================
========================================================================================
========================================================================================
========================================================================================
*/

/*void bootloader_fillBootLoader(void){
    #define flashSectorFirmwareCopyOffset 20    
    IAP IAP_call;
    IAP_call=(IAP) IAP_LOCATION;    
    firmwareDescriptor firmDesc;    
    unsigned int commandBytes[5];
    unsigned int outputBytes[5]; 
    char memBuf[memBufTam];
    uint32_t i;
    uint32_t chunkIndex=0;
    uint32_t nChunks,nEndChunk;
    uint32_t firmwareIndexBytes=0;    
    char *memRam = firmDesc.nome;
    
    //Recuperando a struct firmwareDescriptor
    for(i=0;i<sizeof(firmwareDescriptor);i++){
        memRam[i] = sector_start_adress[29][i];
    }
    
    
    printf("Iniciando processo de escrita em flash.\r\nDesligando interrupcoes.\r\n");
    NVIC_DeInit();
    printf("O firmware em area de swap file tem nome de [%s] e tamanho de %lu bytes.\r\n",firmDesc.nome,firmDesc.tam);
    for(i=0;i<memBufTam;i++){
        memBuf[i] = sector_start_adress[flashSectorFirmwareCopyOffset][firmwareIndexBytes+i];
    }
    //printf("Lendo conteudo da swapfile [%s].\r\n",memBuf);
    
    wait(1);
    
    
    
    //Preparing flash sectors to write
    commandBytes[0]=50;
    commandBytes[1]=0;
    commandBytes[2]=19;
    commandBytes[3]=96000;
    commandBytes[4]=0x0;
    IAP_call(commandBytes,outputBytes);    
    if(outputBytes[0]!=0x0){
        //printf("Falha na escrita em flash parte 1 -> codigo [%lu].\r\n",outputBytes[0]);
        //return;
    }
        
    
    //Erasing flash sectors
    commandBytes[0]=52;
    commandBytes[1]=0;
    commandBytes[2]=19;
    commandBytes[3]=96000;
    commandBytes[4]=0x0;
    IAP_call(commandBytes,outputBytes);    
    if(outputBytes[0]!=0x0){
        //printf("Falha na escrita em flash parte 2 -> codigo [%lu].\r\n",outputBytes[0]);
        //return;
    }    
    
    
    
    nChunks   = firmDesc.tam/memBufTam;
    nEndChunk = firmDesc.tam%memBufTam;
    
    //Flashing entire chunks
    for(chunkIndex=0;chunkIndex<nChunks;chunkIndex++){        
        //Load from file to ram
        for(i=0;i<memBufTam;i++){
            memBuf[i] = sector_start_adress[flashSectorFirmwareCopyOffset][firmwareIndexBytes+i];
        }
                
        //Copy from ram to flash
        //Preparing flash sectors to write
        commandBytes[0]=50;
        commandBytes[1]=0;
        commandBytes[2]=19;
        commandBytes[3]=96000;
        commandBytes[4]=0x0;
        IAP_call(commandBytes,outputBytes);    
        if(outputBytes[0]!=0x0){
            //printf("Falha na escrita em flash parte 3 -> codigo [%lu].\r\n",outputBytes[0]);
            //return;
        }
        
        //Flashing this part
        commandBytes[0]=51;
        commandBytes[1]=firmwareIndexBytes;
        commandBytes[2]=(unsigned long)memBuf;
        commandBytes[3]=memBufTam;
        commandBytes[4]=96000;
        IAP_call(commandBytes,outputBytes);
        if(outputBytes[0]!=0x0){
            //printf("Falha na escrita em flash parte 4 -> codigo [%lu].\r\n",outputBytes[0]);
            //return;
        }
        firmwareIndexBytes+=memBufTam;
    }
    
    
    //Flashing the last part     
    //Preparing flash sectors to write
    commandBytes[0]=50;
    commandBytes[1]=0;
    commandBytes[2]=19;
    commandBytes[3]=96000;
    commandBytes[4]=0x0;
    IAP_call(commandBytes,outputBytes);    
    if(outputBytes[0]!=0x0){
        //printf("Falha na escrita em flash parte 5 -> codigo [%lu].\r\n",outputBytes[0]);
        //return;
    }
   
    for(i=0;i<nEndChunk;i++){
        memBuf[i] = sector_start_adress[flashSectorFirmwareCopyOffset][firmwareIndexBytes+i];
    }    
    
    if(nEndChunk<256){nEndChunk = 256;}
        else if(nEndChunk<512){nEndChunk = 512;}
            else if(nEndChunk<1024){nEndChunk = 1024;}
                else if(nEndChunk<4096){nEndChunk = 4096;}
                
    //Preenchendo o resto com 0xFF
    for(i=i;i<memBufTam;i++){
        memBuf[i] = 0xFF;
    }                    
    
    commandBytes[0]=51;
    commandBytes[1]=firmwareIndexBytes;
    commandBytes[2]=(unsigned long)memBuf;
    commandBytes[3]=nEndChunk;
    commandBytes[4]=96000;
    IAP_call(commandBytes,outputBytes);
    if(outputBytes[0]!=0x0){
        //printf("Falha na escrita em flash parte 6 -> codigo [%lu].\r\n",outputBytes[0]);
        //return;
    }
    //printf("Dando boot.\r\n");    
    NVIC_SystemReset();
    
    //Nunca alcançará este ponto.
    return;
}*/