#include "IRPack.h"
//bool dataIn[maxBytesMsg*8];
uint16_t bits[maxBitsMsg*4][2];        
int indexIr=0,botao;
int startBitAlto=0, startBitBaixo=0, bitBaixo[maxBitsMsg], bitAlto[maxBitsMsg], i;
//unsigned char byte=0,msg[maxBytesMsg],msgBytes=0;

Timer IrTmr;
Timer IrDetect;
bool irInAntes=1;
CircularBuffer bufIROut(maxBitsMsg*2*4,0);

//PwmOut IrOut(P1_18);
DigitalIn IrIn(P1_24); //Não utilizado na placa

int round(float in){
    int x = floor(in);
    float y = in-x;
    if(y>=0.5){
        x++;    
    }    
    return x;
}

uint16_t pulseDuration_us(bool high,DigitalIn pin,unsigned long int timeout){
 unsigned long int durationBefore, duration; 
 durationBefore = us_ticker_read();
 do{   
   wait_us(1);
   timeout--;
 }while(timeout && (pin==high));
 duration = us_ticker_read() - durationBefore;
 
 //IrTmr.stop();
 if(timeout){
     return duration;
 }
 else{
     return 65535;
 }
}



void enviaComandoIR(uint8_t freq,uint8_t port){    
    float sd1Duty = SD1.read();
    float sd2Duty = SD2.read();
    float sd3Duty = SD3.read();
    float sd4Duty = SD4.read();
    float sd5Duty = SD5.read();
    float sd6Duty = SD6.read();
    
    float frequencia = freq*1000.0;
    float periodo = 1000000.0/frequencia;        
    PwmOut *SD;    
    
    SD1.write(0.0f);
    SD2.write(0.0f);
    SD3.write(0.0f);
    SD4.write(0.0f);
    SD5.write(0.0f);
    SD6.write(0.0f);    
    
    switch(port){
        case 0:
                SD = &SD1;
            break;    
        case 1:
                SD = &SD2;
            break;    
        case 2:
                SD = &SD3;
            break;    
        case 3:
                SD = &SD4;
            break;    
        case 4:
                SD = &SD5;
            break;    
        case 5:
                SD = &SD6;
            break;    
    }
    
    //pc.printf("Enviando o pacote IR na porta %lu com periodo %f e frequencia %f.\r\n",port,periodo,frequencia);
    
    //SD->period(1.0/(freq*1000.0));    
    SD->period_us(periodo);    
    
    //pc.printf("Iniciando o envio IR.\r\n");    
    for(i=0;i<indexIr;i++){
        SD->write(0.5);        
        wait_us(bits[i][0]);

        SD->write(0.0);
        wait_us(bits[i][1]);
    }
    //pc.printf("Finalizado o envio IR.\r\n");
    
    SD1.period_us(pwmPeriod);
    SD1.write(sd1Duty);
    SD2.write(sd2Duty);
    SD3.write(sd3Duty);
    SD4.write(sd4Duty);
    SD5.write(sd5Duty);
    SD6.write(sd6Duty);    
}


/*static const long hextable[] = {
   [0 ... 255] = -1, // bit aligned access into this table is considerably
   ['0'] = 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, // faster for most modern processors,
   ['A'] = 10, 11, 12, 13, 14, 15,       // for the space conscious, reduce to
   ['a'] = 10, 11, 12, 13, 14, 15        // signed char.
};*/

uint8_t hextable(char c){
 uint8_t ret=0;
 if(c>='a'){
    ret = c-87;
 }else if(c>='A'){
            ret = c-55;   
       }else{
         ret = c-48;
        }
 return ret;
}
 
uint16_t hexdec(char *hex,uint16_t tam) {
   uint16_t ret = 0; 
   //uint8_t auxHex=0;
   uint16_t i;   
   for(i=0;i<tam;i++){
    //ret += hextable[hex[i]] << (i*4);
    ret += hextable(hex[i]) << (i*4);
    //pc.printf("%c",hex[i]);    
   }
   //pc.printf("\r\n");
   return ret; 
}


void deserializaPacoteIR(char *strIr){
    uint16_t len;    
    uint16_t i;    
    
    len = strlen(strIr);  
    len = len/4; //Separando de quatro em quatro pra formar um uint16_t
    
    for(i=0;i<len;i++){        
        bits[i/2][(i%2)]=hexdec(strIr,4);        
        strIr = strIr+4;
    }    
    indexIr = len/2;    
}

void serializaPacoteIR(uint8_t connectionID){
    char aux[50];    
    uint32_t length;    
    char *ptr;
    uint16_t i;
    union{
       char c[2];
       uint16_t v; 
    }u;
    sdCardBuf.del();        
    for(i=0;i<indexIr;i++){
        u.v = bits[i][0];        
        sprintf(aux,"%01X%01X%01X%01X"
        ,u.c[0]&0xF
        ,u.c[0]>>4
        ,u.c[1]&0xF
        ,u.c[1]>>4        
        );        
        sdCardBuf.fill(aux,strlen(aux));
        
        u.v = bits[i][1];
        sprintf(aux,"%01X%01X%01X%01X"
        ,u.c[0]&0xF
        ,u.c[0]>>4
        ,u.c[1]&0xF
        ,u.c[1]>>4        
        );        
        sdCardBuf.fill(aux,strlen(aux));
    }
    length = sdCardBuf.getLength();
    ptr = sdCardBuf.get();
    modemCom::cipSend(connectionID,ptr,length);
    //pc.printf("Conteudo de sdCardBuf <%s>.\r\n",ptr);    
}

bool detectaIRIn(){
        bool detectado=0;
        if((irInAntes!=IrIn) && (!IrIn)){            
            indexIr = 0;
            do{
                bits[indexIr][0] = pulseDuration_us(0,IrIn,65000);
                bits[indexIr][1] = pulseDuration_us(1,IrIn,65000);
                indexIr++;
            }while((bits[indexIr-1][0]!=65535)&&(bits[indexIr-1][1]!=65535));
            detectado=1;
        }
        irInAntes = IrIn;
        pc.printf("Total de indexIr = %lu bits.\r\n",indexIr);
        return detectado;
}

void pesquisaIRIn(){
        if((irInAntes!=IrIn) && (!IrIn)){                       
            indexIr = 0;
            do{
                bitAlto[indexIr]  = pulseDuration_us(0,IrIn,65000);
                bitBaixo[indexIr] = pulseDuration_us(1,IrIn,65000);
                //dataIn[indexIr] = (bitBaixo[indexIr] > 1000);
                indexIr++;                
            }while((bitAlto[indexIr-1]!=65535)&&(bitBaixo[indexIr-1]!=65535));
            
            pc.printf("Capturado um quadro com %lu bits. sbH %ld, sbL %ld <",indexIr,startBitAlto, startBitBaixo);
            for(i=0;i<(indexIr);i++){
                pc.printf("[H%ld L%ld] ",bitAlto[i],bitBaixo[i]);
            }
            pc.printf(">.\n\n");
        }
        irInAntes = IrIn;        
}

/*

float razaoBit(int iH, int iL){
    float H=(float)iH,L=(float)iL;
    float razao = L/H;
    
    if(razao>=1){
        return (float) round(razao);
    }else if(razao>=0.5){
        return 0.5;
    }else if(razao>=0.25){
        return 0.25;
    }else if(razao>=0.125){
        return 0.125;
    }else{
        return -1;
    }

}

void descritorPacoteIR(int startBitAlto, int startBitBaixo, int *bitAlto, int *bitBaixo, int numBits){      
        unsigned int razao_maiorQue4=0;
        unsigned int razao_4=0;
        unsigned int razao_3=0;
        unsigned int razao_2=0;
        unsigned int razao_1=0;
        unsigned int razao_0_5=0;
        unsigned int razao_0_25=0;
        unsigned int razao_0_125=0;
        unsigned int razao_menorQue_0_125=0;
        
        //Indice 0 ALto, 1 Baixo;
        unsigned long int bitRazao_maiorQue4[2]= {0,0};
        unsigned long int bitRazao_4[2]= {0,0};
        unsigned long int bitRazao_3[2]= {0,0};
        unsigned long int bitRazao_2[2]= {0,0};
        unsigned long int bitRazao_1[2]= {0,0};
        unsigned long int bitRazao_0_5[2]= {0,0};
        unsigned long int bitRazao_0_25[2]= {0,0};
        unsigned long int bitRazao_0_125[2]= {0,0};
        unsigned long int bitRazao_menorQue_0_125[2]= {0,0};
        
        unsigned long int indiceMaiorNEventos[2] = {0,0};
        unsigned long int indiceSegundoMaiorNEventos[2] = {0,0};
        
        
        
        unsigned int bitAlto_H=0;
        unsigned int bitAlto_L=0;
        unsigned int bitBaixo_H=0;
        unsigned int bitBaixo_L=0;      
        
        unsigned int stopBitAlto = bitAlto[numBits-1];
        
        int i;
        
        //printf("startBitAlto %d, startBitBaixo %d, stopBitAlto %d, stopBitBaixo %d numBits %d\n",startBitAlto,startBitBaixo,bitAlto[numBits-1],bitBaixo[numBits-1],numBits);
        
        //Despresando o stopBit pois esse já sabemos como faz
        for(i=0;i<numBits-1;i++){
            //printf("Razao entre [L %05d e H %05d]=%1.2f\n",bitBaixo[i],bitAlto[i],razaoBit(bitAlto[i],bitBaixo[i]));    
            //Detecção de padroes
            if(razaoBit(bitAlto[i],bitBaixo[i])>=4){
                razao_maiorQue4++;
                bitRazao_maiorQue4[0]+= bitAlto[i];
                bitRazao_maiorQue4[1]+=bitBaixo[i];
                
            }else if(razaoBit(bitAlto[i],bitBaixo[i])==4){
                razao_4++;
                bitRazao_4[0]+= bitAlto[i];
                bitRazao_4[1]+=bitBaixo[i];
            }else if(razaoBit(bitAlto[i],bitBaixo[i])==3){
                razao_3++;
                bitRazao_3[0]+= bitAlto[i];
                bitRazao_3[1]+=bitBaixo[i];
            }else if(razaoBit(bitAlto[i],bitBaixo[i])==2){
                razao_2++;
                bitRazao_2[0]+= bitAlto[i];
                bitRazao_2[1]+=bitBaixo[i];
            }else if(razaoBit(bitAlto[i],bitBaixo[i])==1){
                razao_1++;
                bitRazao_1[0]+= bitAlto[i];
                bitRazao_1[1]+=bitBaixo[i];
            }else if(razaoBit(bitAlto[i],bitBaixo[i])==0.5){
                razao_0_5++;
                bitRazao_0_5[0]+= bitAlto[i];
                bitRazao_0_5[1]+=bitBaixo[i];
            }else if(razaoBit(bitAlto[i],bitBaixo[i])==0.25){
                razao_0_25++;
                bitRazao_0_25[0]+= bitAlto[i];
                bitRazao_0_25[1]+=bitBaixo[i];
            }else if(razaoBit(bitAlto[i],bitBaixo[i])==0.125){
                razao_0_125++;
                bitRazao_0_125[0]+= bitAlto[i];
                bitRazao_0_125[1]+=bitBaixo[i];
            }else {
                razao_menorQue_0_125++;
                bitRazao_menorQue_0_125[0]+= bitAlto[i];
                bitRazao_menorQue_0_125[1]+=bitBaixo[i];
            }
            
        }
        printf("Razoes <0.125 = %d\n 0.125 = %d\n 0.25 = %d\n 0.5 = %d\n 1 = %d\n 2 = %d\n 3 = %d\n 4 = %d\n maior que 4 = %d\n"
        ,razao_menorQue_0_125
        ,razao_0_125
        ,razao_0_25
        ,razao_0_5
        ,razao_1
        ,razao_2
        ,razao_3
        ,razao_4
        ,razao_maiorQue4        
        );
        
        //Buscando os dois maiores em numero de eventos por Indice;
        //Buscando o primeiro
        for(i=0;i<9;i++){
            //Buscando nos indices maior numero eventos
            switch(i){
                case 0:
                        if(razao_maiorQue4>indiceMaiorNEventos[0]){
                            indiceMaiorNEventos[0] = razao_maiorQue4;
                            indiceMaiorNEventos[1] = i;
                        }
                    break;
                        
                case 1:
                        if(razao_4>indiceMaiorNEventos[0]){
                            indiceMaiorNEventos[0] = razao_4;
                            indiceMaiorNEventos[1] = i;
                        }
                    break;
                case 2:
                        if(razao_3>indiceMaiorNEventos[0]){
                            indiceMaiorNEventos[0] = razao_3;
                            indiceMaiorNEventos[1] = i;
                        }
                    break;
                case 3:
                        if(razao_2>indiceMaiorNEventos[0]){
                            indiceMaiorNEventos[0] = razao_2;
                            indiceMaiorNEventos[1] = i;
                        }
                    break;
                case 4:
                        if(razao_1>indiceMaiorNEventos[0]){
                            indiceMaiorNEventos[0] = razao_1;
                            indiceMaiorNEventos[1] = i;
                        }
                    break;
                case 5:
                        if(razao_0_5>indiceMaiorNEventos[0]){
                            indiceMaiorNEventos[0] = razao_0_5;
                            indiceMaiorNEventos[1] = i;
                        }
                    break;
                case 6:
                        if(razao_0_25>indiceMaiorNEventos[0]){
                            indiceMaiorNEventos[0] = razao_0_25;
                            indiceMaiorNEventos[1] = i;
                        }
                    break;
                case 7:
                        if(razao_0_125>indiceMaiorNEventos[0]){
                            indiceMaiorNEventos[0] = razao_0_125;
                            indiceMaiorNEventos[1] = i;
                        }
                    break;
                case 8:
                        if(razao_menorQue_0_125>indiceMaiorNEventos[0]){
                            indiceMaiorNEventos[0] = razao_menorQue_0_125;
                            indiceMaiorNEventos[1] = i;
                        }
                    break;
                    
            }
        }
        
        //Buscando o segundo
        //Buscando o primeiro
        for(i=0;i<9;i++){
            //Buscando nos indices maior numero eventos
            if(i!=indiceMaiorNEventos[1]){
                switch(i){
                    case 0:
                            if(razao_maiorQue4>indiceSegundoMaiorNEventos[0]){
                                indiceSegundoMaiorNEventos[0] = razao_maiorQue4;
                                indiceSegundoMaiorNEventos[1] = i;
                            }
                        break;
                            
                    case 1:
                            if(razao_4>indiceSegundoMaiorNEventos[0]){
                                indiceSegundoMaiorNEventos[0] = razao_4;
                                indiceSegundoMaiorNEventos[1] = i;
                            }
                        break;
                    case 2:
                            if(razao_3>indiceSegundoMaiorNEventos[0]){
                                indiceSegundoMaiorNEventos[0] = razao_3;
                                indiceSegundoMaiorNEventos[1] = i;
                            }
                        break;
                    case 3:
                            if(razao_2>indiceSegundoMaiorNEventos[0]){
                                indiceSegundoMaiorNEventos[0] = razao_2;
                                indiceSegundoMaiorNEventos[1] = i;
                            }
                        break;
                    case 4:
                            if(razao_1>indiceSegundoMaiorNEventos[0]){
                                indiceSegundoMaiorNEventos[0] = razao_1;
                                indiceSegundoMaiorNEventos[1] = i;
                            }
                        break;
                    case 5:
                            if(razao_0_5>indiceSegundoMaiorNEventos[0]){
                                indiceSegundoMaiorNEventos[0] = razao_0_5;
                                indiceSegundoMaiorNEventos[1] = i;
                            }
                        break;
                    case 6:
                            if(razao_0_25>indiceSegundoMaiorNEventos[0]){
                                indiceSegundoMaiorNEventos[0] = razao_0_25;
                                indiceSegundoMaiorNEventos[1] = i;
                            }
                        break;
                    case 7:
                            if(razao_0_125>indiceSegundoMaiorNEventos[0]){
                                indiceSegundoMaiorNEventos[0] = razao_0_125;
                                indiceSegundoMaiorNEventos[1] = i;
                            }
                        break;
                    case 8:
                            if(razao_menorQue_0_125>indiceSegundoMaiorNEventos[0]){
                                indiceSegundoMaiorNEventos[0] = razao_menorQue_0_125;
                                indiceSegundoMaiorNEventos[1] = i;
                            }
                        break;
                        
                }
            }
        }
        
        
        //printf("Indice de maior aparecimento foi o de %d.\nIndice de segundo maior aparecimento foi o de %d.\n",indiceMaiorNEventos[1],indiceSegundoMaiorNEventos[1]);
        
        //Calculando bitAlto
        switch(indiceMaiorNEventos[1]){
            case 0:
                    bitAlto_H = round(bitRazao_maiorQue4[0]/indiceMaiorNEventos[0]);
                    bitAlto_L = round(bitRazao_maiorQue4[1]/indiceMaiorNEventos[0]);
                break;
            case 1:
                    bitAlto_H = round(bitRazao_4[0]/indiceMaiorNEventos[0]);
                    bitAlto_L = round(bitRazao_4[1]/indiceMaiorNEventos[0]);
                break;
            case 2:
                    bitAlto_H = round(bitRazao_3[0]/indiceMaiorNEventos[0]);
                    bitAlto_L = round(bitRazao_3[1]/indiceMaiorNEventos[0]);
                break;
            case 3:
                    bitAlto_H = round(bitRazao_2[0]/indiceMaiorNEventos[0]);
                    bitAlto_L = round(bitRazao_2[1]/indiceMaiorNEventos[0]);
                break;
            case 4:
                    bitAlto_H = round(bitRazao_1[0]/indiceMaiorNEventos[0]);
                    bitAlto_L = round(bitRazao_1[1]/indiceMaiorNEventos[0]);
                break;
            case 5:
                    bitAlto_H = round(bitRazao_0_5[0]/indiceMaiorNEventos[0]);
                    bitAlto_L = round(bitRazao_0_5[1]/indiceMaiorNEventos[0]);
                break;
            case 6:
                    bitAlto_H = round(bitRazao_0_25[0]/indiceMaiorNEventos[0]);
                    bitAlto_L = round(bitRazao_0_25[1]/indiceMaiorNEventos[0]);
                break;
            case 7:
                    bitAlto_H = round(bitRazao_0_125[0]/indiceMaiorNEventos[0]);
                    bitAlto_L = round(bitRazao_0_125[1]/indiceMaiorNEventos[0]);
                break;
            case 8:
                    bitAlto_H = round(bitRazao_menorQue_0_125[0]/indiceMaiorNEventos[0]);
                    bitAlto_L = round(bitRazao_menorQue_0_125[1]/indiceMaiorNEventos[0]);
                break;          
        }
        
        //Calculando bitBaixo
        switch(indiceSegundoMaiorNEventos[1]){
            case 0:
                    bitBaixo_H = round(bitRazao_maiorQue4[0]/indiceSegundoMaiorNEventos[0]);
                    bitBaixo_L = round(bitRazao_maiorQue4[1]/indiceSegundoMaiorNEventos[0]);
                break;
            case 1:
                    bitBaixo_H = round(bitRazao_4[0]/indiceSegundoMaiorNEventos[0]);
                    bitBaixo_L = round(bitRazao_4[1]/indiceSegundoMaiorNEventos[0]);
                break;
            case 2:
                    bitBaixo_H = round(bitRazao_3[0]/indiceSegundoMaiorNEventos[0]);
                    bitBaixo_L = round(bitRazao_3[1]/indiceSegundoMaiorNEventos[0]);
                break;
            case 3:
                    bitBaixo_H = round(bitRazao_2[0]/indiceSegundoMaiorNEventos[0]);
                    bitBaixo_L = round(bitRazao_2[1]/indiceSegundoMaiorNEventos[0]);
                break;
            case 4:
                    bitBaixo_H = round(bitRazao_1[0]/indiceSegundoMaiorNEventos[0]);
                    bitBaixo_L = round(bitRazao_1[1]/indiceSegundoMaiorNEventos[0]);
                break;
            case 5:
                    bitBaixo_H = round(bitRazao_0_5[0]/indiceSegundoMaiorNEventos[0]);
                    bitBaixo_L = round(bitRazao_0_5[1]/indiceSegundoMaiorNEventos[0]);
                break;
            case 6:
                    bitBaixo_H = round(bitRazao_0_25[0]/indiceSegundoMaiorNEventos[0]);
                    bitBaixo_L = round(bitRazao_0_25[1]/indiceSegundoMaiorNEventos[0]);
                break;
            case 7:
                    bitBaixo_H = round(bitRazao_0_125[0]/indiceSegundoMaiorNEventos[0]);
                    bitBaixo_L = round(bitRazao_0_125[1]/indiceSegundoMaiorNEventos[0]);
                break;
            case 8:
                    bitBaixo_H = round(bitRazao_menorQue_0_125[0]/indiceSegundoMaiorNEventos[0]);
                    bitBaixo_L = round(bitRazao_menorQue_0_125[1]/indiceSegundoMaiorNEventos[0]);
                break;          
        }
        
        printf("\n\nFinalmente.\n");
        printf("startBitAlto = %ld, startBitBaixo = %ld\n", startBitAlto,startBitBaixo);
        printf("bitAlto_H = %ld bitAlto_l = %ld\n",bitAlto_H,bitAlto_L);
        printf("bitBaixo_H = %ld bitBaixo_l = %ld\n",bitBaixo_H,bitBaixo_L);
        printf("stopBitAlto = %ld\n",stopBitAlto);
        
        return;
}*/
