#include "DS18B20_SensorTemperatura.h"

DS1820* probe[MAX_PROBES];
int num_temperatureSensors = 0;
float temperaturas[MAX_PROBES];

void inicializaSensoresTemperatura(){
    // Initialize the probe array to DS1820 objects    
    while(DS1820::unassignedProbe(DATA_PIN)) {
        probe[num_temperatureSensors] = new DS1820(DATA_PIN);
        num_temperatureSensors++;
        if (num_temperatureSensors == MAX_PROBES)
            break;
    }
    printf("Found %d device(s)\r\n\n", num_temperatureSensors);
    refreshSensoresTemperatura();   
}

void refreshSensoresTemperatura(){
    float aux;
    if(num_temperatureSensors){
        probe[0]->convertTemperature(true, DS1820::all_devices);         //Start temperature conversion, wait until ready
        for (int i = 0; i<num_temperatureSensors; i++){
            if((aux = probe[i]->temperature()) != -1000.0){
                temperaturas[i] = aux;    
            }
            if(debug){printf("Device %d returns %3.1foC\r\n", i, temperaturas[i]);}
        }
    }
}
 