#include <mbed.h>
#include "hsc_spi.h"

hsc_spi::hsc_spi(SPI& _spi, PinName _ncs) : spi(_spi), ncs(_ncs) {}

void hsc_spi::spi_init(){
    spi.format(16,0);
    }

float hsc_spi::read_temp() {
    unsigned int response;
    float temperature;
    select();
        response=spi.write(0x0000);
        response=spi.write(0x0000);
        response=response/32;
        temperature=response*200.0/2047.0 - 50.0;
    deselect();
    return temperature;
}

float hsc_spi::read_press() {
    unsigned int response;
    float pressure;
    select();
        response=spi.write(0x0000);
        pressure=1.0*(response - OUTPUT_MIN)*(P_MAX - P_MIN)/(OUTPUT_MAX - OUTPUT_MIN) + P_MIN;
    deselect();
    return pressure;
}

void hsc_spi::select() {
    spi_init();
    //Set CS low to start transmission (interrupts conversion)
    ncs = 0;
}

void hsc_spi::deselect() {
    //Set CS high to stop transmission (restarts conversion)
    ncs = 1;
}