#ifndef hsc_spi_h
#define hsc_spi_h

#include "mbed.h"

#define OUTPUT_MAX 0x399A
#define OUTPUT_MIN 0x0666
#define P_MAX 1600
#define P_MIN 0

class hsc_spi
{
    SPI& spi;
    DigitalOut ncs;
    Timer pollTimer;
  public:
  
    hsc_spi(SPI& _spi, PinName _ncs);
    //void initialise(int out_max,int out_min,int pmax, int pmin);
    float read_press();
    float read_temp();
    void spi_init();
    void select();
    void deselect();
    
  private:
    PinName _CS_pin;
    PinName _SO_pin;
    PinName _SCK_pin;
    float _error;
};

#endif
