#include "mbed.h"

#define MIN_BATTERY_ADC_VALUE (int16_t)3071    //(min_voltage_on_analog_pin *4551) 2.48*4551 = 11295
#define MAX_BATTERY_ADC_VALUE (int16_t)4095    //(max_voltage_on_analog_pin *4551) 3.38*4551 = 15391

//AnalogIn analog_value(P0_2);
//DigitalOut led(P1_13);

void config_adc(void){
    
    //Configure SAADC singled-ended channel, Internal reference (0.6V) and 1/5 gain.
    NRF_SAADC->CH[0].CONFIG = (SAADC_CH_CONFIG_GAIN_Gain1_5    << SAADC_CH_CONFIG_GAIN_Pos) |
            (SAADC_CH_CONFIG_MODE_SE         << SAADC_CH_CONFIG_MODE_Pos) |
            (SAADC_CH_CONFIG_REFSEL_Internal << SAADC_CH_CONFIG_REFSEL_Pos) |
            (SAADC_CH_CONFIG_RESN_Bypass     << SAADC_CH_CONFIG_RESN_Pos) |
            (SAADC_CH_CONFIG_RESP_Bypass     << SAADC_CH_CONFIG_RESP_Pos) |
            (SAADC_CH_CONFIG_TACQ_10us        << SAADC_CH_CONFIG_TACQ_Pos);
            
    
    // Configure the SAADC channel with VDD as a positive input, no negative input(single ended).
    NRF_SAADC->CH[0].PSELP = SAADC_CH_PSELN_PSELN_AnalogInput0 << SAADC_CH_PSELN_PSELN_Pos ;//changed pin number to AIN7
    NRF_SAADC->CH[0].PSELN = SAADC_CH_PSELN_PSELN_NC << SAADC_CH_PSELN_PSELN_Pos;
    
    //Configure the SAADC resolution.
    NRF_SAADC->RESOLUTION = SAADC_RESOLUTION_VAL_12bit << SAADC_RESOLUTION_VAL_Pos;
    
    // No automatic sampling, will trigger with TASKS_SAMPLE.
    NRF_SAADC->SAMPLERATE = SAADC_SAMPLERATE_MODE_Task << SAADC_SAMPLERATE_MODE_Pos;
    
    //Enable SAADC (would capture analog pins if they were used in CH[0].PSELP)
    NRF_SAADC->ENABLE = SAADC_ENABLE_ENABLE_Enabled << SAADC_ENABLE_ENABLE_Pos;
}

float battery_status(void){

    int16_t result = 0;
    float precise_result = 0;

    // Configure result to be put in RAM at the location of "result" variable.
    NRF_SAADC->RESULT.MAXCNT = 1;
    NRF_SAADC->RESULT.PTR = (uint32_t)&result;

    // Calibrate the SAADC (only needs to be done once in a while)
    NRF_SAADC->TASKS_CALIBRATEOFFSET = 1;
    while (NRF_SAADC->EVENTS_CALIBRATEDONE == 0);
    NRF_SAADC->EVENTS_CALIBRATEDONE = 0;
    
    // Start the SAADC and wait for the started event.
    NRF_SAADC->TASKS_START = 1;
    while (NRF_SAADC->EVENTS_STARTED == 0);
    NRF_SAADC->EVENTS_STARTED = 0;
    
    // Do a SAADC sample, will put the result in the configured RAM buffer.
    NRF_SAADC->TASKS_SAMPLE = 1;
    while (NRF_SAADC->EVENTS_END == 0);
    NRF_SAADC->EVENTS_END = 0;
    
    precise_result = (float)(result/4551);
    
    // Stop the SAADC, since it's not used anymore.
    NRF_SAADC->TASKS_STOP = 1;
    while (NRF_SAADC->EVENTS_STOPPED == 0);
    NRF_SAADC->EVENTS_STOPPED = 0;
    NVIC_ClearPendingIRQ(SAADC_IRQn);
    return precise_result;
} 


int main()
{

    config_adc();
    float result_1;
    
    printf("\nAnalogIn example\n");
    
    while(1) {

//        meas_r = analog_value.read(); // Read the analog input value (value from 0.0 to 1.0 = full ADC conversion range)
//        meas_v = meas_r * 3300; // Converts value in the 0V-3.3V range
        
        // Display values
//        printf("measure = %f = %.0f mV\n", meas_r, meas_v);

        // LED is ON is the value is below 1V
//        if (meas_v < 1000) {
//            led = 1; // LED ON
//        } else {
//            led = 0; // LED OFF
//        }
//        printf("debug before bat_status routine");
        result_1=battery_status();
        printf("bat_lev: \n%f\n", result_1);
        wait(1.0); // 1 second
    }
}
