#include "mbed.h"
 
//#define ADDR    (0x6D<<1)
 
Serial pc(p25, p8); // tx, rx
DigitalOut ADR(P0_12);
 
I2C i2c(p13, p15);


char buffer[2];
uint16_t aux;
 
int main()
{
    ADR=1;
    char sco_bit;
    i2c.frequency(100000);
    
    const int addr = 0x6d << 1;
    char readdata[3];
    
    while(1)
    {
        int ret, value, value1, value2;
        sco_bit = 1;
        pc.printf("Lendo valor em registrador 0xA5…\r\n");
        
        buffer[0] = 0xA5;
        
        //ret = i2c.write((addr << 1) & 0xFE);
        ret = i2c.write(addr, buffer, 1);
        
        if (!ret) // 0:ACK 1:NACK
        {
            ret = i2c.read(addr, readdata, 3);

            if (ret)
                pc.printf("Erro B %d.\r\n", ret);
        }
        else
            pc.printf("Erro A %d.\r\n", ret);

        if (!ret)
        {
            buffer[0] = 0xA5;
            buffer[1] = readdata[0] & 0x07;
            buffer[2] = readdata[1] & 0x0f;
            buffer[3] = readdata[2] & 0x0d;
            ret = i2c.write(addr, buffer, 4);

            if (ret == 0) // 0:ACK 1:NACK
            {
                buffer[0] = 0x30;
                buffer[1] = 0x0A;
                i2c.write(addr, buffer, 2);
                i2c.read(addr, sco_bit, 1);
                
                if (!sco_bit)
                {
                    buffer[0] = 0x06;
                    i2c.write(addr, buffer, 1);
                    i2c.read(addr, readdata[0], 3);
                    buffer[0] = 0x07;
                    i2c.write(addr, buffer, 1);
                    i2c.read(addr, readdata[1], 3);                 
                    buffer[0] = 0x08;
                    i2c.write(addr, buffer, 1);
                    i2c.read(addr, readdata[2], 3);
                    
                    pc.printf("Valor lido: %d\n", readdata);
                }
            }
            else
                pc.printf("Erro C %d.\r\n", ret);
        }
    }
}