#include "mbed.h"
#include "USBKeyboard.h"
 
//LED1: NUM_LOCK, LED2: CAPS_LOCK, LED3: SCROLL_LOCK
BusOut leds(LED1, LED2, LED3);
DigitalIn button_SW2(PTC1);               // Configure SW2 pin as input
DigitalIn button_SW3(PTB17);               // Configure SW3 pin as input
#define SW2_printf 'S'                   // set SW2 button input key
#define SW3_printf 'D'                  // set SW2 button input key
USBKeyboard keyboard;
 
int main() {
    int buttonPressedCount_SW2 = 0;
    int buttonPressedCount_SW3 = 0;
    
    while (!keyboard.configured()) {    // wait until keyboard is configured
    }
    
    while (1) {
        leds = keyboard.lockStatus();
        
        if (button_SW2.read()) {
            buttonPressedCount_SW2++;
            if (2 == buttonPressedCount_SW2) {       // when button is pressed about 0.02s
                    keyboard._putc(SW2_printf);      // send  SW2 key
            }   
        } else {
            buttonPressedCount_SW2 = 0;
        }
        
        if (button_SW3.read()) {
            buttonPressedCount_SW3++;
            if (2 == buttonPressedCount_SW3) {       // when button is pressed about 0.02s
                    keyboard._putc(SW3_printf);      // send  SW3 key
            }
        } else {
            buttonPressedCount_SW3 = 0;
        }
        wait(0.01);
    }
}