//Include mbed header file which contains the definition of DigitalOut class. 
#include "mbed.h"
//Include TextLCD header file which contains the definition of TextLCD class. 
#include "TextLCD.h"

//Initialize DigitalOut array with for LEDs
DigitalOut array[4] = {LED1,LED2,LED3,LED4};
//Initialize TextLCD with the correct pins
TextLCD lcd(p24, p26, p27, p28, p29, p30);

//Main function
int main() 
{
    //Clear the LCD display
    lcd.cls();
    //Locate Row 0 Column in the LCD display
    lcd.locate(0, 0);
    //Print my name
    lcd.printf("DANIEL BROMAND");
    //Locate Row 1 column 0 in the LCD display
    lcd.locate(0, 1);
    //Print Knight Rider
    lcd.printf("Knight Rider");
    //First for loop to insure initialization of all LEDs to 1    
    for(int i=0;i<4;i++)
    {
        array[i] = 1;
    }
    //Loop forever
    while(true) 
    {
        //Iterate through all LEDs 
        //For each LED set the opposite of what it currently has. 
        for(int i=0;i<4;i++)
        {
            array[i] = !array[i];
            //wait for 400ms. 
            wait(0.4);
        }//End of for loop        
    }//End of while loop
}//End of Main function
