//Include mbed header file which contains the definition of DigitalOut class. 
#include "mbed.h"
//Include TextLCD header file which contains the definition of TextLCD class. 
#include "TextLCD.h"

//Initialize PwmOut memebers
PwmOut led1(LED1);
PwmOut led4(LED4);
//Initialize TextLCD with the correct pins
TextLCD lcd(p24, p26, p27, p28, p29, p30);

//This function will handle the print to LCD
void PrintToLCD()
{
    //Clear the LCD display
    lcd.cls();
    //Locate Row 0 Column 0 in the LCD display
    lcd.locate(0, 0);
    //Print my name
    lcd.printf("DANIEL BROMAND");
    //Locate Row 1 Column 0 in the LCD display
    lcd.locate(0, 1);
    //Print my name
    lcd.printf("PwmOut Command");
}

//Main function
int main() 
{
    //Call PrintToLCD Command
    PrintToLCD();
    //Loop forever
    while(true) 
    {
        //Loop from 0.0 to 1.0 and in each step increment by 0.1.
        for(float f=0.0f ; f<=1.0f ; f+=0.1f)
        {
            //Set led1 to f
            led1 = f;
            //Set led 4 to 1-f.
            led4 = 1.0f-f;
            wait(0.1);
        }//End of for loop
        for(float f=0.0f ; f<=1.0f ; f+=0.1f)
        {
            //Set led4 to f
            led4 = f;
            //Set led1 to 1-f
            led1 = 1.0f-f;
            wait(0.1);
        }//End of for loop
    }//End of while loop
}//End of Main function
