#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "HTTPRequestHandler.h"
#include "dbg/dbg.h"
#include <string>

EthernetNetIf eth;  
HTTPServer svr;

DigitalOut led1(LED1);

struct system
{
    bool bOverrideSystem;
    bool bIsDoorClosed;    
} system1;

struct cat 
{
    int id;
    string name;
} cat1;


class CatDoorHandler : public HTTPRequestHandler
{
public:
CatDoorHandler(const char* rootPath, const char* path, TCPSocket* pTCPSocket): HTTPRequestHandler(rootPath, path, pTCPSocket){};
virtual ~CatDoorHandler(){ DBG("\r\nCatDoorHandler destroyed\r\n");};
static inline HTTPRequestHandler* inst(const char* rootPath, const char* path, TCPSocket* pTCPSocket) { return new CatDoorHandler(rootPath, path, pTCPSocket); } //if we ever could do static virtual functions, this would be one
virtual void doGet()
{
string name = cat1.name;
DBG("\r\nIn CatDoorHandler::doGet()\r\n");
string header = "<html><body><h1>Cat Door System</h1>";
string p1 = "<h2><u>System Status</u></h2>";
string p2 = system1.bOverrideSystem == true ? "Yes" : "No";
string p3 = "<p>Override System: " + p2 + "</p>";
string p4 = system1.bIsDoorClosed == true ? "Yes" : "No";
string p5 = "<p>Door Status: " + p4 + "</p>";
string p6 = "<h2><u>Cats Status</u></h2>";
string p7 = "<p>Is " + cat1.name + " Inside: Yes</p>";
string footer = "</body></html>";
string resp = header + p1 + p3 + p5 + p6 + p7 + footer;
setContentLen( resp.length());
respHeaders()["Connection"] = "close";
writeData(resp.c_str(), resp.length());
DBG("\r\nExit CatDoorHandler::doGet()\r\n");
}
virtual void doPost(){};
virtual void doHead(){};

virtual void onReadable(){}; //Data has been read
virtual void onWriteable()
{
DBG("\r\nCatDoorHandler::onWriteable() event\r\n");
close(); //Data written, we can close the connection
}
virtual void onClose(){}; //Connection is closing

virtual void SetOverrideSystem(bool bOverride)
{
    bOverrideSystem = bOverride;
};

virtual void SetDoorStatus(bool bLocked)
{
    bDoorStatus = bLocked;    
};

virtual void SetIsCatInside(bool bIsInside)
{
    bIsCatInside = bIsInside;
};

protected:
bool bOverrideSystem;
bool bDoorStatus;
bool bIsCatInside;

};

int main() 
{
    //Initialize system parameters
    system1.bOverrideSystem = false;  
    system1.bIsDoorClosed = true; //Initialize default here read from sensor later
  
    //Initialize cat 1 parameters
    cat1.id = 1;
    cat1.name = "Garfield";
    
    printf("Setting up...\n");
    EthernetErr ethErr = eth.setup();
    if(ethErr)
    {
        printf("Error %d in setup.\n", ethErr);
        return -1;
    }
    printf("Setup OK\n");
  
    svr.addHandler<CatDoorHandler>("/"); //Default handler
    svr.bind(80);
  
    printf("Listening...\n");
    
    Timer tm;
    tm.start();
    //Listen indefinitely
    while(true)
    {
  
        Net::poll();
        if(tm.read()>.5)
        {
            led1=!led1; //Show that we are alive
            tm.start();
        }
    }
  
    return 0;
}
