#include "mbed.h"
#include "EthernetNetIf.h"
#include "TCPSocket.h"



EthernetNetIf eth;
TCPSocket tcp;
Host server(IpAddr(192,168,15,105), 2222);

DigitalOut ledeth(LED1);
DigitalOut ledhost(LED2);
DigitalOut ledsendo(LED3);
DigitalOut ledsende(LED4);


struct
{
    int connected;
    int writeable;
}flags;


void onTCPSocketEvent(TCPSocketEvent e)
{
    //printf("New TCPSocketEvent: %d",e);
    switch(e)
    {
        case TCPSOCKET_CONNECTED:   flags.connected = 1;break;
        
        case TCPSOCKET_WRITEABLE:   flags.writeable = 1;break;
        
        case TCPSOCKET_CONTIMEOUT:
        case TCPSOCKET_CONRST:
        case TCPSOCKET_CONABRT:
        case TCPSOCKET_ERROR:
        case TCPSOCKET_DISCONNECTED:
        {
            tcp.close();
            flags.connected = 0;
        }break;
    }
}

void sendMessage(Host host, char* message, int msgLen)
{   

    TCPSocketErr err = tcp.connect(host);
    if(err)
        ledhost=0;
        else
        ledhost=1;
                    
    if(/*flags.connected && flags.writeable*/true)
    {
       // printf("Sending data\n");
        flags.writeable = 0;
        int transLen = tcp.send(message,msgLen);
        if(transLen != msgLen)
        ledsende=1;
     //       printf("Error in transmission\n");
    }        
    tcp.close();
}

int main()
{
    EthernetErr ethErr = eth.setup();
    if(ethErr)
      ledeth=0;
    else
       ledeth=1;
  
    tcp.setOnEvent(&onTCPSocketEvent);
    while(true)
    {
       Net::poll();
       sendMessage(server,"Hello Server\n",13);
       wait(5);
    } 
}