#include "Led_Lcd.h"
#include <stdio.h>

LCD_DISCO_F429ZI lcd;

LedLcd::LedLcd(unsigned char ucColumnXPosition)
{
    ucColumnXIndex = (ucColumnXPosition * 80);
    lcd.Clear(LCD_COLOR_BLACK);
    lcd.SetFont(&Font24);
}

void LedLcd::On(unsigned char ucButtonLight)
{
    uint16_t Ypos = 0;
    char text[2];
    lcd.SetBackColor(LCD_COLOR_RED);
    for(unsigned char ucButtonNumber = 0; ucButtonNumber < 4; ucButtonNumber++){
        lcd.SetTextColor(LCD_COLOR_GREEN);
        lcd.DrawRect(ucColumnXIndex, 0+Ypos, 80, 80);  
        if(ucButtonNumber == ucButtonLight){
            lcd.SetTextColor(LCD_COLOR_GREEN);
        }
        else{
            lcd.SetTextColor(LCD_COLOR_BLUE);
        }
        lcd.FillRect(ucColumnXIndex+1, 1+Ypos, 79, 79);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        sprintf(text, "%d", ucButtonNumber);
        lcd.DisplayStringAt(ucColumnXIndex, 1+Ypos, (uint8_t *)&text, LEFT_MODE);
        Ypos = Ypos + 80;
    }
}