/* Discrete RGB color sensor (buffered)
 *
 * - uses single-channel light-dependent resistor (via ADC)
 *   and a RGB LED.
 * -  compensates background light
 *
 * Copyright (c) 2014 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __RGB_SENSOR_BUFFER_H__
#define __RGB_SENSOR_BUFFER_H__

#include <rgb_sensor.h>

#ifndef RGB_SENSOR_BUFFER_MIN
#define RGB_SENSOR_BUFFER_MIN 32
#endif/*RGB_SENSOR_BUFFER_MIN*/

#ifndef RGB_SENSOR_BUFFER_SPURIOUS_COUNT
#define RGB_SENSOR_BUFFER_SPURIOUS_COUNT 32
#endif/*RGB_SENSOR_BUFFER_SPURIOUS_COUNT*/

class RGB_SensorBuffer: protected RGB_Sensor
{
    public:
        RGB_SensorBuffer(PinName red, PinName green, PinName blue, PinName adc);
        int trigger(TRGB* rgb, int count, int treshold);

    private:
        TRGB* m_buffer;
        volatile int m_count, m_treshold, m_buffer_pos, m_buffer_spurious;
        bool m_initialized;
        static void __adc_irq(void);
        void adc_irq(void);
        static RGB_SensorBuffer* m_global;
        static bool __callback(const TRGB &color);
        bool callback(const TRGB &color);
};

#endif/*__RGB_SENSOR_BUFFER_H__*/