/*
 * Builds the payload to send to the server.
 *
 * Copyright (c) 2014 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 
#ifndef _PAYLOAD_H
#define _PAYLOAD_H
#include "rgb_sensor.h"

// TODO: include from common file
#ifndef RGB_VALUES
#define RGB_VALUES      512
#endif

class Payload
{
public:
    Payload();
    
    void build(const TRGB *samples, int sample_count);
    int raw_bytes_size();
    uint8_t* raw_bytes() const;
    
private:
    typedef struct 
    {
        int sample_count;
        int mean[3];
        signed char deltas[RGB_VALUES][3];
    } MeanDeltaBuffer;

    MeanDeltaBuffer m_mdb;
    int m_mdb_bytes;
};

#endif // _PAYLOAD_H