#include "mbed.h"
#include "rtos.h"
#include "nsdl_support.h"
#include "buffered_rgb_resource.h"
#include "rgb_sensor_buffer.h"
#include "payload.h"

#define RESOURCE_ID    "sensor/capsule"
#define RGB_VALUES 512
#define RGB_THRESHOLD 50

extern Serial pc;
/* stored data for observable resource */
static uint8_t obs_number = 0;
static uint8_t *obs_token_ptr = NULL;
static uint8_t obs_token_len = 0;

static TRGB g_buffer[RGB_VALUES];
//static RGB_SensorBuffer g_rgb(p23,p24,p25,p20);
static RGB_SensorBuffer g_rgb(P2_3,P2_2,P2_4,P1_31);
static Payload g_payload;

static void exec_call_thread(void const *args)
{
    while (true)
    {
        if (obs_number == 0 && obs_token_ptr == NULL)
            pc.printf("ERROR: obs_number: %d, obs_token_ptr: %0x%08x\r\n", obs_number, obs_token_ptr);

        obs_number++;        
        pc.printf("Waiting for detector...\r\n");        
        int samples_captured = g_rgb.trigger(g_buffer, RGB_VALUES, RGB_THRESHOLD); 
        
        g_payload.build(g_buffer, samples_captured);
        
        int result = sn_nsdl_send_observation_notification(obs_token_ptr, obs_token_len, g_payload.raw_bytes(), g_payload.raw_bytes_size(), &obs_number, 1, COAP_MSG_TYPE_NON_CONFIRMABLE, 0);
        
        pc.printf("Observation send %s. [samples: %d, bytes: %d]\r\n", result == 0 ? "failed" : "succeeded", samples_captured, g_payload.raw_bytes_size());
    }
}

/* Only GET method allowed */
static uint8_t resource_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto)
{
    sn_coap_hdr_s *coap_res_ptr = 0;

    coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CONTENT);

    coap_res_ptr->payload_len = g_payload.raw_bytes_size();
    coap_res_ptr->payload_ptr = g_payload.raw_bytes();

    if(received_coap_ptr->token_ptr)
    {
        if(obs_token_ptr)
        {
            free(obs_token_ptr);
            obs_token_ptr = 0;
        }
        obs_token_ptr = (uint8_t*)malloc(received_coap_ptr->token_len);
        if(obs_token_ptr)
        {
            memcpy(obs_token_ptr, received_coap_ptr->token_ptr, received_coap_ptr->token_len);
            obs_token_len = received_coap_ptr->token_len;
        }
    }

    if(received_coap_ptr->options_list_ptr->observe)
    {
        coap_res_ptr->options_list_ptr = (sn_coap_options_list_s*)malloc(sizeof(sn_coap_options_list_s));
        memset(coap_res_ptr->options_list_ptr, 0, sizeof(sn_coap_options_list_s));
        coap_res_ptr->options_list_ptr->observe_ptr = &obs_number;
        coap_res_ptr->options_list_ptr->observe_len = 1;
        obs_number++;
    }

    sn_nsdl_send_coap_message(address, coap_res_ptr);

    coap_res_ptr->options_list_ptr->observe_ptr = 0;
    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);

    return 0;
}

int create_buffered_rgb_resource(sn_nsdl_resource_info_s *resource_ptr)
{
    static Thread exec_thread(exec_call_thread);
    nsdl_create_dynamic_resource(resource_ptr, sizeof(RESOURCE_ID) - 1, (uint8_t*)RESOURCE_ID, 0, 0, 1, &resource_cb, SN_GRS_GET_ALLOWED);
    return 0;
}
