#ifndef _ISD1820P_H_
#define _ISD1820P_H_

#include "mbed.h"

/** ISD1820P class.
 *  Used to control recording and playblack of sounds using this component: http://www.seeedstudio.com/depot/Grove-Recorder-p-1825.html
 */
class ISD1820P {
public:
    /**
     *  Constructor. Initializes the maximum record/playback sound to defaultMaxSoundTime.
     *
     *  @param recordPin The pin that controls recording.
     *  @param playPin The pin that controls playback.
     */
    ISD1820P(PinName recordPin, PinName playPin);
    
    /**
     *  Starts a new recording.
     *
     *  @param time Controls how long to record.
     */
    void startRecording(float time);
    
    /**
     *  Starts a new recording with a length of the maximum time.
     */
    void startRecordingMaxTime();
    
    /**
     *  Stops the current recording.
     */
    void stopRecording();
    
    /**
     *  Starts playback of the previous recording.
     *
     *  @param time Controls how long to play the last recording.
     */
    void startPlaying(float time);
    
    
    /**
     *  Starts playback of the previous recording up to the maximum time.
     */
    void startPlayingMaxTime();
    
    /**
     *  Stops the current playback
     */
    void stopPlaying();
    
    /**
     *  Set the default max recording and playback time. The default is 10 seconds.
     *
     *  @param maxTime The maximum time in seconds to record and playback sounds.
     */
    void setMaxSoundTime(float maxTime);

    
private:    
    /**
     *  Default sound recording/playback is 10 seconds
     */
    const static float defaultMaxSoundTime = 10.0f;
     
    float maxSoundTime;
    
    DigitalOut record;
    DigitalOut play;
    
    Timeout recordTimeout;
    Timeout playTimeout;
};
    
#endif