#include "ISD1820P.h"

ISD1820P::ISD1820P(PinName recordPin, PinName playPin)
        : maxSoundTime(defaultMaxSoundTime), record(recordPin, 0), play(playPin, 0) {
    // Empty
}

void ISD1820P::stopRecording() {
    record = 0;
}

void ISD1820P::startRecording(float time) {
    if (!record) {
        if (time > maxSoundTime) {
            time = maxSoundTime;
        }        
        
        record = 1;
        recordTimeout.attach(this, &ISD1820P::stopRecording, time);
    }
}

void ISD1820P::startRecordingMaxTime() {
    startRecording(maxSoundTime);
}

void ISD1820P::stopPlaying() {
    play = 0;
}

void ISD1820P::startPlaying(float time) {
    if (!play && !record) {
        if (time > maxSoundTime) {
            time = maxSoundTime;
        }
        
        play = 1;
        playTimeout.attach(this, &ISD1820P::stopPlaying, time);
    }
}

void ISD1820P::startPlayingMaxTime() {
    startPlaying(maxSoundTime);
}
    