// 24LC256 I2C EEPROM mock device
// Datasheet: http://ww1.microchip.com/downloads/en/DeviceDoc/20001203U.pdf

#include <mbed.h>

#define BUFF_SIZE   10

I2CSlave slave(p28, p27);

int main() {
    char buf[BUFF_SIZE];               // Only up to 10 bytes (8 bytes max sequential write)
    slave.frequency(400000);
    slave.address(0xA0);
    
    printf("Starting on address 0xA0\r\n");
    
    while (1) {
        int i = slave.receive();
        switch (i) {
            case I2CSlave::ReadAddressed:
                slave.write(buf + 2, 8); // buf[0 - 1] are just the address bytes (ignoring them)
            break;
            
            case I2CSlave::WriteGeneral:
                slave.read(buf, BUFF_SIZE);
            break;
            
            case I2CSlave::WriteAddressed:
                slave.read(buf, BUFF_SIZE);
            break;
        }
    }
}