#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"

EthernetInterface eth;
HTTPClient http;
char str[512];

int main() 
{
    printf("Initializing ethernet\n");
    eth.init(); //Use DHCP
    printf("Initialization complete. Attempting to connect...\n");
    
    if (eth.connect() < 0) {
        // Error
        printf("Error! Ethernet failed to connect.\n");
    } else {
        // Success
        printf("Ethernet connected successfully.\n");
        printf("IP Address: %s\n", eth.getIPAddress());
        printf("Gateway: %s\n", eth.getGateway());
        printf("MAC Address %s\n", eth.getMACAddress());
    }    
    
    //GET data
    printf("\nTrying to fetch page...\n");
    int ret = http.get("http://httpbin.org/get", str, 128);
    if (!ret)
    {
      printf("Page fetched successfully - read %d characters\n", strlen(str));
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
    
    //POST data
    HTTPMap map;
    HTTPText inText(str, 512);
    map.put("Hello", "World");
    map.put("test", "1234");
    printf("\nTrying to post data...\n");
    ret = http.post("http://httpbin.org/post", map, &inText);
    if (!ret)
    {
      printf("Executed POST successfully - read %d characters\n", strlen(str));
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
    
    //PUT data
    strcpy(str, "This is a PUT test!");
    HTTPText outText(str);
    //HTTPText inText(str, 512);
    printf("\nTrying to put resource...\n");
    ret = http.put("http://httpbin.org/put", outText, &inText);
    if (!ret)
    {
      printf("Executed PUT successfully - read %d characters\n", strlen(str));
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
    
    //DELETE data
    //HTTPText inText(str, 512);
    printf("\nTrying to delete resource...\n");
    ret = http.del("http://httpbin.org/delete", &inText);
    if (!ret)
    {
      printf("Executed DELETE successfully - read %d characters\n", strlen(str));
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
    
    printf("Keeping ethernet connection open for pinging\n");
    printf("IP Address: %s\n", eth.getIPAddress());
    printf("Gateway: %s\n", eth.getGateway());
    printf("MAC Address %s\n", eth.getMACAddress());
    while(1) {
    }
}
