#include "mbed.h"
#include "GEColorEffects.h"

#define NUM_LIGHTS 25
#define NUM_COLORS 6
#define NUM_LEDS_PER_COLOR 1

int px[NUM_LIGHTS];

// See the program page for information on the timing numbers
// The given numbers are for the K64F
GEColorEffects gce(D9, NUM_LIGHTS);

int main()
{

    //ws.useII(WS2812::PER_PIXEL); // use per-pixel intensity scaling
    
    // set up the colours we want to draw with
    int colorbuf[NUM_COLORS] = {0xFFFF0000, 0xFFFF4400, 0xFFFFFF00, 0xFF00CC00, 0xFF0033CC, 0xFF660099};

    // for each of the colours (j) write out 10 of them
    // the pixels are written at the colour*10, plus the colour position
    // all modulus 60 so it wraps around
    for (int i = 0; i < NUM_LIGHTS; i++) {
        px[i] = colorbuf[(i / NUM_LEDS_PER_COLOR) % NUM_COLORS];
    }

    // Now the buffer is written, rotate it
    // by writing it out with an increasing offset
    while (1) {
        int last = px[NUM_LIGHTS - 1];
        for (int i = NUM_LIGHTS - 1; i > 0; i--) {
            px[i] = px[i - 1];
        }
        px[0] = last;
        gce.write(px, true);
        wait(1);
    }

}
