#include "GEColorEffects.h"

GEColorEffects::GEColorEffects(PinName pin, int size) : size(size), gpo(pin) {
    
}


void GEColorEffects::write(int buf[], bool eightBit) {
    int l, r, g, b;
    
    __disable_irq();
    for (int i = 0; i < size; i++) {
        l = (buf[i] >> 24) & 0xFF;
        r = (buf[i] >> 16) & 0xFF;
        g = (buf[i] >> 8) & 0xFF;
        b = buf[i] & 0xFF;
        
        if (eightBit) {
            sendFrame(i, l, r >> 4, g >> 4, b >> 4);
        } else {
            sendFrame(i, l, r, g, b);
        }
    }
    __enable_irq();
}

// GPIO output to send a logical 0
void GEColorEffects::sendZero() {
    gpo = 0;
    wait_us(10);
    gpo = 1;
    wait_us(20);
}
 
// GPIO output to send a logical 1
void GEColorEffects::sendOne() {
    gpo = 0;
    wait_us(20);
    gpo = 1;
    wait_us(10);
}
 
// Parse data value to serial process 0/1's
void GEColorEffects::sendData(unsigned char data, int length) {
    unsigned int data_bit;
 
    for (int i = (length - 1); i >= 0; i--) {
        data_bit = (data >> i) & 0x01;
        if (data_bit == 0) {
            sendZero();
        } else {
            sendOne();
        }
    }
}

void GEColorEffects::setBrightness(unsigned char brightness) {
    __disable_irq();
    sendFrame(63, brightness, 0, 0, 0);
    __enable_irq();
}

// Send frame of data to control a single pixel
void GEColorEffects::sendFrame(unsigned char address, unsigned char lumm, unsigned char R, unsigned char G, unsigned char B) {
// Send "1" value to start Frame
    sendOne();
// Send Address
    sendData(address,6);
// Send Luminosity
    sendData(lumm,8);
// Send Blue 4-bits
    sendData(B,4);
// Send Green 4-bits
    sendData(G,4);
// Send Red 4-bits
    sendData(R,4);
// Send End of Frame Marker
    endFrame();
}

void GEColorEffects::endFrame() {
    gpo = 0;
    wait_us(30);
}