#ifndef GE_COLOR_EFFECTS_H
#define GE_COLOR_EFFECTS_H

#include "mbed.h"

class GEColorEffects {
    
public:
    GEColorEffects(PinName pin, int size);
    void setBrightness(unsigned char brightness);
    void write(int buf[], bool eightBit);

private:
    int size;
    DigitalOut gpo;

    void sendZero();
    void sendOne();
    void sendData(unsigned char data, int length);
    void sendFrame(unsigned char address, unsigned char lumm, unsigned char R, unsigned char G, unsigned char B);
    void endFrame();
};

#endif