#include "Buzzer.h"

Buzzer::Buzzer(PinName pin)
{
    _buzzer = new DigitalOut(pin);
    //_ticker = new Ticker();
}

Buzzer::Buzzer(PinName pin, float period)
{
    _buzzer = new DigitalOut(pin);
    _period = period;
    //_ticker = new Ticker();
}

Buzzer::~Buzzer()
{
    delete _buzzer;
}

void Buzzer::definirPeriode(float period)
{
    _period = period;
}

void Buzzer::changerPeriode(float period)
{
    definirPeriode(period);
    demarrer();
}

void Buzzer::demarrer()
{
    _ticker.attach(callback(this, &Buzzer::bipper), _period);
}

void Buzzer::arreter()
{
    _ticker.detach();
}

void Buzzer::bipper()
{
    *_buzzer = !*_buzzer;
}