#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "mpr121.h"

//Arrays for the notes each button will play
int L1[300];
int L2[300];
int L3[300];
int L4[300];

int timespace = -6; //count for drawing the circles

//Flips the LEDs when you hit one of the buttons
DigitalOut myled(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

AnalogOut DACout(p18); //speaker analog out

uLCD_4DGL uLCD(p28,p27,p30); // serial tx, serial rx, reset pin;

SDFileSystem sd(p5, p6, p7, p8, "sd"); // the pinout on the mbed Cool Components workshop board

FILE *wav_file; // the song to play
wave_player player(&DACout); // the player

SPI spi(p11, p12, p13); //for the ShiftBrite
DigitalOut latch(p15);
DigitalOut enable(p16);

Mutex lcdMutex; //LCD mutex lock

InterruptIn interrupt(p21); //interrupt signal for keypad

// keypad declaration
I2C i2c(p9, p10);
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);

int value = 0; //keypad input value
int points = 0; //points
int red = 0; // global values for changing ShiftBrite
int green = 0;

//function to output to ShiftBrite
void RGB_LED(int red, int green, int blue) {
    unsigned int low_color=0;
    unsigned int high_color=0;
    high_color=(blue<<4)|((red&0x3C0)>>6);
    low_color=(((red&0x3F)<<10)|(green));
    spi.write(high_color);
    spi.write(low_color);
    latch=1;
    latch=0;
}

//Interrupt function
void fallInterrupt(){
    if(timespace > -1){
        value = mpr121.read(0x00); //read keypad
        if(((value>>0) & 0x01) == 1)
        {
            myled = 1 - myled;
            if(L4[timespace] == 1) //compare value 
            {
                points+=5; //increment points if correct
                red = 0; green = 255; // ShiftBrite is green
            }
            else
            {
                red = 255; green = 0; //ShiftBrite is red        
            }
        }
        
        if(((value>>1) & 0x01) == 1)
        {
            myled2 = 1 - myled2;
            if(L3[timespace] == 1)
            {
                points+=5;
                red = 0; green = 255;
            }
            else
            {
                red = 255; green = 0;
            }
        }       
        
        if(((value>>2) & 0x01) == 1)
        {
            myled3 = 1 - myled3;
            if(L2[timespace] == 1)
            {
                points+=5;
                red = 0; green = 255;
            }
            else
            {
                red = 255; green = 0;
            }
        }
        
        if(((value>>3) & 0x01) == 1)
        {
            myled4 = 1 - myled4;
            if(L1[timespace] == 1)
            {
                red = 0; green = 255;
                points+=5;
            }
            else
            {
                red = 255; green = 0;
            }
        } 
    }
}

void lcdThread1(void const *args) {
    while (true) {
        lcdMutex.lock();
        timespace += 1;
        if (timespace < 256) //if song notes are not done,
        {
            //delete any circles in the yellow circles
            uLCD.filled_circle(110, 20, 12, 0x000000);
            uLCD.filled_circle(110, 50, 12, 0x000000);
            uLCD.filled_circle(110, 80, 12, 0x000000);
            uLCD.filled_circle(110, 110, 12, 0x000000);
            
            //draw the path of the circles
            if (timespace >= 0){
                if (L1[timespace] == 1){
                    uLCD.filled_circle(86, 20, 10, 0x000000);
                    uLCD.filled_circle(110, 20, 12, 0x0000FF);}
                if (L2[timespace] == 1){
                    uLCD.filled_circle(86, 50, 10, 0x000000);
                    uLCD.filled_circle(110, 50, 12, 0x00FFFF);}
                if (L3[timespace] == 1){
                    uLCD.filled_circle(86, 80, 10, 0x000000);
                    uLCD.filled_circle(110, 80, 12, 0x00FF00);}
                if (L4[timespace] == 1){
                    uLCD.filled_circle(86, 110, 10, 0x000000);
                    uLCD.filled_circle(110, 110, 12, 0x008000);}
            }
            if (timespace >= -1){
                if (L1[timespace+1] == 1){
                    uLCD.filled_circle(66, 20, 8, 0x000000);
                    uLCD.filled_circle(86, 20, 10, 0x0000FF);}
                if (L2[timespace+1] == 1){
                    uLCD.filled_circle(66, 50, 8, 0x000000);
                    uLCD.filled_circle(86, 50, 10, 0x00FFFF);}
                if (L3[timespace+1] == 1){
                    uLCD.filled_circle(66, 80, 8, 0x000000);
                    uLCD.filled_circle(86, 80, 10, 0x00FF00);}
                if (L4[timespace+1] == 1){
                    uLCD.filled_circle(66, 110, 8, 0x000000);
                    uLCD.filled_circle(86, 110, 10, 0x008000);}
            }
            if (timespace >= -2){
                if (L1[timespace+2] == 1){
                    uLCD.filled_circle(50, 20, 6, 0x000000);
                    uLCD.filled_circle(66, 20, 8, 0x0000FF);}
                if (L2[timespace+2] == 1){
                    uLCD.filled_circle(50, 50, 6, 0x000000);
                    uLCD.filled_circle(66, 50, 8, 0x00FFFF);}
                if (L3[timespace+2] == 1){
                    uLCD.filled_circle(50, 80, 6, 0x000000);
                    uLCD.filled_circle(66, 80, 8, 0x00FF00);}
                if (L4[timespace+2] == 1){
                    uLCD.filled_circle(50, 110, 6, 0x000000);
                    uLCD.filled_circle(66, 110, 8, 0x008000);}
            }
            if (timespace >= -3){
                if (L1[timespace+3] == 1){
                    uLCD.filled_circle(38, 20, 4, 0x000000);
                    uLCD.filled_circle(50, 20, 6, 0x0000FF);}
                if (L2[timespace+3] == 1){
                    uLCD.filled_circle(38, 50, 4, 0x000000);
                    uLCD.filled_circle(50, 50, 6, 0x00FFFF);}
                if (L3[timespace+3] == 1){
                    uLCD.filled_circle(38, 80, 4, 0x000000);
                    uLCD.filled_circle(50, 80, 6, 0x00FF00);}
                if (L4[timespace+3] == 1){
                    uLCD.filled_circle(38, 110, 4, 0x000000);
                    uLCD.filled_circle(50, 110, 6, 0x008000);}
            }
            if (timespace >= -4){
                if (L1[timespace+4] == 1){
                    uLCD.filled_circle(30, 20, 2, 0x000000);
                    uLCD.filled_circle(38, 20, 4, 0x0000FF);}
                if (L2[timespace+4] == 1){
                    uLCD.filled_circle(30, 50, 2, 0x000000);
                    uLCD.filled_circle(38, 50, 4, 0x00FFFF);}
                if (L3[timespace+4] == 1){
                    uLCD.filled_circle(30, 80, 2, 0x000000);
                    uLCD.filled_circle(38, 80, 4, 0x00FF00);}
                if (L4[timespace+4] == 1){
                    uLCD.filled_circle(30, 110, 2, 0x000000);
                    uLCD.filled_circle(38, 110, 4, 0x008000);}
            }
            if (L1[timespace+5] == 1){
                uLCD.filled_circle(30, 20, 2, 0x0000FF);}
            if (L2[timespace+5] == 1){
                uLCD.filled_circle(30, 50, 2, 0x00FFFF);}
            if (L3[timespace+5] == 1){
                uLCD.filled_circle(30, 80, 2, 0x00FF00);}
            if (L4[timespace+5] == 1){
                uLCD.filled_circle(30, 110, 2, 0x008000);}
        }
        else //when the game is over
        {
            uLCD.cls();
            uLCD.printf("POINTS: %d\n", points);
            if(points > 1000)
            {
                uLCD.printf("GOOD JOB!");
            }
            else
            {
                uLCD.printf("YOU ARE BAD AT THIS GAME");
            }
        }
        //draw yellow circles
        uLCD.circle(110,20,12, 0xFFFF00);
        uLCD.circle(110,50,12, 0xFFFF00);
        uLCD.circle(110,80,12, 0xFFFF00);
        uLCD.circle(110,110,12, 0xFFFF00);
        
        lcdMutex.unlock();
        Thread::wait(250);

    }
}

//Function that plays song. It is declared as a thread in main.
void wavThread(void const *args) {
    Thread::wait(1200);
    wav_file = fopen("/sd/wavfiles/MyHouseLowQ.wav", "r");
    player.play(wav_file);
    while (true) {
        Thread::wait(100);
    }
}

//Function that reads the note text file from the SD
void textRead(){
    FILE *fp = fopen("/sd/mydir/myHouse.txt", "r");
    char line[200];
    char one[2]="1";
    char two[2]="2";
    char three[2]="3";
    char four[2]="4";
    
    //Generate the lists. There are no two notes that play at once. 
    int index = 0;
    while (fgets(line, 200, fp)) {        
        char firstLet[sizeof(line)];
        strncpy(firstLet, line,1);
        firstLet[1] = 0;
        if (strcmp(firstLet,one) == 0){
            L1[index] = 1;
            L2[index] = 0;
            L3[index] = 0;
            L4[index] = 0;
        }
        else if(strcmp(firstLet,two) == 0){
            L1[index] = 0;
            L2[index] = 1;
            L3[index] = 0;
            L4[index] = 0;
            
        }
        else if(strcmp(firstLet,three) == 0){
            L1[index] = 0;
            L2[index] = 0;
            L3[index] = 1;
            L4[index] = 0;
            
        }
        else if(strcmp(firstLet,four) == 0){
            L1[index] = 0;
            L2[index] = 0;
            L3[index] = 0;
            L4[index] = 1;
            
        }        
        index++;
    }
}
 
int main() {
    
    textRead(); //read the notes text file
    uLCD.baudrate(3000000); //increase the baudrate for sick graphics
    Thread thread3(wavThread); //thread that plays the song
    Thread thread1(lcdThread1); //thread that displays the circles
    
    //outputs for ShiftBrite
    enable=0;
    latch=0;
    
    //declare interrupt
    interrupt.mode(PullUp);
    interrupt.fall(&fallInterrupt);
    
    spi.format(16,0);
    spi.frequency(500000);
        
    while (true) {   
        Thread::wait(100);
        //update the ShiftBrite
        RGB_LED(red, green, 0);

    }
}
