#include "mbed.h"
#include "LCD_DISCO_F429ZI.h"

AnalogOut pinout(PA_4);
LCD_DISCO_F429ZI lcd;

#define PI        (3.141592653589793238462)
#define AMPLITUDE (1.0)    // x * 3.3V
#define PHASE     (PI * 1) // 2*pi is one period
#define RANGE     (0x7FFF)
#define OFFSET    (0x7FFF)

#define PERIOD    (70000)

// Configuration for sinewave output
#define BUFFER_SIZE (360)
uint16_t buffer[BUFFER_SIZE];
uint8_t text[30];
int x = 0;
int i;

InterruptIn user_button(USER_BUTTON);

void button_pressed(){
    x = (x+1)%4;
}

void calculate_sinewave(void);

int main() {
    calculate_sinewave();
    while(1) {
        user_button.rise(&button_pressed);      
        switch(x){
            // sinewave output
            case 0:
                for (i = 0; i < BUFFER_SIZE; i++) {
                    pinout.write_u16(buffer[i]);
                }
                break;
            
            // triangle output
            case 1:
                for (i = 0; i < PERIOD/2; i++) {
                    pinout.write_u16(i);
                }
                
                for (i = PERIOD/2; i>0; i--) {
                    pinout.write_u16(i);
                }
                break;
            
            //square output
            case 2:
                for (i = 0; i < PERIOD/2; i++) {
                    pinout.write_u16(0);
                }
                
                for (i = PERIOD/2; i>0; i--) {
                    pinout.write_u16((uint16_t)(AMPLITUDE*RANGE+OFFSET));
                }       
                break;
            
            case 3:
                //sawtooth output
                for (i = 0; i < PERIOD/2; i++) {
                    pinout.write_u16(i);
                }
                break;
                
            default:
                lcd.DisplayStringAt(0, LINE(1), (uint8_t *)"Signal Generator", CENTER_MODE);
        }
    }
}

// Create the sinewave buffer
void calculate_sinewave(void){
  for (int i = 0; i < BUFFER_SIZE; i++) {
     double rads = (PI * i)/180.0; // Convert degree in radian
     buffer[i] = (uint16_t)(AMPLITUDE * (RANGE * (cos(rads + PHASE))) + OFFSET);
  }
}
