#include "mbed.h"
#include "uLCD_4DGL.h"
 
/* ==== Navigation Switch ===== */
class Nav_Switch
{
public:
    Nav_Switch(PinName up,PinName down,PinName left,PinName right,PinName fire);
    int read();
//boolean functions to test each switch
    bool up();
    bool down();
    bool left();
    bool right();
    bool fire();
//automatic read on RHS
    operator int ();
//index to any switch array style
    bool operator[](int index) {
        return _pins[index];
    };
private:
    BusIn _pins;
 
};
Nav_Switch::Nav_Switch (PinName up,PinName down,PinName left,PinName right,PinName fire):
    _pins(up, down, left, right, fire)
{
    _pins.mode(PullUp); //needed if pullups not on board or a bare nav switch is used - delete otherwise
    wait(0.001); //delays just a bit for pullups to pull inputs high
}
inline bool Nav_Switch::up()
{
    return !(_pins[0]);
}
inline bool Nav_Switch::down()
{
    return !(_pins[1]);
}
inline bool Nav_Switch::left()
{
    return !(_pins[2]);
}
inline bool Nav_Switch::right()
{
    return !(_pins[3]);
}
inline bool Nav_Switch::fire()
{
    return !(_pins[4]);
}
inline int Nav_Switch::read()
{
    return _pins.read();
}
inline Nav_Switch::operator int ()
{
    return _pins.read();
}

uLCD_4DGL uLCD(p9,p10,p11);
Nav_Switch myNav(p15,p16,p12,p13,p14);
PwmOut myled(LED1);
AnalogIn mypotentiometer(p20);

void drawTile(int x, int y, int color){
        uLCD.filled_rectangle(x, y, x+20, y+2, color);
}

void drawAllTiles(int *enemy_x1, int *enemy_y1, int *enemy_color, bool *alive){
    int i = 0;
    while(i < 16){
        if(alive[i]){
            drawTile(enemy_x1[i], enemy_y1[i], enemy_color[i]);
        }
        i++;
    }
}

int position(float pot, int prev_position){
    int player_x1 = pot*108;
    drawTile(prev_position, 125, BLACK);
    drawTile(player_x1, 125, WHITE);
    return player_x1;
}

int moveRight(int player_x1){
    int prev_position = player_x1;
    player_x1 = player_x1 + 6;
    if(player_x1 > 108){
        player_x1 = 108;
    }
    else{
        drawTile(prev_position, 125, BLACK);
        drawTile(player_x1, 125, WHITE);
    }
    return player_x1;
}

int moveLeft(int player_x1){
    int prev_position = player_x1;
    player_x1 = player_x1 - 6;
    if(player_x1 < 0){
        player_x1 = 0;
    }
    else{
        drawTile(prev_position, 125, BLACK);
        drawTile(player_x1, 125, WHITE);
    }
    return player_x1;
}

void printInfo(int lives, int points){
    uLCD.locate(0,0);
    uLCD.printf("Lives:%i", lives);

    uLCD.locate(9,0);
    uLCD.printf("Points:%i", points);
}

void drawBall(int x1, int y1, int color){
    uLCD.filled_circle(x1, y1, 5, color);
}

int main() {
     uLCD.baudrate(3000000);
    
    //draw initial player tile
    int player_x1 = 5;
    int player_y1 = 125;
    
    //array to keep track of all enemy tiles
    bool alive[16];
    int enemy_x1[16];
    int enemy_x2[16];
    int enemy_y1[16];
    int enemy_y2[16];
    int enemy_color[16];
    int i = 0;
    int x = 5;
    int y = 20;
    int color = GREEN;
    while(i<16){
        alive[i] = true;
        enemy_x1[i] = x;
        enemy_x2[i] = x+20;
        enemy_y1[i] = y;
        enemy_y2[i] = y+2;
        enemy_color[i] = color;
        
        //setup next tile
        y = y + 10;
        if(y>50){
            x = x + 30;
            y = 20;
        }
        if(color == GREEN){
            color = BLUE;
        }
        else if(color == BLUE){
            color = LGREY;
        }
        else if(color == LGREY){
            color = RED;
        }
        else{
            color = GREEN;
        }
        i++;
    }    
    int lives = 3;
    int points = 0;
    int ball_x1 = 7;
    int ball_y1 = 70;
    
    //0-up
    //1-left
    //2-down
    //3-right
    //4-topright
    //5-topleft
    //6-bottomleft
    //7-bottomright
    int dir = 7;
    bool flip = true;
    int start = true;
    bool erase = false;
    bool winner = false;
    bool loser = false;
    bool gameover = false;
    
    while(1){
        myled = mypotentiometer;
        if(myNav.fire()){
            if(start==true){erase = true;}
            start = false;
        }
        if(start==true){
            uLCD.media_init();
            uLCD.set_sector_address(0x003A, 0x4001);
            uLCD.display_image(0,0);           
        }
        else if(gameover==false){
            if(erase==true){uLCD.cls(); erase = false;}
            if(winner==true){uLCD.locate(4,9); uLCD.printf("YOU WIN!!!!"); gameover = true;}
            if(loser==true){uLCD.locate(4,9); uLCD.printf("YOU LOSE :("); gameover = true;}
            if(lives==0 && loser==false){loser = true; erase=true;}
            if(points==16 && winner==false){winner = true; erase = true;}
        drawBall(ball_x1, ball_y1, RED);
        drawAllTiles(enemy_x1, enemy_y1, enemy_color, alive);
        drawTile(player_x1, player_y1, WHITE);
        printInfo(lives, points);
        player_x1 = position(mypotentiometer, player_x1);
        
        if(myNav.right()){
            flip = !flip;
            player_x1 = moveRight(player_x1);
        }
        else if(myNav.left()){
            flip = !flip;
            player_x1 = moveLeft(player_x1);
        }
        
        drawBall(ball_x1, ball_y1, BLACK);
        //move ball
        if(dir==0){
            ball_y1 = ball_y1 - 3;
        }
        if(dir==2){
            ball_y1 = ball_y1 + 3;
        }
        if(dir==4){
            ball_y1 = ball_y1 -2;
            ball_x1 = ball_x1 +2;
        }
        if(dir==5){
            ball_y1 = ball_y1 - 2;
            ball_x1 = ball_x1 - 2;
        }
        if(dir==6){
            ball_y1 = ball_y1 +2;
            ball_x1 = ball_x1 - 2;
        }
        if(dir==7){
            ball_y1 = ball_y1+2;
            ball_x1 = ball_x1 + 2;
        }
        drawBall(ball_x1, ball_y1, RED);
        drawTile(player_x1, player_y1, WHITE);
        
        //check ball collision with player
        int ball_bottom = ball_y1 + 2.5;
        int ball_right = ball_x1 + 2.5;
        int ball_left = ball_x1 - 2.5;
        int ball_top = ball_y1 - 2.5;
        if(ball_bottom>=player_y1 && ball_x1 >= player_x1 && ball_x1 <= player_x1+20){
            if(dir==0){dir=2;}
            if(dir==6){dir=5;if(flip){dir=4;}}
            if(dir==7){dir=4;if(flip){dir=5;}}
        }
        
        //check ball collision with walls
        if(ball_bottom>=128){
            lives--;
            drawBall(ball_x1, ball_y1, BLACK);
            ball_x1 = 7;
            ball_y1 = 70;
            dir = 7;
        }
        if(ball_top<=9){
            if(dir==0){dir=2;}
            if(dir==5){dir=6;if(flip){dir=7;}}
            if(dir==4){dir=7;if(flip){dir=6;}}
            flip=!flip;
        }
        if(ball_left<=0){
            if(dir==1){dir=3;}
            if(dir==5){dir=4;if(flip){dir=7;}}
            if(dir==6){dir=7;if(flip){dir=4;}}
            flip=!flip;
        }
        if(ball_right>=128){
            if(dir==3){dir=1;}
            if(dir==4){dir=5;if(flip){dir=6;}}
            if(dir==7){dir=6;if(flip){dir=5;}}
            flip=!flip;
        }
        
        //check if ball collided with enemies
        i = 0;
        while(i < 16){
            if(alive[i]==true){
                int enemyX1 = enemy_x1[i];
                int enemyX2 = enemy_x2[i];
                int enemyY1 = enemy_y1[i];
                int enemyY2 = enemy_y2[i];
                if(ball_x1 >= enemyX1 && ball_x1 <= enemyX2){
                    if(ball_top <= enemyY2 && ball_top >=enemyY1){
                        points++;
                        alive[i] = false;
                        if(dir==0){dir=2;}
                        if(dir==5){dir=6;if(flip){dir=7;}}
                        if(dir==4){dir=7;if(flip){dir=6;}}
                        drawTile(enemyX1, enemyY1, BLACK);
                    }
                    else if(ball_bottom>=enemyY1 && ball_bottom <=enemyY2){
                        points++;
                        alive[i] = false;
                        if(dir==2){dir=0;}
                        if(dir==6){dir=5;if(flip){dir=4;}}
                        if(dir==7){dir=4;if(flip){dir=5;}}
                        drawTile(enemyX1, enemyY1, BLACK);

                    }
                }
                else if(ball_y1 >= enemyY1 && ball_y1 <= enemyY2){
                    if(ball_right >= enemyX1 && ball_right <= enemyX2){
                        points++;
                        alive[i] = false;
                        if(dir==3){dir=1;}
                        if(dir==4){dir=5;if(flip){dir=6;}}
                        if(dir==7){dir=6;if(flip){dir=5;}}
                        drawTile(enemyX1, enemyY1, BLACK);
                    }
                    else if(ball_left >= enemyX2 && ball_left <= enemyX1){
                        points++;
                        alive[i] = false;
                        if(dir==1){dir=3;}
                        if(dir==5){dir=4;if(flip){dir=6;}}
                        if(dir==6){dir=7;if(flip){dir=5;}}
                        drawTile(enemyX1, enemyY1, BLACK);
                    }
                }
            }
            i++;
        }
        
    }}
    
}
