
#include "mbed.h"
#include "system.h"
#include "loggforing.h"

Serial pc2(USBTX,USBRX);

/* Disse arrayene er sammenhengende, hvor hvert element representerer hverandre. */
AnalogIn krets[4] = {p15, p16, p17, p19};       //(krets 1, krets 2, krets 3, krets 4)
int inbrudd[4] = {0, 0, 0, 0};                  //angir hvor mange brudd som har gått i kretsen.

/* Hvert element represnterer hverandre i disse arayene. led[] brukes for å varsle for hvilken bryter som er aktivert */
DigitalOut kr_status[8] = {p21, p22, p23, p24, p25, p26, p27, p28};  //(bryter 1 krets 1, bryter 2 krets 1, bryter 1 krets 2....)
int led[8] = {1, 1, 1, 1, 1, 1, 1, 1};                               //Brukes som kontrollbetingelse, og settes til 0 hvis en alarm skal gå.
int led_pa[8] = {1, 1, 1, 1, 1, 1, 1, 1};                            //Brukes i funksjonen led_status for å generere en blinke sekvens.

DigitalIn servicebr(p12);    //servicebryter

int logg_kr[4] = {8, 9, 10, 11};                //sender over verdi til logg funksjon for å loggfore om begge brytere på en krets er aktivert.

/* Globale variabler som blir brukt i programmet */
int kr;                 //verdi som blir tastet inn i funksjonen natid_krets.
int toggle = 0;         //Inverterteres i led_status for å skape en blinkefunksjon.
int tall;               //variabel som brukes i systempaa.

Timer timer;                   //Startes ved aktivering av systemet for å kunne logge tid på de ulike situasjonenen.
Ticker kontroll;           //kaller opp overvaking()
Ticker led_aktiver;        //kaller opp led_status()
Ticker pass_varsel;         //

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>> FUNKSJONSPROTOTYPER <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

 //Komplett funksjon for systempa, inkl, loggforing og varsling av krets. 
void systempaa();

//stopper og reseter timer, og loggfører at systemet er skrudd av.
void systemav();

// Funksjonen blir kalt med 1Hz(1.0s) i en tikker, for overvåkning av kretser. 
void overvaking(void);

 //Nullstiller hele systemet ved aktivering av servicebryter 
void nullstilling(void);

// Funksjon for å lese av nåværende status på valgt krets. 
void natid_status(int kr);

// Blinke funksjon til baragraph. 
void led_status(void);

void feil_pass();

/*Funksjonen motar en verdi for variable akitv, timer t; blir startet, led_status og overvaking blir kalt opp i 2 ticker i while-løkka.
Funksjonen vil bli i while løkka så lenge aktiv er sann, når det blir satt til 0 eller usann vil den bryte ut av while-løkka, stopper timer,
loggføre ved hvilken tid systemet er avsluttet. Deretter vil systemet avslutte. */
void systempaa()
{
    timer.start();
    led_aktiver.attach(&led_status, 0.1);
    kontroll.attach(&overvaking, 1.0);
}


void systemav()
{
    led_aktiver.detach();
    kontroll.detach();
    for(int i = 0; i < 8; i++) kr_status[i] = 0;
    timer.stop();
    logg_system_av(timer.read());
    timer.reset();    
}

/* Funksjonen kontrolerer de 4 kretsene i en for løkke fra 0-3 som er basert på elementene i arrayet krets[].
Spennings verdiene over bryteren testes i 3 tester, første er bryter 1, andre er bryter 2, og siste test er begge brytere.
Hvis det er oppdaget en feil i en krets, vil den sett en 0 inn i arrayet led[] utifra hvilken bryter som er aktivert.
I betingelsen, blir det kontrolert slik at det er en 1 på den gitte plass til gitt bryter, hvis dette stemmer har ingen alarm gått. Er det en 0 der
er alarmen aktivert og det er ikke behov for å kontrollere bryteren på nytt. Dette forhindrer at logg_inbrudd loggfører bruddet mer enn en gang.
Arrayet inbrudd[] på 4 elementer blir brukt for å registrere antall brudd i kretsen.*/
void overvaking()
{
    for(int sloyfe = 0; sloyfe <=3 ; sloyfe++) {
        float v_test = krets[sloyfe];
        if(v_test*3.3 > 1.2) {
            if(3.3*v_test > 1.4 && 3.3*v_test < 1.7 && led[2*sloyfe] == 1) {
                inbrudd[sloyfe]++;
                led[2*sloyfe] = 0;
                logg_inbrudd(2*sloyfe, timer.read(), 3.3*v_test);
            } else if(3.3*v_test > 1.70 && 3.3*v_test < 2.0 && led[2*sloyfe +1] == 1) {
                inbrudd[sloyfe]++;
                led[2*sloyfe+1] = 0;
                logg_inbrudd(2*sloyfe +1, timer.read(), 3.3*v_test);
            } else if(3.3*v_test > 3.0 && (led[2*sloyfe] == 1 || led[2*sloyfe +1] == 1)) {
                inbrudd[sloyfe]++;
                led[2*sloyfe] = led[2*sloyfe+1] = 0;
                logg_inbrudd(logg_kr[sloyfe], timer.read(), 3.3*v_test);
            }
        }
    }
}


/* Funksjonen setter alle elementer fra 0-7 i array Led[] til 1 for å avslutte blinke sekvensen ettersom systemet blir satt til null.
Funksjonen logg_servicebryter blir kalt opp hvis variabele servicebryter er sann for å loggføre tid det har blitt utført en reset av systemet ved brukt 
av servicebryter. Stemmer ikke dette så blir det loggført at systemet har blitt nullstilt av bruker. */
void nullstilling(int servicebryter)
{
    pc2.printf("Alle kretser blir nullstilt i lopet av 5 sek.\n\r ");
    wait(5.0);
    for(int i = 0; i < 8; i++) {
        led[i] = 1;
    }
    pass_varsel.detach();
    if(servicebryter) {
    logg_servicebryter(timer.read());
    } else {
        logg_brukernullstill(timer.read());
        }
}


/* Funksjonen oppgir totalt antall brudd i hele systemet tilsammen, du velger selv hvilken krets du vil lese av status på.
Når du har valgt krets(et tall fra 1-4 får du oppgitt antall brudd i kretsen, hvor lenge den har hvert aktiv, spenning og om det er
utløst en alarm eller ikke. Verdien kr som blir satt inn i array krets|], inbrudd[] og trekker ifra 1 slikat du får riktig element som representerer den
kresten som du har valgt. Arrayet led[] kontrolleres senere for sjekke om det har blitt aktivert en alarm. */
void natid_status(int kr)
{
    int brudd;
    for(int i = 0; i < 4; i++) {
        brudd = brudd + inbrudd[i];
    }
    pc2.printf("\n\rTotalt antall brudd i system: %d.\n\r", brudd);
    float spenning = krets[kr-1]; //gjør det mulig å lese av spenning.
    pc2.printf("\n\rStatus for krets %d.\n\r", kr);
    pc2.printf("Antall brudd: %d.\n\r", inbrudd[kr-1]);
    pc2.printf("System aktivt: %.2f sekunder.\n\r", timer.read());
    pc2.printf("Spenning: %.2fV.\n\r", 3.3*spenning);
    if(led[(kr-1)*2] == 0 || led[kr*2-1] == 0) pc2.printf("Alarm aktiv.\n\r");
    else pc2.printf("Alarm ikke aktiv.\n\r");
}


/* Funksjonen blir kalt opp i en ticker på 10hz. Funksjonen henter verdiene fra arrayet led[] og setter det til kr_status[],
etter for-løkka har gått 8 ganger blir toggle som er satt til 0 invertert. Neste gang funksjonen blir kalt opp vil verdiene fra arrayet
led_pa[] satt til kr_status[]. Dette vil skape en blinke funksjon på baragraphen, slik at den veksler mellom 0 og 1 utifra de ulike elementene. */
void led_status()
{
    for(int i = 0; i < 8; i++) {
        if(toggle) {
            kr_status[i] = led[i];
        } else if(!toggle) {
            kr_status[i] = led_pa[i];
        }
    }
    toggle = !toggle;
}

/* Hvis det er tastet feil passord vil denne funksjonen sette alle elementene i led[] til 0 for å varsle om at 
alarmen har gått. */
void feil_passord()
{
    for(int i = 0; i < 8; i++) {
        led[i] = 0;
    }
    logg_feilpass();
}

void feil_pass()
{
    feil_passord();
    pass_varsel.attach(&led_status, 0.1);
}