
#include "mbed.h"
#include <stdio.h>
#include "loggforing.h"
#include "system.h"

Serial pc(USBTX,USBRX);
DigitalIn service(p12);
int a,sbryter;
int valg=1, casenummer=2;
int i,b=0,passforsok=0;
int antallbokstaver=0;
char passord[30]="NULL";    // array som vi lagrer det valgte passord
char pass[30];              // array som vi lagrer passordet vi tester mot valgte passord
void flushSerialBuffer(void);


int menyvalg,returnvalg,passriktig;
Timer t;
Ticker status;


void tilstand(int state)
{
    switch (state) {
        case 1:   // alarm på
            pc.printf("tilstand 1");
            systempaa();   /* Komplett funksjon for systempa, inkl, loggforing og varsling av krets. */
            break;
        case 2:  // alarm av
            pc.printf("tilstand 2");
            systemav();
            break;
        case 3:  // reset
            pc.printf("tilstand 3");
            nullstilling(sbryter);    /* Nullstiller hele systemet ved aktivering av servicebryter */
            t.stop();
            t.reset();
            state=2;
            sbryter=0;
            break;
        case 4:     //status
            pc.printf("Tast 1 for krets 1\n\r");
            pc.printf("Tast 2 for krets 2\n\r");
            pc.printf("Tast 3 for krets 3\n\r");
            pc.printf("Tast 4 for krets 4\n\r");
            pc.scanf("%d", &a);
            natid_status(a);/* Funksjon for å lese av nåværende status på valgt krets. */
            break;
        case 5:  // alarm gått
            feil_pass();
            valg=1;
            break;
        case 6:
            break;
            case 7:
            passord[0] = 'N';
            passord[1] = 'U';
            passord[2] = 'L';
            passord[3] = 'L';
            passord[4] = '\0';
            menyvalg=6;
            
    }
}


int main()
{
    while(1) 
    {
        switch (valg) {
                //Vi har valgt å bruke switch cases fordi dette gjør det lettere
                //å gå fram og tilbake avhengig av riktig eller galt passord.
            case 1:
                if(pc.readable()) {
                    if(pc.getc()==' ') {                                           // i case 1 er meny valgene man får, man lagrer da valget i en variabel
                        pc.printf("\n 1. Sett alarm paa\n\r.");             // som man setter i en annen switch case.
                        pc.printf("\n 2. Slaa av alarm.\n\r");
                        pc.printf("\n 3. Reset system\n\r");
                        pc.printf("\n 4. Status\n\r");
                        pc.printf("\n 5. Reset system\n\r");
                        pc.printf("\n 7. Skifte passord.\n\r");
                        pc.printf("\n skriv inn ditt valg:");
                        pc.scanf("%d",&menyvalg);  // menyvalg er det vi setter som valg i vår andre switch løkke til
                        valg=2;
                    }
                } else {
                    if(service==1) {
                        sbryter=1;
                        tilstand(3);
                        passforsok=0;
                        pc.printf("servicebryter aktiv");
                    } else {
                        tilstand(6);
                    }
                }
                break;
            case 2:
                while(1) {
                    if(!strcmp(passord,"NULL")) {                       // her tester vi om vi har tidligere satt et valgfritt passord
                        pc.printf("\n Skriv inn nytt passord: ");       // hvis ikke, vil vi gå inn her og lage et nytt passord.
                        //fflush(stdout);                               // dette gjør vi fordi hadde problemer med tera term og ville resette buffer.
                        antallbokstaver=0;
                        flushSerialBuffer();                            // bruker denne void for å flushe buffer fordi enter er lagret i bufferen etter menyen.
                        // og da gikk den inn i if passord=\r hver gang og breaket ut.
                        while(1) {
                            if(pc.readable()) {
                                passord[antallbokstaver]=pc.getc();     // I dette arrayet lagrer vi det valgte passordet.
                                if(passord[antallbokstaver]=='\r') {   // \r betyr carrage return og når vi trykker enter vil denne være aktiv
                                    passord[antallbokstaver]='\0';
                                    break;
                                }
                                antallbokstaver++;
                            }
                        }
                    } else {
                        t.start();
                        b=0;
                        printf("\n Skriv inn passord: ");
                        flushSerialBuffer();                        // bruker denne for å flushe input data fra tera term. Så vi
                        while( t < 31) {
                            // ikke direkte hopper inn i if setningen og breaker.
                            if(pc.readable()) {
                                pass[b]=pc.getc();
                                if(pass[b]=='\r') {
                                    valg=3;
                                    pass[b]='\0';
                                    b=0;
                                    break;
                                }
                                b++;
                            }
                        }
                        if(t>30) {
                            pc.printf("\n brukte for lang tid, alarm gatt \n\r");
                            valg=4;
                        }
                    }
                    break;
                }
                break;
            case 3: //testing av passord
                pc.printf("\n testing av passord\n\r");
                if( !strcmp(passord, pass)) {               // tester to array mot hverandre for å sjekke om disse er lik.
                    pass[0]='0';
                    valg=1;
                    t.stop();
                    t.reset();
                    pc.printf("\n passord er riktig\n\r");
                    passriktig=1;
                    passforsok=0;
                } else {
                    pc.printf("\n passord er feil\n\r");
                    valg=2;
                    passforsok++;
                    if(passforsok>=3) {
                        valg=4;
                    }
                    break;
                }
                break;
            case 4:
                tilstand(5);
                t.stop();
                t.reset();
                valg=1;
                break;
        }
        if(passriktig==1) {
            passriktig=0;
            tilstand(menyvalg);
            valg=1;
        }  
        
    }
}

void flushSerialBuffer(void)
{
    while (pc.readable()) {
        (void) pc.getc();
    }
    return;
}
