#include "mbed.h"
#include "Motor.h"
#include "battery_gauge_bq27441.h"
#include "rtos.h"

Serial blue(p13,p14);
Motor m1(p21, p19, p20); // pwm, fwd, rev
Motor m2(p22, p17, p18); // pwm, fwd, rev
DigitalOut myled(LED1);
DigitalOut myled2(LED2);

I2C i2C(p9, p10);
BatteryGaugeBq27441 gauge;
int32_t precentLeft;
int32_t battVoltage;
int32_t battCurrent;
int32_t battPower;

Thread t2;
Mutex mutex;

void threadPrintBattStats() {
    while (true) { 
        mutex.lock();
        gauge.getCurrent(&battCurrent);
        gauge.getRemainingPercentage(&precentLeft);
        gauge.getVoltage(&battVoltage);
        gauge.getPower(&battPower);
        
        blue.printf("%d%% %dmV %dmA %dmW\n",(int)precentLeft, (int)battVoltage, (int)battCurrent, (int)battPower);
        mutex.unlock();
        Thread::wait(500);
    }
}
    
int main()
{
    gauge.init(&i2C);
    gauge.enableGauge();
    t2.start(threadPrintBattStats);
    
    char bnum=0;
    char bhit=0;
    while(1) {
        while(!blue.readable()){
            Thread::yield();
            } //Let other threads run if no characters available
        
        mutex.lock();
        if (blue.getc()=='!') {
            if (blue.getc()=='B') { //button data packet
                bnum = blue.getc(); //button number
                bhit = blue.getc(); //1=hit, 0=release
                if (blue.getc()==char(~('!' + 'B' + bnum + bhit))) { //checksum OK?
                    mutex.unlock();
                    switch (bnum) {
                        case '5': //button 5 up arrow
                            if (bhit=='1') {
                                m1.speed(.5);
                                m2.speed(.5); 
                            } else {
                                m1.speed(0);
                                m2.speed(0); 
                            }
                            break;
                        case '6': //button 6 down arrow
                            if (bhit=='1') {
                                m1.speed(-.5);
                                m2.speed(-.5);
                            } else {
                                m1.speed(0);
                                m2.speed(0); 
                            }
                            break;
                        case '7': //button 7 left arrow
                            if (bhit=='1') {
                                m1.speed(0);
                                m2.speed(.5); 
                            } else {
                                m1.speed(0);
                                m2.speed(0); 
                            }
                            break;
                        case '8': //button 8 right arrow
                            if (bhit=='1') {
                                m1.speed(.5);
                                m2.speed(0); 
                            } else {
                                m1.speed(0);
                                m2.speed(0); 
                            }
                            break;
                        default:
                            break;
                    }
                }
            }
        }
    }
}